/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Window;
import javax.xml.bind.JAXBException;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoSliderboardWindowControllerInterface;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000ButtonController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000KnobController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000SliderController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.MidiChannelConfig;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class YoBCF2000SliderboardWindowController
implements YoSliderboardWindowControllerInterface {
    private static final String CONNECTED_STRING = "Connected to BCF2000 sliderboard";
    private static final String NOT_CONNECTED_STRING = "Not connected to BCF2000 sliderboard";
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private YoBCF2000KnobController knob0Controller;
    @FXML
    private YoBCF2000KnobController knob1Controller;
    @FXML
    private YoBCF2000KnobController knob2Controller;
    @FXML
    private YoBCF2000KnobController knob3Controller;
    @FXML
    private YoBCF2000KnobController knob4Controller;
    @FXML
    private YoBCF2000KnobController knob5Controller;
    @FXML
    private YoBCF2000KnobController knob6Controller;
    @FXML
    private YoBCF2000KnobController knob7Controller;
    @FXML
    private YoBCF2000ButtonController button0Controller;
    @FXML
    private YoBCF2000ButtonController button1Controller;
    @FXML
    private YoBCF2000ButtonController button2Controller;
    @FXML
    private YoBCF2000ButtonController button3Controller;
    @FXML
    private YoBCF2000ButtonController button4Controller;
    @FXML
    private YoBCF2000ButtonController button5Controller;
    @FXML
    private YoBCF2000ButtonController button6Controller;
    @FXML
    private YoBCF2000ButtonController button7Controller;
    @FXML
    private YoBCF2000ButtonController button8Controller;
    @FXML
    private YoBCF2000ButtonController button9Controller;
    @FXML
    private YoBCF2000ButtonController button10Controller;
    @FXML
    private YoBCF2000ButtonController button11Controller;
    @FXML
    private YoBCF2000ButtonController button12Controller;
    @FXML
    private YoBCF2000ButtonController button13Controller;
    @FXML
    private YoBCF2000ButtonController button14Controller;
    @FXML
    private YoBCF2000ButtonController button15Controller;
    @FXML
    private YoBCF2000SliderController slider0Controller;
    @FXML
    private YoBCF2000SliderController slider1Controller;
    @FXML
    private YoBCF2000SliderController slider2Controller;
    @FXML
    private YoBCF2000SliderController slider3Controller;
    @FXML
    private YoBCF2000SliderController slider4Controller;
    @FXML
    private YoBCF2000SliderController slider5Controller;
    @FXML
    private YoBCF2000SliderController slider6Controller;
    @FXML
    private YoBCF2000SliderController slider7Controller;
    @FXML
    private Label connectionStateLabel;
    @FXML
    private ImageView connectionStateImageView;
    private final StringProperty nameProperty = new SimpleStringProperty((Object)this, "name", null);
    private List<YoBCF2000KnobController> knobControllers;
    private List<YoBCF2000ButtonController> buttonControllers;
    private List<YoBCF2000SliderController> sliderControllers;
    private List<YoBCF2000InputController> allInputControllers;
    private BCF2000SliderboardController sliderboard;

    @Override
    public void initialize(Window owner, SessionVisualizerToolkit toolkit) {
        int i;
        this.knobControllers = Arrays.asList(this.knob0Controller, this.knob1Controller, this.knob2Controller, this.knob3Controller, this.knob4Controller, this.knob5Controller, this.knob6Controller, this.knob7Controller);
        this.buttonControllers = Arrays.asList(this.button0Controller, this.button1Controller, this.button2Controller, this.button3Controller, this.button4Controller, this.button5Controller, this.button6Controller, this.button7Controller, this.button8Controller, this.button9Controller, this.button10Controller, this.button11Controller, this.button12Controller, this.button13Controller, this.button14Controller, this.button15Controller);
        this.sliderControllers = Arrays.asList(this.slider0Controller, this.slider1Controller, this.slider2Controller, this.slider3Controller, this.slider4Controller, this.slider5Controller, this.slider6Controller, this.slider7Controller);
        this.allInputControllers = new ArrayList<YoBCF2000InputController>();
        this.allInputControllers.addAll(this.knobControllers);
        this.allInputControllers.addAll(this.buttonControllers);
        this.allInputControllers.addAll(this.sliderControllers);
        this.sliderboard = BCF2000SliderboardController.searchAndConnectToDevice();
        if (this.sliderboard == null) {
            LogTools.error((String)"Could not connect to BCF2000 sliderboard");
            this.connectionStateLabel.setText(NOT_CONNECTED_STRING);
            this.connectionStateImageView.setImage(SessionVisualizerIOTools.INVALID_ICON_IMAGE);
        } else {
            this.connectionStateLabel.setText(CONNECTED_STRING);
            this.connectionStateImageView.setImage(SessionVisualizerIOTools.VALID_ICON_IMAGE);
        }
        for (i = 0; i < this.knobControllers.size(); ++i) {
            YoBCF2000KnobController yoKnobController = this.knobControllers.get(i);
            SliderboardVariable knob = this.sliderboard == null ? null : this.sliderboard.getKnob(BCF2000SliderboardController.BCF2000Knob.values[i]);
            yoKnobController.initialize(toolkit, (MidiChannelConfig)BCF2000SliderboardController.BCF2000Knob.values[i], knob);
        }
        for (i = 0; i < this.buttonControllers.size(); ++i) {
            YoBCF2000ButtonController yoButtonController = this.buttonControllers.get(i);
            SliderboardVariable button = this.sliderboard == null ? null : this.sliderboard.getButton(BCF2000SliderboardController.BCF2000Button.values[i]);
            yoButtonController.initialize(toolkit, (MidiChannelConfig)BCF2000SliderboardController.BCF2000Button.values[i], button);
        }
        for (i = 0; i < this.sliderControllers.size(); ++i) {
            YoBCF2000SliderController yoSliderController = this.sliderControllers.get(i);
            SliderboardVariable slider = this.sliderboard == null ? null : this.sliderboard.getSlider(BCF2000SliderboardController.BCF2000Slider.values[i]);
            yoSliderController.initialize(toolkit, (MidiChannelConfig)BCF2000SliderboardController.BCF2000Slider.values[i], slider);
        }
    }

    @Override
    public void load(File file) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoSliderboardListDefinition definition = XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file));
            if (definition.getYoSliderboards() == null || definition.getYoSliderboards().isEmpty()) {
                return;
            }
            this.setInput((YoSliderboardDefinition)definition.getYoSliderboards().get(0));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save(File file) {
        LogTools.info((String)("Saving to file: " + file));
        try {
            XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), new YoSliderboardListDefinition(null, this.toYoSliderboardDefinition()));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setInput(YoSliderboardDefinition input) {
        List sliders;
        List buttons;
        List knobs;
        if (input.getType() != YoSliderboardType.BCF2000) {
            throw new RuntimeException("Invalid definition type: " + input.getType());
        }
        this.clear();
        if (input.getName() != null) {
            this.nameProperty.set((Object)input.getName());
        }
        if ((knobs = input.getKnobs()) != null) {
            for (int i = 0; i < knobs.size(); ++i) {
                YoKnobDefinition knob = (YoKnobDefinition)knobs.get(i);
                if (knob.getIndex() == -1) {
                    this.knobControllers.get(i).setInput(knob);
                    continue;
                }
                this.knobControllers.get(knob.getIndex()).setInput(knob);
            }
        }
        if ((buttons = input.getButtons()) != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                YoButtonDefinition button = (YoButtonDefinition)buttons.get(i);
                if (button.getIndex() == -1) {
                    this.buttonControllers.get(i).setInput(button);
                    continue;
                }
                this.buttonControllers.get(button.getIndex()).setInput(button);
            }
        }
        if ((sliders = input.getSliders()) != null) {
            for (int i = 0; i < sliders.size(); ++i) {
                YoSliderDefinition slider = (YoSliderDefinition)sliders.get(i);
                if (slider.getIndex() == -1) {
                    this.sliderControllers.get(i).setInput(slider);
                    continue;
                }
                this.sliderControllers.get(slider.getIndex()).setInput(slider);
            }
        }
    }

    @Override
    public void setButtonInput(YoButtonDefinition buttonDefinition) {
        if (buttonDefinition.getIndex() < 0 || buttonDefinition.getIndex() >= this.buttonControllers.size()) {
            LogTools.error((String)"Illegal button index: {}, expected in range: [0, {}[", (Object)buttonDefinition.getIndex(), (Object)this.buttonControllers.size());
            return;
        }
        YoBCF2000ButtonController buttonController = this.buttonControllers.get(buttonDefinition.getIndex());
        buttonController.setInput(buttonDefinition);
    }

    @Override
    public void removeButtonInput(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttonControllers.size()) {
            LogTools.error((String)"Illegal button index: {}, expected in range: [0, {}[", (Object)buttonIndex, (Object)this.buttonControllers.size());
            return;
        }
        this.buttonControllers.get(buttonIndex).clear();
    }

    @Override
    public void setKnobInput(YoKnobDefinition knobDefinition) {
        if (knobDefinition.getIndex() < 0 || knobDefinition.getIndex() >= this.knobControllers.size()) {
            LogTools.error((String)"Illegal knob index: {}, expected in range: [0, {}[", (Object)knobDefinition.getIndex(), (Object)this.knobControllers.size());
            return;
        }
        YoBCF2000KnobController knobController = this.knobControllers.get(knobDefinition.getIndex());
        knobController.setInput(knobDefinition);
    }

    @Override
    public void removeKnobInput(int knobIndex) {
        if (knobIndex < 0 || knobIndex >= this.knobControllers.size()) {
            LogTools.error((String)"Illegal knob index: {}, expected in range: [0, {}[", (Object)knobIndex, (Object)this.knobControllers.size());
            return;
        }
        this.knobControllers.get(knobIndex).clear();
    }

    @Override
    public void setSliderInput(YoSliderDefinition sliderDefinition) {
        if (sliderDefinition.getIndex() < 0 || sliderDefinition.getIndex() >= this.sliderControllers.size()) {
            LogTools.error((String)"Illegal slider index: {}, expected in range: [0, {}[", (Object)sliderDefinition.getIndex(), (Object)this.sliderControllers.size());
            return;
        }
        YoBCF2000SliderController sliderController = this.sliderControllers.get(sliderDefinition.getIndex());
        sliderController.setInput(sliderDefinition);
    }

    @Override
    public void removeSliderInput(int sliderIndex) {
        if (sliderIndex < 0 || sliderIndex >= this.sliderControllers.size()) {
            LogTools.error((String)"Illegal slider index: {}, expected in range: [0, {}[", (Object)sliderIndex, (Object)this.sliderControllers.size());
            return;
        }
        this.sliderControllers.get(sliderIndex).clear();
    }

    @Override
    public void clear() {
        for (YoBCF2000InputController controller : this.allInputControllers) {
            controller.clear();
        }
    }

    @Override
    public void start() {
        if (this.sliderboard != null) {
            this.sliderboard.start();
        }
    }

    @Override
    public void stop() {
        if (this.sliderboard != null) {
            this.sliderboard.stop();
        }
    }

    @Override
    public void close() {
        this.stop();
        this.clear();
        if (this.sliderboard != null) {
            this.sliderboard.closeAndDispose();
        }
    }

    @Override
    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    @Override
    public YoSliderboardDefinition toYoSliderboardDefinition() {
        YoSliderboardDefinition definition = new YoSliderboardDefinition();
        definition.setName((String)this.nameProperty.get());
        definition.setType(YoSliderboardType.BCF2000);
        definition.setKnobs(this.knobControllers.stream().map(YoBCF2000KnobController::toYoKnobDefinition).collect(Collectors.toList()));
        definition.setButtons(this.buttonControllers.stream().map(YoBCF2000ButtonController::toYoButtonDefinition).collect(Collectors.toList()));
        definition.setSliders(this.sliderControllers.stream().map(YoBCF2000SliderController::toYoSliderDefinition).collect(Collectors.toList()));
        return definition;
    }

    @Override
    public boolean isEmpty() {
        for (YoBCF2000InputController controller : this.allInputControllers) {
            if (controller.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public YoSliderboardType getType() {
        return YoSliderboardType.BCF2000;
    }
}

