/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;
import us.ihmc.scs2.simulation.shapes.STPShape3DTools;

public class YoSTPBoxFX3D
extends YoGraphicFX3D {
    private final MeshView boxNode = new MeshView();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private Tuple3DProperty size = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private DoubleProperty minimumMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty maximumMargin = new SimpleDoubleProperty(0.0);
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();
    private STPBoxData newData = null;
    private STPBoxData oldData = null;
    private Mesh newMesh = null;
    private boolean clearMesh = false;

    public YoSTPBoxFX3D() {
        this.boxNode.setMaterial((Material)this.material);
        this.boxNode.getTransforms().add((Object)this.affine);
        this.boxNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.boxNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoSTPBoxFX3D(ReferenceFrameWrapper worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
        this.size.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.orientation.containsNaN() || this.size.containsNaN()) {
            this.boxNode.setMesh(null);
            this.oldData = null;
            return;
        }
        this.newData = YoSTPBoxFX3D.newSTPBoxData(this.size, this.minimumMargin, this.maximumMargin);
        this.affine.setToTransform((Transform)JavaFXMissingTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = new SimpleColorFX();
        }
        this.material.setDiffuseColor(this.color.get());
        if (this.clearMesh) {
            this.clearMesh = false;
            this.boxNode.setMesh(null);
        }
        if (this.newMesh != null) {
            this.boxNode.setMesh(this.newMesh);
            this.newMesh = null;
        }
    }

    @Override
    public void computeBackground() {
        STPBoxData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.size == null) {
            this.clearMesh = true;
            return;
        }
        if (newDataLocal.equals(this.oldData) && this.boxNode.getMesh() != null) {
            return;
        }
        try {
            newDataLocal.computeRadii();
            this.newMesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.toSTPBox3DMesh(null, (Tuple3DReadOnly)newDataLocal.size, (double)newDataLocal.smallRadius, (double)newDataLocal.largeRadius, (boolean)false));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        this.oldData = newDataLocal;
    }

    static STPBoxData newSTPBoxData(Tuple3DProperty size, DoubleProperty minimumMargin, DoubleProperty maximumMargin) {
        STPBoxData data = new STPBoxData();
        if (YoGraphicTools.isAnyNull(size, minimumMargin, maximumMargin)) {
            return data;
        }
        data.size = new Vector3D((Tuple3DReadOnly)size);
        data.minimumMargin = minimumMargin.get();
        data.maximumMargin = maximumMargin.get();
        return data;
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.size = null;
        this.color = null;
    }

    @Override
    public YoSTPBoxFX3D clone() {
        YoSTPBoxFX3D clone = new YoSTPBoxFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setSize(new Tuple3DProperty(this.size));
        clone.setMinimumMargin(this.minimumMargin);
        clone.setMaximumMargin(this.maximumMargin);
        clone.setColor(this.color);
        return clone;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setSize(Tuple3DProperty size) {
        this.size = size;
    }

    public void setMinimumMargin(DoubleProperty minimumMargin) {
        this.minimumMargin = minimumMargin;
    }

    public void setMinimumMargin(double minimumMargin) {
        this.setMinimumMargin((DoubleProperty)new SimpleDoubleProperty(minimumMargin));
    }

    public void setMaximumMargin(DoubleProperty maximumMargin) {
        this.maximumMargin = maximumMargin;
    }

    public void setMaximumMargin(double maximumMargin) {
        this.setMaximumMargin((DoubleProperty)new SimpleDoubleProperty(maximumMargin));
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public Tuple3DProperty getSize() {
        return this.size;
    }

    public DoubleProperty getMinimumMargin() {
        return this.minimumMargin;
    }

    public DoubleProperty getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public Node getNode() {
        return this.boxNode;
    }

    private static class STPBoxData {
        private Vector3DReadOnly size;
        private double minimumMargin;
        private double maximumMargin;
        private boolean radiiDirty = true;
        private double smallRadius;
        private double largeRadius;

        private STPBoxData() {
        }

        public void computeRadii() {
            if (this.radiiDirty) {
                this.radiiDirty = false;
                this.smallRadius = this.minimumMargin;
                this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins((double)this.minimumMargin, (double)this.maximumMargin, (double)STPShape3DTools.computeBox3DMaximumEdgeLengthSquared((Vector3DReadOnly)this.size));
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof STPBoxData) {
                STPBoxData other = (STPBoxData)object;
                if (this.size == null ? other.size != null : !this.size.equals((EuclidGeometry)other.size)) {
                    return false;
                }
                if (this.minimumMargin != other.minimumMargin) {
                    return false;
                }
                return this.maximumMargin == other.maximumMargin;
            }
            return false;
        }
    }
}

