/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.chart.FastAxisBase;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Pair;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.javaFXExtensions.chart.FastNumberAxis;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoChart.ChartDoubleBoundsDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartConfigurationDefinition;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIntegerBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicChartLegend;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.YoVariableChartData;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartOptionController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoNumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartDataManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoChartPanelController
extends ObservedAnimationTimer
implements VisualizerController {
    private static final long LEGEND_UPDATE_PERIOD = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final String INPOINT_MARKER_STYLECLASS = "chart-inpoint-marker";
    private static final String OUTPOINT_MARKER_STYLECLASS = "chart-outpoint-marker";
    private static final String CURRENT_INDEX_MARKER_STYLECLASS = "chart-current-index-marker";
    private static final String ORIGIN_MARKER_STYLECLASS = "chart-origin-marker";
    private static final String KEYFRAME_MARKER_STYLECLASS = "chart-keyframe-marker";
    private static final String USER_MARKER_STYLECLASS = "chart-user-marker";
    @FXML
    private AnchorPane chartMainPane;
    @FXML
    private Button closeButton;
    @FXML
    private FontAwesomeIconView chartMoveIcon;
    private DynamicLineChart dynamicLineChart;
    private final ChartMarker inPointMarker = new ChartMarker((DoubleProperty)new SimpleDoubleProperty((Object)this, "inPointMarkerCoordinate", 0.0));
    private final ChartMarker outPointMarker = new ChartMarker((DoubleProperty)new SimpleDoubleProperty((Object)this, "outPointMarkerCoordinate", 0.0));
    private final ChartMarker bufferIndexMarker = new ChartMarker((DoubleProperty)new SimpleDoubleProperty((Object)this, "bufferIndexMarkerCoordinate", 0.0));
    private final ObservableList<ChartMarker> userMarkers = FXCollections.observableArrayList();
    private final ObservableList<ChartMarker> keyFrameMarkers = FXCollections.observableArrayList();
    private YoCompositeSearchManager yoCompositeSearchManager;
    private final BooleanProperty useUniqueNames = new SimpleBooleanProperty((Object)this, "useUniqueNames", false);
    private Property<Integer> legendPrecision;
    private ChartDataManager chartDataManager;
    private final ObservableList<YoNumberSeries> yoNumberSeriesList = FXCollections.observableArrayList();
    private final ObservableMap<YoVariable, YoVariableChartPackage> charts = FXCollections.observableMap(new LinkedHashMap());
    private final ObservableSet<YoVariable> plottedVariables = FXCollections.observableSet(new LinkedHashSet());
    private YoBufferPropertiesReadOnly lastBufferProperties = null;
    private AtomicReference<YoBufferPropertiesReadOnly> newBufferProperties;
    private final TopicListener<int[]> keyFrameMarkerListener = this::updateKeyFrameMarkers;
    private AtomicReference<List<String>> yoCompositeSelected;
    private MessagerAPIFactory.Topic<List<String>> yoCompositeSelectedTopic;
    private final SimpleObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "graphContextMenu", null);
    private Border defaultBorder = null;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private YoManager yoManager;
    private SessionVisualizerWindowToolkit toolkit;
    private final ObjectProperty<YoChartOptionController> activeChartOptionControllerProperty = new SimpleObjectProperty((Object)this, "activeChartOptionController", null);
    private long legendUpdateLastTime = -1L;
    private Point2D lastMouseScreenPosition = null;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.messager = toolkit.getMessager();
        this.chartDataManager = toolkit.getChartDataManager();
        this.yoManager = toolkit.getYoManager();
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.topics = toolkit.getTopics();
        BackgroundExecutorManager backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.newBufferProperties = this.messager.createInput(this.topics.getYoBufferCurrentProperties());
        this.legendPrecision = this.messager.createPropertyInput(this.topics.getControlsNumberPrecision(), (Object)5);
        this.dynamicLineChart = new DynamicLineChart((FastAxisBase)new FastNumberAxis(0.0, 0.0), (FastAxisBase)new FastNumberAxis(), backgroundExecutorManager::executeInBackground, toolkit.getChartRenderManager());
        this.dynamicLineChart.markerAutoUpdateProperty().set(false);
        this.chartMainPane.getChildren().add(0, (Object)this.dynamicLineChart);
        AnchorPane.setTopAnchor((Node)this.dynamicLineChart, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.dynamicLineChart, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.dynamicLineChart, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.dynamicLineChart, (Double)0.0);
        ChangeListener xAxisChangeListener = (o, oldAxis, newAxis) -> {
            newAxis.setLowerBound(-1.0);
            newAxis.setAutoRanging(false);
            newAxis.setMinorTickVisible(false);
            newAxis.setTickMarkVisible(true);
            newAxis.setAnimated(false);
        };
        this.dynamicLineChart.xAxisProperty().addListener(xAxisChangeListener);
        xAxisChangeListener.changed(null, null, (Object)this.dynamicLineChart.getXAxis());
        ChangeListener yAxisListener = (o, oldAxis, newAxis) -> {
            newAxis.setAutoRanging(true);
            newAxis.setForceZeroInRange(false);
            newAxis.setMinorTickVisible(false);
            newAxis.setTickMarkVisible(true);
            newAxis.setTickLabelsVisible(true);
            newAxis.setAnimated(false);
        };
        this.dynamicLineChart.yAxisProperty().addListener(yAxisListener);
        yAxisListener.changed(null, null, (Object)this.dynamicLineChart.getYAxis());
        this.inPointMarker.getStyleClass().add((Object)INPOINT_MARKER_STYLECLASS);
        this.outPointMarker.getStyleClass().add((Object)OUTPOINT_MARKER_STYLECLASS);
        this.bufferIndexMarker.getStyleClass().add((Object)CURRENT_INDEX_MARKER_STYLECLASS);
        this.dynamicLineChart.addMarker(this.inPointMarker);
        this.dynamicLineChart.addMarker(this.outPointMarker);
        this.dynamicLineChart.addMarker(this.bufferIndexMarker);
        this.userMarkers.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ChartMarker newMarker : change.getAddedSubList()) {
                        this.dynamicLineChart.addMarker(newMarker);
                        if (newMarker.getStyleClass().contains((Object)USER_MARKER_STYLECLASS)) continue;
                        newMarker.getStyleClass().add((Object)USER_MARKER_STYLECLASS);
                    }
                }
                if (!change.wasRemoved()) continue;
                for (ChartMarker oldMarker : change.getRemoved()) {
                    this.dynamicLineChart.removeMarker(oldMarker);
                }
            }
        });
        this.keyFrameMarkers.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (ChartMarker newMarker : change.getAddedSubList()) {
                        this.dynamicLineChart.addMarker(newMarker);
                    }
                }
                if (!change.wasRemoved()) continue;
                for (ChartMarker oldMarker : change.getRemoved()) {
                    this.dynamicLineChart.removeMarker(oldMarker);
                }
            }
        });
        ChartMarker originMarker = new ChartMarker((DoubleProperty)new SimpleDoubleProperty((Object)this, "origin", 0.0));
        ChangeListener originMarkerUpdater = (o, oldValue, newValue) -> {
            if (newValue == DynamicLineChart.ChartStyle.RAW) {
                this.dynamicLineChart.addMarker(originMarker);
                originMarker.getStyleClass().add((Object)ORIGIN_MARKER_STYLECLASS);
            } else {
                this.dynamicLineChart.removeMarker(originMarker);
            }
        };
        this.dynamicLineChart.chartStyleProperty().addListener(originMarkerUpdater);
        originMarkerUpdater.changed(null, null, this.dynamicLineChart.chartStyleProperty().get());
        this.dynamicLineChart.setOnDragDetected(this::handleDragDetected);
        this.dynamicLineChart.setOnDragOver(this::handleDragOver);
        this.dynamicLineChart.setOnDragDropped(this::handleDragDropped);
        this.dynamicLineChart.setOnDragEntered(this::handleDragEntered);
        this.dynamicLineChart.setOnDragExited(this::handleDragExited);
        this.dynamicLineChart.setOnMousePressed(this::handleMousePressed);
        this.dynamicLineChart.setOnMouseDragged(this::handleMouseDrag);
        this.dynamicLineChart.setOnMouseReleased(this::handleMouseReleased);
        this.dynamicLineChart.setOnScroll(this::handleScroll);
        this.contextMenuProperty.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.hide();
            }
        });
        this.charts.addListener(change -> {
            if (change.wasAdded()) {
                this.plottedVariables.add((Object)((YoVariableChartPackage)change.getValueAdded()).getYoVariable());
                this.yoNumberSeriesList.add((Object)((YoVariableChartPackage)change.getValueAdded()).getSeries());
            } else if (change.wasRemoved()) {
                this.plottedVariables.remove((Object)((YoVariableChartPackage)change.getValueRemoved()).getYoVariable());
                this.yoNumberSeriesList.remove((Object)((YoVariableChartPackage)change.getValueRemoved()).getSeries());
            }
            JavaFXMissingTools.runNFramesLater(1, () -> this.charts.values().forEach(YoVariableChartPackage::updateLegend));
        });
        this.messager.addFXTopicListener(this.topics.getCurrentKeyFrames(), this.keyFrameMarkerListener);
        this.messager.addFXTopicListener(this.topics.getSessionCurrentMode(), m -> this.dynamicLineChart.updateIndexMarkersVisible().set(m == SessionMode.RUNNING));
        this.messager.submitMessage(this.topics.getRequestCurrentKeyFrames(), new Object());
        this.messager = toolkit.getMessager();
        this.yoCompositeSelectedTopic = toolkit.getTopics().getYoCompositeSelected();
        this.yoCompositeSelected = this.messager.createInput(this.yoCompositeSelectedTopic);
        ChangeListener<Border> borderInitializer = new ChangeListener<Border>(){

            public void changed(ObservableValue<? extends Border> o, Border oldValue, Border newValue) {
                YoChartPanelController.this.defaultBorder = newValue;
                YoChartPanelController.this.dynamicLineChart.borderProperty().removeListener((ChangeListener)this);
            }
        };
        this.dynamicLineChart.borderProperty().addListener((ChangeListener)borderInitializer);
    }

    public void setChartConfiguration(YoChartConfigurationDefinition definition) {
        this.clear();
        if (definition == null) {
            return;
        }
        if (definition.getYoVariables() == null) {
            this.dynamicLineChart.setChartStyle(DynamicLineChart.ChartStyle.RAW);
            return;
        }
        definition.getYoVariables().forEach(this::addYoVariableToPlot);
        if (definition.getChartStyle() != null) {
            try {
                this.dynamicLineChart.setChartStyle(DynamicLineChart.ChartStyle.valueOf(definition.getChartStyle()));
            }
            catch (IllegalArgumentException e) {
                this.dynamicLineChart.setChartStyle(DynamicLineChart.ChartStyle.RAW);
            }
        } else {
            this.dynamicLineChart.setChartStyle(DynamicLineChart.ChartStyle.RAW);
        }
        for (YoVariableChartPackage pack : this.charts.values()) {
            int definitionIndex = definition.getYoVariables().indexOf(pack.getYoVariable().getFullNameString());
            if (definitionIndex == -1) continue;
            if (definition.getYBounds() != null && definition.getYBounds().size() > definitionIndex) {
                ChartDoubleBoundsDefinition yBounds = (ChartDoubleBoundsDefinition)definition.getYBounds().get(definitionIndex);
                pack.series.setCustomYBounds(ChartTools.toChartDoubleBounds(yBounds));
            }
            if (definition.getNegates() == null || definition.getNegates().size() <= definitionIndex) continue;
            Boolean negate = (Boolean)definition.getNegates().get(definitionIndex);
            pack.series.setNegated(negate);
        }
    }

    @FXML
    public void openChartOptionDialog() {
        if (this.activeChartOptionControllerProperty.get() != null) {
            ((YoChartOptionController)this.activeChartOptionControllerProperty.get()).setInput(this.yoNumberSeriesList, this.dynamicLineChart.chartStyleProperty(), this.userMarkers);
            ((YoChartOptionController)this.activeChartOptionControllerProperty.get()).showWindow();
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_OPTION_DIALOG_URL);
            loader.load();
            YoChartOptionController controller = (YoChartOptionController)loader.getController();
            controller.initialize(this.toolkit);
            controller.setInput(this.yoNumberSeriesList, this.dynamicLineChart.chartStyleProperty(), this.userMarkers);
            this.activeChartOptionControllerProperty.set((Object)controller);
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        new ArrayList<YoVariable>(this.charts.keySet()).forEach(this::removeYoVariableFromPlot);
    }

    public void addYoVariableToPlot(String yoVariableFullName) {
        YoVariable yoVariable = this.yoManager.searchYoVariable(yoVariableFullName);
        if (yoVariable != null) {
            this.addYoVariableToPlot(yoVariable);
        }
    }

    public void addYoVariableToPlot(YoVariable yoVariable) {
        if (this.charts.containsKey((Object)yoVariable)) {
            return;
        }
        this.charts.put((Object)yoVariable, (Object)new YoVariableChartPackage(yoVariable, this.yoCompositeSearchManager.getYoVariableCollection().getYoVariableUniqueName(yoVariable)));
    }

    public void addYoVariablesToPlot(Collection<? extends YoVariable> yoVariables) {
        yoVariables.forEach(this::addYoVariableToPlot);
    }

    public void addYoCompositeToPlot(YoComposite yoComposite) {
        this.addYoVariablesToPlot(yoComposite.getYoComponents());
    }

    public void removeYoVariableFromPlot(String yoVariableFullName) {
        this.removeYoVariableFromPlot(this.yoManager.getRootRegistry().getVariable(yoVariableFullName));
    }

    public void removeYoVariableFromPlot(YoVariable yoVariable) {
        YoVariableChartPackage chart = (YoVariableChartPackage)this.charts.remove((Object)yoVariable);
        if (chart != null) {
            chart.close();
        }
    }

    public void closeAndDispose() {
        this.stop();
        if (this.activeChartOptionControllerProperty.get() != null) {
            ((YoChartOptionController)this.activeChartOptionControllerProperty.get()).close();
        }
        ArrayList<YoVariableChartPackage> chartsCopy = new ArrayList<YoVariableChartPackage>(this.charts.values());
        this.charts.clear();
        chartsCopy.forEach(YoVariableChartPackage::close);
        this.messager.removeInput(this.topics.getYoBufferCurrentProperties(), this.newBufferProperties);
        this.messager.removeFXTopicListener(this.topics.getCurrentKeyFrames(), this.keyFrameMarkerListener);
    }

    public boolean isEmpty() {
        return this.charts.isEmpty();
    }

    private void updateKeyFrameMarkers(int[] newKeyFrames) {
        this.keyFrameMarkers.clear();
        if (newKeyFrames == null) {
            return;
        }
        for (int keyFrame : newKeyFrames) {
            ChartMarker newMarker = new ChartMarker((DoubleProperty)new SimpleDoubleProperty((Object)this, "keyFrameMarkerCoordinate" + this.keyFrameMarkers.size(), (double)keyFrame));
            newMarker.getStyleClass().add((Object)KEYFRAME_MARKER_STYLECLASS);
            this.keyFrameMarkers.add((Object)newMarker);
        }
    }

    @Override
    public void handleImpl(long now) {
        ChartIntegerBounds chartsBounds = (ChartIntegerBounds)this.toolkit.getChartZoomManager().chartBoundsProperty().getValue();
        YoBufferPropertiesReadOnly bufferProperties = this.newBufferProperties.getAndSet(null);
        FastAxisBase xAxis = this.dynamicLineChart.getXAxis();
        if (bufferProperties != null) {
            boolean updateLegends;
            this.lastBufferProperties = bufferProperties;
            if (bufferProperties.getInPoint() != this.inPointMarker.coordinateProperty().intValue()) {
                this.inPointMarker.setCoordinate(bufferProperties.getInPoint());
            }
            if (bufferProperties.getOutPoint() != this.outPointMarker.coordinateProperty().intValue()) {
                this.outPointMarker.setCoordinate(bufferProperties.getOutPoint());
            }
            if (bufferProperties.getCurrentIndex() != this.bufferIndexMarker.coordinateProperty().intValue()) {
                this.bufferIndexMarker.setCoordinate(bufferProperties.getCurrentIndex());
            }
            if (chartsBounds == null) {
                double scale = 0.001;
                xAxis.setLowerBound(-scale * (double)bufferProperties.getSize());
                xAxis.setUpperBound((1.0 + scale) * (double)bufferProperties.getSize());
            }
            boolean bl = updateLegends = this.legendUpdateLastTime == -1L || now - this.legendUpdateLastTime >= LEGEND_UPDATE_PERIOD;
            if (updateLegends) {
                this.legendUpdateLastTime = now;
                this.charts.values().forEach(YoVariableChartPackage::updateLegend);
            }
            bufferProperties = null;
        }
        if (chartsBounds != null) {
            double scale = 0.001;
            xAxis.setLowerBound((double)chartsBounds.getLower() - scale * (double)chartsBounds.length());
            xAxis.setUpperBound((double)chartsBounds.getUpper() + scale * (double)chartsBounds.length());
        }
        this.charts.values().forEach(YoVariableChartPackage::updateChart);
        if (!this.dynamicLineChart.markerAutoUpdateProperty().get()) {
            this.dynamicLineChart.updateMarkers();
        }
    }

    private ContextMenu newGraphContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        for (YoVariableChartPackage chartPackage : this.charts.values()) {
            MenuItem menuItem = new MenuItem("Remove " + chartPackage.getSeries().getSeriesName());
            menuItem.setMnemonicParsing(false);
            menuItem.setOnAction(e -> this.removeYoVariableFromPlot(chartPackage.getYoVariable()));
            contextMenu.getItems().add((Object)menuItem);
        }
        boolean isYAxisVisible = !(this.dynamicLineChart.getYAxis() instanceof FastNumberAxis);
        MenuItem yAxisVisibleItem = new MenuItem(isYAxisVisible ? "Hide y-axis" : "Show y-axis");
        yAxisVisibleItem.setOnAction(e -> {
            if (isYAxisVisible) {
                this.dynamicLineChart.setYAxis((FastAxisBase)new FastNumberAxis());
            } else {
                this.dynamicLineChart.setYAxis(FastAxisBase.wrap((NumberAxis)new NumberAxis()));
            }
        });
        contextMenu.getItems().add((Object)yAxisVisibleItem);
        return contextMenu;
    }

    private void hideContextMenu() {
        if (this.contextMenuProperty.get() != null) {
            this.contextMenuProperty.set(null);
        }
    }

    private void handleMousePressed(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            this.hideContextMenu();
            if (this.lastBufferProperties != null) {
                Node intersectedNode = event.getPickResult().getIntersectedNode();
                if (intersectedNode == null || intersectedNode instanceof DynamicChartLegend || intersectedNode instanceof Text || intersectedNode instanceof Label) {
                    return;
                }
                int index = this.screenToBufferIndex(event.getScreenX(), event.getScreenY());
                this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)index);
                event.consume();
            }
        } else if (event.isMiddleButtonDown() && event.getPickResult().getIntersectedNode() instanceof Text) {
            String pickedName = ((Text)event.getPickResult().getIntersectedNode()).getText();
            Optional<YoVariableChartPackage> chartData = this.charts.values().stream().filter(dataPackage -> dataPackage.series.getSeriesName().equals(pickedName)).findFirst();
            if (chartData.isPresent()) {
                this.removeYoVariableFromPlot(chartData.get().getYoVariable());
                this.messager.submitMessage(this.topics.getYoCompositeSelected(), Arrays.asList(YoCompositeTools.YO_VARIABLE, null));
            }
        }
    }

    private void handleMouseDrag(MouseEvent event) {
        this.handleMousePressed(event);
        if (event.isSecondaryButtonDown()) {
            Point2D newMouseScreenPosition = new Point2D(event.getScreenX(), event.getScreenY());
            if (!event.isStillSincePress()) {
                this.hideContextMenu();
                if (this.lastMouseScreenPosition != null) {
                    int drag = this.screenToBufferIndex((Tuple2DReadOnly)this.lastMouseScreenPosition) - this.screenToBufferIndex((Tuple2DReadOnly)newMouseScreenPosition);
                    this.messager.submitMessage(this.topics.getYoChartRequestShift(), (Object)new Pair((Object)this.toolkit.getWindow(), (Object)drag));
                }
            }
            this.lastMouseScreenPosition = newMouseScreenPosition;
            event.consume();
        }
    }

    private void handleMouseReleased(MouseEvent event) {
        YoComposite yoComposite;
        String fullname;
        String type;
        if (event.getButton() == MouseButton.PRIMARY) {
            Node intersectedNode;
            if (event.isStillSincePress() && (intersectedNode = event.getPickResult().getIntersectedNode()) instanceof Text) {
                Text legend = (Text)intersectedNode;
                String yoVariableName = legend.getText().split("\\s+")[0];
                YoVariable yoVariableSelected = this.charts.keySet().stream().filter(yoVariable -> yoVariable.getName().equals(yoVariableName)).findFirst().orElse(null);
                if (yoVariableSelected == null) {
                    return;
                }
                this.messager.submitMessage(this.yoCompositeSelectedTopic, Arrays.asList(YoCompositeTools.YO_VARIABLE, yoVariableSelected.getFullNameString()));
            }
        } else if (event.getButton() == MouseButton.SECONDARY) {
            this.lastMouseScreenPosition = null;
            if (event.isStillSincePress()) {
                ContextMenu contextMenu = this.newGraphContextMenu();
                if (!contextMenu.getItems().isEmpty()) {
                    this.contextMenuProperty.set((Object)contextMenu);
                    contextMenu.show((Node)this.dynamicLineChart, event.getScreenX(), event.getScreenY());
                }
                event.consume();
            }
        } else if (event.getButton() == MouseButton.MIDDLE && this.yoCompositeSelected.get() != null && YoCompositeTools.YO_VARIABLE.equals(type = this.yoCompositeSelected.get().get(0)) && (fullname = this.yoCompositeSelected.get().get(1)) != null && (yoComposite = this.yoCompositeSearchManager.getYoComposite(type, fullname)) != null) {
            this.addYoCompositeToPlot(yoComposite);
            this.messager.submitMessage(this.yoCompositeSelectedTopic, null);
        }
    }

    private int screenToBufferIndex(Tuple2DReadOnly screenPosition) {
        return this.screenToBufferIndex(screenPosition.getX(), screenPosition.getY());
    }

    private int screenToBufferIndex(double screenX, double screenY) {
        if (this.lastBufferProperties == null) {
            return -1;
        }
        FastAxisBase xAxis = this.dynamicLineChart.getXAxis();
        double xLocal = xAxis.screenToLocal(screenX, screenY).getX();
        int index = (int)Math.round(xAxis.getValueForDisplay(xLocal));
        return MathTools.clamp((int)index, (int)0, (int)(this.lastBufferProperties.getSize() - 1));
    }

    private void handleScroll(ScrollEvent event) {
        if (this.lastBufferProperties != null) {
            int scrollDelta;
            int n = scrollDelta = event.isControlDown() ? 10 : 1;
            if (event.getDeltaY() == 0.0) {
                return;
            }
            this.hideContextMenu();
            if (event.getDeltaY() < 0.0) {
                this.messager.submitMessage(this.topics.getYoBufferDecrementCurrentIndexRequest(), (Object)scrollDelta);
            } else {
                this.messager.submitMessage(this.topics.getYoBufferIncrementCurrentIndexRequest(), (Object)scrollDelta);
            }
        }
    }

    public void handleDragDetected(MouseEvent event) {
        if (event == null || !event.isPrimaryButtonDown()) {
            return;
        }
        PickResult pickResult = event.getPickResult();
        if (pickResult == null) {
            return;
        }
        Node intersectedNode = pickResult.getIntersectedNode();
        if (intersectedNode == null) {
            return;
        }
        if (intersectedNode instanceof Text) {
            Text legend = (Text)intersectedNode;
            String pickedName = legend.getText().split("\\s+")[0];
            Optional<YoVariableChartPackage> chartData = this.charts.values().stream().filter(dataPackage -> dataPackage.series.getSeriesName().equals(pickedName)).findFirst();
            if (!chartData.isPresent()) {
                return;
            }
            Dragboard dragBoard = legend.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(YoCompositeTools.YO_VARIABLE, chartData.get().getYoVariable().getFullNameString()));
            dragBoard.setContent((Map)clipboardContent);
        }
        event.consume();
    }

    public void setSelectionHighlight(boolean isSelected) {
        if (isSelected) {
            this.dynamicLineChart.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GREEN, BorderStrokeStyle.SOLID, new CornerRadii(5.0), BorderWidths.DEFAULT)}));
        } else {
            this.dynamicLineChart.setBorder(this.defaultBorder);
        }
    }

    public void handleDragEntered(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(true);
        }
        event.consume();
    }

    public void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(false);
        }
        event.consume();
    }

    public void handleDragOver(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            if (this.isEmpty()) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        }
        event.consume();
    }

    public void handleDragDropped(DragEvent event) {
        if (event.isAccepted()) {
            return;
        }
        Dragboard db = event.getDragboard();
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(db, this.yoCompositeSearchManager);
        if (yoComposites != null) {
            for (YoComposite yoComposite : yoComposites) {
                yoComposite.getYoComponents().forEach(this::addYoVariableToPlot);
            }
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.dynamicLineChart || event.getGestureSource() == this.chartMoveIcon) {
            return false;
        }
        if (event.getTransferMode() == TransferMode.MOVE && !this.isEmpty()) {
            return false;
        }
        Dragboard dragboard = event.getDragboard();
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(dragboard, this.yoCompositeSearchManager) != null;
    }

    public BooleanProperty useUniqueNamesProperty() {
        return this.useUniqueNames;
    }

    public ObservableSet<YoVariable> getPlottedVariables() {
        return this.plottedVariables;
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    public FontAwesomeIconView getChartMoveIcon() {
        return this.chartMoveIcon;
    }

    public AnchorPane getMainPane() {
        return this.chartMainPane;
    }

    public DynamicLineChart getLineChart() {
        return this.dynamicLineChart;
    }

    public YoChartConfigurationDefinition toYoChartConfigurationDefinition() {
        return this.toYoChartConfigurationDefinition(new ChartIdentifier(-1, -1));
    }

    public YoChartConfigurationDefinition toYoChartConfigurationDefinition(ChartIdentifier chartIdentifier) {
        YoChartConfigurationDefinition definition = new YoChartConfigurationDefinition();
        definition.setIdentifier(ChartTools.toYoChartIdentifierDefinition(chartIdentifier));
        definition.setChartStyle(this.dynamicLineChart.getChartStyle().name());
        definition.setYoVariables(this.charts.keySet().stream().map(YoVariable::getFullNameString).collect(Collectors.toList()));
        definition.setYBounds(this.charts.values().stream().map(pack -> ChartTools.toChartDoubleBoundsDefinition(pack.getSeries().getCustomYBounds())).collect(Collectors.toList()));
        definition.setNegates(this.charts.values().stream().map(pack -> pack.getSeries().isNegated()).collect(Collectors.toList()));
        return definition;
    }

    private class YoVariableChartPackage {
        private final YoNumberSeries series;
        private final YoVariableChartData chartData;
        private final Object callerID;
        private int lastUpdateEndIndex;

        public YoVariableChartPackage(YoVariable yoVariable, String variableUniqueName) {
            this.callerID = YoChartPanelController.this;
            this.lastUpdateEndIndex = -1;
            this.series = new YoNumberSeries(yoVariable, YoChartPanelController.this.legendPrecision);
            this.chartData = YoChartPanelController.this.chartDataManager.getYoVariableChartData(this.callerID, yoVariable);
            YoChartPanelController.this.dynamicLineChart.addSeries(this.series);
            if (YoChartPanelController.this.useUniqueNames.get()) {
                this.series.setSeriesName(variableUniqueName);
            }
            YoChartPanelController.this.useUniqueNames.addListener((o, oldValue, newValue) -> this.series.setSeriesName(newValue != false ? variableUniqueName : yoVariable.getName()));
        }

        public void updateLegend() {
            this.chartData.updateVariableData();
            this.series.updateLegend();
        }

        public void updateChart() {
            YoVariableChartData.ChartDataUpdate newData = this.chartData.pollChartData(this.callerID);
            if (newData != null) {
                newData.readUpdate(this.series, this.lastUpdateEndIndex);
                this.lastUpdateEndIndex = newData.getUpdateEndIndex();
            }
        }

        public YoVariable getYoVariable() {
            return this.series.getYoVariable();
        }

        public YoNumberSeries getSeries() {
            return this.series;
        }

        public void close() {
            YoChartPanelController.this.dynamicLineChart.removeSeries(this.series);
            this.chartData.removeCaller(this.callerID);
        }
    }
}

