/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.session.mcap.MCAPLogSession;

public class SessionVisualizerArgsHandler {
    private Session session = null;

    public boolean parseArgs(String[] args) throws Exception {
        String logFileOption = "logFileName";
        String desiredDTOption = "desiredDT";
        String defaultRobotFileOption = "defaultRobotFileName";
        SimpleJSAP jsap = new SimpleJSAP("SCS2 Session Visualizer", "Visualizes a robot log file, or live data from a compatible source.", new Parameter[]{new FlaggedOption(logFileOption, (StringParser)JSAP.STRING_PARSER, null, false, 'l', "log", "Log file to load, can either be a SCS2 log file or a MCAP log file."), new FlaggedOption(desiredDTOption, (StringParser)JSAP.DOUBLE_PARSER, "0.001", false, 't', "dt", "If possible, the desired DT in seconds to use for the session visualizer. Default value is 1 millisecond."), new FlaggedOption(defaultRobotFileOption, (StringParser)JSAP.STRING_PARSER, null, false, 'r', "robot", "Default robot file to load in case the log file does not contain any robot definition. Can be either a URDF or SDF file.")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.out.println(jsap.getUsage());
            System.out.println(jsap.getHelp());
            return false;
        }
        String logFileName = config.getString(logFileOption);
        long desiredDT = (long)(1.0E9 * config.getDouble(desiredDTOption));
        String defaultRobotFileName = config.getString(defaultRobotFileOption);
        if (logFileName != null) {
            File logFile = new File(logFileName);
            if (!logFile.exists()) {
                System.err.println("Cannot find log file: " + logFile.getAbsolutePath());
                return false;
            }
            if (FilenameUtils.getExtension((String)logFileName).equals("mcap")) {
                File defaultRobotFile;
                if (defaultRobotFileName == null) {
                    defaultRobotFile = null;
                } else {
                    defaultRobotFile = new File(defaultRobotFileName);
                    if (!defaultRobotFile.exists()) {
                        System.err.println("Cannot find default robot file: " + defaultRobotFile.getAbsolutePath());
                        return false;
                    }
                }
                this.session = new MCAPLogSession(logFile, desiredDT, defaultRobotFile);
            } else if (logFileName.equals("robotData.log")) {
                this.session = new LogSession(logFile.getParentFile(), null);
            } else if (logFile.isDirectory()) {
                File[] result = logFile.listFiles((dir, name) -> name.equals("robotData.log"));
                if (result == null || result.length == 0) {
                    System.err.println("Cannot find log file: " + logFile.getAbsolutePath());
                    return false;
                }
                this.session = new LogSession(logFile, null);
            } else {
                System.err.println("Unknown log file type: " + logFile.getAbsolutePath());
                return false;
            }
        }
        return true;
    }

    public Session getSession() {
        return this.session;
    }
}

