/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeListEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.DoubleSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.ReferenceFrameSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXCreatorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoGraphicNameEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.CompositeProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YawPitchRollProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public abstract class YoGraphicFXEditorController<G extends YoGraphicFX>
implements YoGraphicFXCreatorController<G> {
    @FXML
    protected VBox mainPane;
    @FXML
    protected YoGraphicNameEditorPaneController nameEditorController;
    protected ObservableBooleanValue inputsValidityProperty;
    protected G yoGraphicToEdit;
    protected YoCompositeSearchManager yoCompositeSearchManager;
    protected SessionVisualizerToolkit toolkit;
    protected final BooleanProperty hasChangesPendingProperty = new SimpleBooleanProperty((Object)this, "hasChangesPending", false);

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, G yoGraphicToEdit) {
        this.toolkit = toolkit;
        this.yoGraphicToEdit = yoGraphicToEdit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.nameEditorController.initialize(toolkit, (YoGraphicFXItem)yoGraphicToEdit);
        this.nameEditorController.bindYoGraphicFXItem((YoGraphicFXItem)yoGraphicToEdit);
        this.nameEditorController.addAnyChangeListener((ChangeListener<Object>)((ChangeListener)this::updateHasChangesPendingProperty));
        this.inputsValidityProperty = this.nameEditorController.inputsValidityProperty();
    }

    protected abstract <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> var1, T var2, T var3);

    protected void setupDoublePropertyEditor(TextField textField, ImageView validImageView, BiConsumer<G, DoubleProperty> setter) {
        LinkedYoRegistry linkedRootRegistry = this.toolkit.getYoManager().getLinkedRootRegistry();
        DoubleSearchField yoDoubleTextField = new DoubleSearchField(textField, this.yoCompositeSearchManager, linkedRootRegistry, validImageView);
        yoDoubleTextField.setupAutoCompletion();
        yoDoubleTextField.supplierProperty().addListener((o, oldValue, newValue) -> setter.accept(this.yoGraphicToEdit, (DoubleProperty)newValue));
        textField.textProperty().addListener(this::updateHasChangesPendingProperty);
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)yoDoubleTextField.getValidityProperty());
    }

    protected void setupReferenceFramePropertyEditor(TextField textField, ImageView validImageView, BiConsumer<G, Property<ReferenceFrame>> setter) {
        ReferenceFrameManager referenceFrameManager = this.toolkit.getReferenceFrameManager();
        ReferenceFrameSearchField yoReferenceFrameTextField = new ReferenceFrameSearchField(textField, referenceFrameManager, validImageView);
        yoReferenceFrameTextField.setupAutoCompletion();
        yoReferenceFrameTextField.supplierProperty().addListener((o, oldValue, newValue) -> setter.accept(this.yoGraphicToEdit, (Property<ReferenceFrame>)newValue));
        textField.textProperty().addListener(this::updateHasChangesPendingProperty);
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)yoReferenceFrameTextField.getValidityProperty());
    }

    protected void setupTuple2DPropertyEditor(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, Tuple2DProperty propertyToBind) {
        this.setupCompositePropertyEditor(editor, entryName, setupReferenceFrame, "YoTuple2D", propertyToBind);
    }

    protected void setupTuple3DPropertyEditor(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, Tuple3DProperty propertyToBind) {
        this.setupCompositePropertyEditor(editor, entryName, setupReferenceFrame, "YoTuple3D", propertyToBind);
    }

    protected void setupOrientation3DProperty(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, Orientation3DProperty propertyToBind) {
        if (propertyToBind != null && propertyToBind instanceof YawPitchRollProperty) {
            this.setupYawPitchRollProperty(editor, entryName, setupReferenceFrame, (YawPitchRollProperty)propertyToBind);
        } else {
            this.setupQuaternionProperty(editor, entryName, setupReferenceFrame, (QuaternionProperty)propertyToBind);
        }
    }

    protected void setupQuaternionProperty(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, QuaternionProperty propertyToBind) {
        this.setupCompositePropertyEditor(editor, entryName, setupReferenceFrame, "YoQuaternion", propertyToBind);
    }

    protected void setupYawPitchRollProperty(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, YawPitchRollProperty propertyToBind) {
        this.setupCompositePropertyEditor(editor, entryName, setupReferenceFrame, "YoYawPitchRoll", propertyToBind);
    }

    protected void setupCompositePropertyEditor(YoCompositeEditorPaneController editor, String entryName, boolean setupReferenceFrame, String compositeType, CompositeProperty propertyToBind) {
        editor.initialize(this.toolkit, this.yoCompositeSearchManager.getCollectionFromType(compositeType), setupReferenceFrame);
        editor.setCompositeName(entryName);
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)editor.inputsValidityProperty());
        editor.bindYoCompositeDoubleProperty(propertyToBind);
        editor.addInputNotification(() -> this.updateHasChangesPendingProperty(null, null, null));
    }

    protected void setupDoublePropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<DoubleProperty>> listUpdateConsumer) {
        this.setupDoublePropertyListEditor(editor, entryName, null, listSizeConsumer, listUpdateConsumer);
    }

    protected void setupDoublePropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, String entryComponentName, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<DoubleProperty>> listUpdateConsumer) {
        editor.initialize(this.toolkit, this.yoCompositeSearchManager.getYoDoubleCollection(), false);
        editor.setCompositeName(entryName, entryComponentName);
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)editor.inputsValidityProperty());
        editor.numberOfCompositesProperty().addListener((o, oldValue, newValue) -> listSizeConsumer.accept((IntegerProperty)newValue));
        YoGraphicFXControllerTools.toSingletonDoubleSupplierListProperty(editor.compositeListProperty()).addListener((o, oldValue, newValue) -> listUpdateConsumer.accept((List<DoubleProperty>)newValue));
        editor.addInputNotification(() -> this.updateHasChangesPendingProperty(null, null, null));
    }

    protected void setupTuple2DPropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, boolean setupReferenceFrame, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<Tuple2DProperty>> listUpdateConsumer) {
        this.setupTuple2DPropertyListEditor(editor, entryName, null, setupReferenceFrame, listSizeConsumer, listUpdateConsumer);
    }

    protected void setupTuple2DPropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, String entryComponentName, boolean setupReferenceFrame, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<Tuple2DProperty>> listUpdateConsumer) {
        this.setupCompositePropertyListEditor(editor, entryName, entryComponentName, setupReferenceFrame, "YoTuple2D", listSizeConsumer, listUpdateConsumer, Tuple2DProperty::new);
    }

    protected void setupTuple3DPropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, boolean setupReferenceFrame, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<Tuple3DProperty>> listUpdateConsumer) {
        this.setupTuple3DPropertyListEditor(editor, entryName, null, setupReferenceFrame, listSizeConsumer, listUpdateConsumer);
    }

    protected void setupTuple3DPropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, String entryComponentName, boolean setupReferenceFrame, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<Tuple3DProperty>> listUpdateConsumer) {
        this.setupCompositePropertyListEditor(editor, entryName, entryComponentName, setupReferenceFrame, "YoTuple3D", listSizeConsumer, listUpdateConsumer, Tuple3DProperty::new);
    }

    protected <T extends CompositeProperty> void setupCompositePropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, boolean setupReferenceFrame, String compositeType, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<T>> listUpdateConsumer, Supplier<T> compositePropertyBuilder) {
        this.setupCompositePropertyListEditor(editor, entryName, null, setupReferenceFrame, compositeType, listSizeConsumer, listUpdateConsumer, compositePropertyBuilder);
    }

    protected <T extends CompositeProperty> void setupCompositePropertyListEditor(YoCompositeListEditorPaneController editor, String entryName, String entryComponentName, boolean setupReferenceFrame, String compositeType, Consumer<IntegerProperty> listSizeConsumer, Consumer<List<T>> listUpdateConsumer, Supplier<T> compositePropertyBuilder) {
        editor.initialize(this.toolkit, this.yoCompositeSearchManager.getCollectionFromType(compositeType), setupReferenceFrame);
        editor.setCompositeName(entryName, entryComponentName);
        this.inputsValidityProperty = Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)editor.inputsValidityProperty());
        editor.numberOfCompositesProperty().addListener((o, oldValue, newValue) -> listSizeConsumer.accept((IntegerProperty)newValue));
        editor.addInputListener(listUpdateConsumer, compositePropertyBuilder);
        editor.addInputNotification(() -> this.updateHasChangesPendingProperty(null, null, null));
    }

    @Override
    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    @Override
    public ReadOnlyBooleanProperty hasChangesPendingProperty() {
        return this.hasChangesPendingProperty;
    }

    @Override
    public G getYoGraphicFX() {
        return this.yoGraphicToEdit;
    }

    public VBox getMainPane() {
        return this.mainPane;
    }
}

