/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.Pane;
import javax.xml.bind.JAXBException;
import org.controlsfx.control.CheckTreeView;
import us.ihmc.scs2.definition.yoVariable.YoVariableGroupDefinition;
import us.ihmc.scs2.session.SessionDataFilterParameters;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TreeViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SessionVariableFilterPaneController {
    private static final String MODIFIED_FILTER_NAME = "- Modified -";
    private static final String NONE_FILTER_NAME = "None";
    private static final String ALL_FILTER_NAME = "All";
    private static final String IMPORT_FILTER_NAME = "Import ...";
    @FXML
    private Pane mainPane;
    @FXML
    private CheckTreeView<Object> selectedVariablesCheckTreeView;
    @FXML
    private Button selectAllButton;
    @FXML
    private Button unselectAllButton;
    @FXML
    private ComboBox<String> filterComboBox;
    private SessionDataFilterParameters currentFilter;
    private Map<String, SessionDataFilterParameters> filterMap;
    private final SessionDataCollectionBasedFilter modifiedFilter = new SessionDataCollectionBasedFilter("- Modified -");
    private final ObjectProperty<ContextMenu> activeContexMenu = new SimpleObjectProperty((Object)this, "activeContextMenu", null);
    private CheckBoxTreeItem<Object> rootItem;
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private YoManager yoManager;
    private Predicate<YoVariable> treeViewVariableFilter = null;
    private boolean treeItemSelectedListenerEnabled = true;
    private ChangeListener<? super Boolean> treeItemSelectedListener = (o, oldValue, newValue) -> {
        if (this.treeItemSelectedListenerEnabled && !MODIFIED_FILTER_NAME.equals(this.filterComboBox.getSelectionModel().getSelectedItem())) {
            this.updateModifiedFilterFromTreeView();
            this.filterComboBox.getSelectionModel().select((Object)MODIFIED_FILTER_NAME);
        }
    };

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.initialize(toolkit, null);
    }

    public void initialize(SessionVisualizerToolkit toolkit, Predicate<YoVariable> treeViewVariableFilter) {
        this.yoManager = toolkit.getYoManager();
        this.treeViewVariableFilter = treeViewVariableFilter;
        this.selectedVariablesCheckTreeView.setCellFactory(param -> new CheckBoxTreeCell<Object>(){

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof YoRegistry) {
                    this.setText(((YoRegistry)item).getName());
                } else if (item instanceof YoVariable) {
                    this.setText(((YoVariable)item).getName());
                } else {
                    throw new IllegalStateException("Unexpected item type: " + item.getClass());
                }
            }
        });
        this.selectedVariablesCheckTreeView.setOnContextMenuRequested(e -> {
            if (this.activeContexMenu.get() != null) {
                ((ContextMenu)this.activeContexMenu.get()).hide();
                this.activeContexMenu.set(null);
            }
            FontAwesomeIconView collapseIcon = new FontAwesomeIconView(FontAwesomeIcon.MINUS_SQUARE_ALT);
            FontAwesomeIconView expandIcon = new FontAwesomeIconView(FontAwesomeIcon.PLUS_SQUARE_ALT);
            MenuItem collapseItem = new MenuItem("Collapse all", (Node)collapseIcon);
            MenuItem expandItem = new MenuItem("Expand all", (Node)expandIcon);
            collapseItem.setOnAction(e2 -> this.collapseAll());
            expandItem.setOnAction(e2 -> this.expandAll());
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{collapseItem, expandItem});
            contextMenu.show(this.selectedVariablesCheckTreeView, e.getScreenX(), e.getScreenY());
            this.activeContexMenu.set((Object)contextMenu);
        });
        this.selectedVariablesCheckTreeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.selectedVariablesCheckTreeView.setShowRoot(true);
        YoRegistryChangedListener rootRegistryListener = change -> this.refreshTreeView();
        this.yoManager.getRootRegistry().addListener(rootRegistryListener);
        this.cleanupActions.add(() -> this.yoManager.getRootRegistry().removeListener(rootRegistryListener));
        this.refreshTreeView();
        SessionDataFilterParameters allFilter = new SessionDataFilterParameters(ALL_FILTER_NAME, v -> true, null);
        SessionDataFilterParameters noneFilter = new SessionDataFilterParameters(NONE_FILTER_NAME, v -> false, null);
        this.filterMap = toolkit.getSessionDataPreferenceManager().getFilterMap();
        this.filterComboBox.setItems(FXCollections.observableArrayList());
        this.filterComboBox.getItems().addAll((Object[])new String[]{MODIFIED_FILTER_NAME});
        this.filterComboBox.getItems().addAll((Object[])new String[]{ALL_FILTER_NAME});
        this.filterComboBox.getItems().addAll((Object[])new String[]{NONE_FILTER_NAME});
        this.filterComboBox.getItems().addAll(this.filterMap.keySet());
        this.filterComboBox.getItems().add((Object)IMPORT_FILTER_NAME);
        this.filterComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (IMPORT_FILTER_NAME.equals(newValue)) {
                if (!this.importFilter()) {
                    this.filterComboBox.getSelectionModel().select(oldValue);
                }
                return;
            }
            if (MODIFIED_FILTER_NAME.equals(oldValue)) {
                this.updateModifiedFilterFromTreeView();
            }
            this.currentFilter = MODIFIED_FILTER_NAME.equals(newValue) ? this.modifiedFilter : (ALL_FILTER_NAME.equals(newValue) ? allFilter : (NONE_FILTER_NAME.equals(newValue) ? noneFilter : this.filterMap.get(newValue)));
            this.applyFilterToTreeItems(this.currentFilter);
        });
        this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME);
        this.selectAllButton.setOnAction(e -> this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME));
        this.unselectAllButton.setOnAction(e -> this.filterComboBox.getSelectionModel().select((Object)NONE_FILTER_NAME));
    }

    public void dispose() {
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    private boolean importFilter() {
        if (this.mainPane.getScene() == null || this.mainPane.getScene().getWindow() == null) {
            return false;
        }
        File result = SessionVisualizerIOTools.yoVariableGroupConfigurationOpenFileDialog(this.mainPane.getScene().getWindow());
        if (result == null) {
            return false;
        }
        try {
            SessionDataCollectionBasedFilter filter = new SessionDataCollectionBasedFilter(XMLTools.loadYoVariableGroupDefinition(new FileInputStream(result)));
            if (!this.filterMap.containsKey(filter.getName())) {
                this.filterComboBox.getItems().add(this.filterComboBox.getItems().size() - 1, (Object)filter.getName());
            }
            this.filterMap.put(filter.getName(), filter);
            this.filterComboBox.getSelectionModel().select((Object)filter.getName());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @FXML
    private void saveActiveFilter() {
        if (this.mainPane.getScene() == null || this.mainPane.getScene().getWindow() == null) {
            return;
        }
        File result = SessionVisualizerIOTools.yoVariableGroupConfigurationSaveFileDialog(this.mainPane.getScene().getWindow());
        if (result == null) {
            return;
        }
        try {
            this.updateModifiedFilterFromTreeView();
            YoVariableGroupDefinition definition = this.modifiedFilter.toYoVariableGroupDefinition();
            definition.setName(result.getName().replace(".scs2.yoVariableGroup", ""));
            XMLTools.saveYoVariableGroupDefinition(new FileOutputStream(result), definition);
            if (!this.filterMap.containsKey(definition.getName())) {
                this.filterComboBox.getItems().add(this.filterComboBox.getItems().size() - 1, (Object)definition.getName());
            }
            this.filterMap.put(definition.getName(), new SessionDataCollectionBasedFilter(definition));
            this.filterComboBox.getSelectionModel().select((Object)definition.getName());
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private void applyFilterToTreeItems(SessionDataFilterParameters filter) {
        this.treeItemSelectedListenerEnabled = false;
        ArrayList<CheckBoxTreeItem> itemsToProcess = new ArrayList<CheckBoxTreeItem>(Arrays.asList(this.rootItem));
        while (!itemsToProcess.isEmpty()) {
            CheckBoxTreeItem item = (CheckBoxTreeItem)itemsToProcess.remove(itemsToProcess.size() - 1);
            Object object = item.getValue();
            if (object instanceof YoVariable) {
                YoVariable var = (YoVariable)object;
                item.setSelected(filter.getVariableFilter().test(var));
                continue;
            }
            itemsToProcess.addAll((Collection<CheckBoxTreeItem>)item.getChildren());
        }
        this.treeItemSelectedListenerEnabled = true;
    }

    private void refreshTreeView() {
        this.modifiedFilter.clear();
        this.rootItem = new CheckBoxTreeItem((Object)this.yoManager.getRootRegistry());
        this.rootItem.setSelected(true);
        this.rootItem.setExpanded(true);
        this.buildTreeRecursively((TreeItem<Object>)this.rootItem);
        this.selectedVariablesCheckTreeView.setRoot(this.rootItem);
        this.filterComboBox.getSelectionModel().select((Object)ALL_FILTER_NAME);
    }

    private void buildTreeRecursively(TreeItem<Object> parent) {
        Object value = parent.getValue();
        if (value instanceof YoRegistry) {
            CheckBoxTreeItem childItem;
            YoRegistry registry = (YoRegistry)value;
            for (YoRegistry childRegistry : registry.getChildren()) {
                childItem = new CheckBoxTreeItem((Object)childRegistry);
                childItem.setSelected(!childRegistry.getChildren().isEmpty() || !childRegistry.getVariables().isEmpty());
                childItem.setExpanded(true);
                this.buildTreeRecursively((TreeItem<Object>)childItem);
                if (childItem.getChildren().isEmpty()) continue;
                parent.getChildren().add((Object)childItem);
            }
            for (YoVariable variable : registry.getVariables()) {
                if (this.treeViewVariableFilter != null && !this.treeViewVariableFilter.test(variable)) continue;
                childItem = new CheckBoxTreeItem((Object)variable);
                childItem.selectedProperty().addListener(this.treeItemSelectedListener);
                childItem.setSelected(true);
                childItem.setExpanded(true);
                parent.getChildren().add((Object)childItem);
            }
        }
    }

    private void updateModifiedFilterFromTreeView() {
        this.modifiedFilter.yoVariableNames.clear();
        ArrayList<CheckBoxTreeItem> itemsToProcess = new ArrayList<CheckBoxTreeItem>(Arrays.asList(this.rootItem));
        while (!itemsToProcess.isEmpty()) {
            CheckBoxTreeItem item = (CheckBoxTreeItem)itemsToProcess.remove(itemsToProcess.size() - 1);
            Object object = item.getValue();
            if (object instanceof YoVariable) {
                YoVariable var = (YoVariable)object;
                if (!item.isSelected()) continue;
                this.modifiedFilter.yoVariableNames.add(var.getFullNameString());
                continue;
            }
            object = item.getValue();
            if (object instanceof YoRegistry) {
                YoRegistry reg = (YoRegistry)object;
                if (reg.getChildren().isEmpty() && reg.getVariables().isEmpty()) {
                    item.setSelected(false);
                    continue;
                }
                itemsToProcess.addAll((Collection<CheckBoxTreeItem>)item.getChildren());
                continue;
            }
            throw new IllegalStateException("Unexpected value type: " + item.getValue().getClass().getSimpleName());
        }
    }

    public void collapseAll() {
        TreeViewTools.collapseRecursively(this.rootItem);
    }

    public void expandAll() {
        TreeViewTools.expandRecursively(this.rootItem);
    }

    public Predicate<YoVariable> buildVariableFilter() {
        Set<String> selectedFullnames = this.collectSelectedVariableFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getFullNameString());
    }

    private Set<String> collectSelectedVariableFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedVariableFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        } else if (current.getValue() instanceof YoVariable) {
            if (!current.isSelected()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoVariable)current.getValue()).getFullNameString());
        }
        return fullnamesToPack;
    }

    public Predicate<YoRegistry> buildRegistryFilter() {
        Set<String> selectedFullnames = this.collectSelectedRegistryFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getNamespace().getName());
    }

    private Set<String> collectSelectedRegistryFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoRegistry)current.getValue()).getNamespace().getName());
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedRegistryFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        }
        return fullnamesToPack;
    }

    private static class SessionDataCollectionBasedFilter
    extends SessionDataFilterParameters {
        private final Set<String> yoVariableNames;
        private final Set<String> yoRegistryNames;
        private final Predicate<YoVariable> variableFilter;
        private final Predicate<YoRegistry> registryFilter;

        public SessionDataCollectionBasedFilter(String name) {
            super(name, null, null);
            this.yoVariableNames = new LinkedHashSet<String>();
            this.yoRegistryNames = null;
            this.variableFilter = v -> this.yoVariableNames.contains(v.getFullNameString());
            this.registryFilter = null;
        }

        public SessionDataCollectionBasedFilter(YoVariableGroupDefinition definition) {
            super(definition.getName(), null, null);
            Objects.requireNonNull(definition.getName());
            if (definition.getVariableNames() != null) {
                this.yoVariableNames = new LinkedHashSet<String>(definition.getVariableNames());
                this.variableFilter = v -> this.yoVariableNames.contains(v.getFullNameString()) || this.yoVariableNames.contains(v.getName());
            } else {
                this.yoVariableNames = null;
                this.variableFilter = null;
            }
            if (definition.getRegistryNames() != null) {
                this.yoRegistryNames = new LinkedHashSet<String>(definition.getRegistryNames());
                this.registryFilter = reg -> this.yoRegistryNames.contains(reg.getName()) || this.yoRegistryNames.contains(reg.getNamespace().getName());
            } else {
                this.yoRegistryNames = null;
                this.registryFilter = null;
            }
        }

        private void clear() {
            if (this.yoVariableNames != null) {
                this.yoVariableNames.clear();
            }
            if (this.yoRegistryNames != null) {
                this.yoRegistryNames.clear();
            }
        }

        public YoVariableGroupDefinition toYoVariableGroupDefinition() {
            YoVariableGroupDefinition definition = new YoVariableGroupDefinition();
            definition.setName(this.getName());
            definition.setVariableNames(this.yoVariableNames != null ? this.yoVariableNames.stream().toList() : null);
            definition.setRegistryNames(this.yoRegistryNames != null ? this.yoRegistryNames.stream().toList() : null);
            return definition;
        }

        public Predicate<YoVariable> getVariableFilter() {
            return this.variableFilter;
        }

        public Predicate<YoRegistry> getRegistryFilter() {
            return this.registryFilter;
        }
    }
}

