/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Affine;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoRobotFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;

public class CameraSensorsManager
extends ObservedAnimationTimer
implements Manager {
    private final Node mainSceneRoot;
    private final YoRobotFXManager robotFXManager;
    private final List<SingleCameraSensorManager> cameras = new ArrayList<SingleCameraSensorManager>();
    private final Map<String, Map<String, SingleCameraSensorManager>> robotNameToSensorNameToManagerMap = new HashMap<String, Map<String, SingleCameraSensorManager>>();
    private boolean sessionLoaded = false;
    private final JavaFXMessager messager;
    private final SessionVisualizerTopics topics;

    public CameraSensorsManager(Node mainSceneRoot, SCS2JavaFXMessager messager, SessionVisualizerTopics topics, YoRobotFXManager robotFXManager) {
        this.mainSceneRoot = mainSceneRoot;
        this.messager = messager;
        this.topics = topics;
        this.robotFXManager = robotFXManager;
        messager.addTopicListener(topics.getCameraSensorDefinitionData(), this::handleCameraSensorDefinitionMessage);
    }

    private void handleCameraSensorDefinitionMessage(SessionMessagerAPI.Sensors.SensorMessage<CameraSensorDefinition> message) {
        SingleCameraSensorManager manager = (SingleCameraSensorManager)this.robotNameToSensorNameToManagerMap.getOrDefault(message.getRobotName(), Collections.emptyMap()).get(message.getSensorName());
        if (manager == null) {
            return;
        }
        manager.configure((CameraSensorDefinition)message.getMessageContent());
    }

    @Override
    public void handleImpl(long now) {
        for (int i = 0; i < this.cameras.size(); ++i) {
            this.cameras.get(i).update(now);
        }
    }

    @Override
    public void startSession(Session session) {
        this.sessionLoaded = false;
        for (RobotDefinition robotDefinition : session.getRobotDefinitions()) {
            String robotName = robotDefinition.getName();
            HashMap<String, SingleCameraSensorManager> robotMap = new HashMap<String, SingleCameraSensorManager>();
            for (JointDefinition jointDefinition : robotDefinition.getAllJoints()) {
                List definitions = jointDefinition.getSensorDefinitions(CameraSensorDefinition.class);
                for (CameraSensorDefinition definition : definitions) {
                    String sensorName = definition.getName();
                    RigidBodyReadOnly rootBody = this.robotFXManager.getRobotRootBody(robotName);
                    Objects.requireNonNull(rootBody);
                    JointReadOnly parentJoint = MultiBodySystemTools.findJoint((RigidBodyReadOnly)rootBody, (String)jointDefinition.getName());
                    Objects.requireNonNull(parentJoint);
                    ReferenceFrame sensorFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)sensorName, (ReferenceFrame)parentJoint.getFrameAfterJoint(), (RigidBodyTransformReadOnly)definition.getTransformToJoint());
                    SingleCameraSensorManager manager = new SingleCameraSensorManager(robotName, definition, sensorFrame);
                    this.cameras.add(manager);
                    robotMap.put(sensorName, manager);
                }
            }
            if (robotMap.isEmpty()) continue;
            this.robotNameToSensorNameToManagerMap.put(robotName, robotMap);
        }
        this.start();
        this.sessionLoaded = true;
    }

    @Override
    public void stopSession() {
        this.stop();
        this.cameras.clear();
        this.robotNameToSensorNameToManagerMap.clear();
        this.sessionLoaded = false;
    }

    @Override
    public boolean isSessionLoaded() {
        return this.sessionLoaded;
    }

    private class SingleCameraSensorManager {
        private final String robotName;
        private final String sensorName;
        private final ReferenceFrame sensorFrame;
        private final RotationMatrix cameraViewOrientationOffset = new RotationMatrix();
        private final RigidBodyTransform actualCameraPose = new RigidBodyTransform();
        private long period;
        private boolean enable = false;
        private long lastFrame = -1L;
        private final SnapshotParameters snapshotParameters = new SnapshotParameters();
        private final PerspectiveCamera camera = new PerspectiveCamera(true);
        private final Affine cameraTransform = new Affine();
        private WritableImage image = null;
        private BufferedImage bufferedImage;
        private int width;
        private int height;
        private final Vector3D xAxis = new Vector3D();
        private final Vector3D yAxis = new Vector3D();
        private final Vector3D zAxis = new Vector3D();

        public SingleCameraSensorManager(String robotName, CameraSensorDefinition definition, ReferenceFrame sensorFrame) {
            this.robotName = robotName;
            this.sensorName = definition.getName();
            this.sensorFrame = sensorFrame;
            this.camera.setVerticalFieldOfView(false);
            this.camera.getTransforms().add((Object)this.cameraTransform);
            this.snapshotParameters.setCamera((Camera)this.camera);
            this.snapshotParameters.setDepthBuffer(true);
            this.snapshotParameters.setFill((Paint)Color.TRANSPARENT);
            this.configure(definition);
        }

        public void configure(CameraSensorDefinition definition) {
            this.enable = definition.getEnable();
            if (this.enable) {
                this.period = TimeUnit.MILLISECONDS.toNanos(definition.getUpdatePeriod());
                Vector3D depthAxis = definition.getDepthAxis();
                Vector3D upAxis = definition.getUpAxis();
                if (depthAxis == null || upAxis == null) {
                    this.cameraViewOrientationOffset.setIdentity();
                } else {
                    this.zAxis.setAndNormalize((Tuple3DReadOnly)depthAxis);
                    this.yAxis.setAndNegate((Tuple3DReadOnly)upAxis);
                    this.yAxis.normalize();
                    this.xAxis.cross((Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
                    this.yAxis.cross((Tuple3DReadOnly)this.zAxis, (Tuple3DReadOnly)this.xAxis);
                    try {
                        this.cameraViewOrientationOffset.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
                    }
                    catch (NotARotationMatrixException e) {
                        LogTools.error((String)"Erro computing the camera view direction. depth-axis: {}, up-axis: {}", (Object)depthAxis, (Object)upAxis);
                        this.cameraViewOrientationOffset.setIdentity();
                    }
                }
                this.camera.setFieldOfView(Math.toDegrees(definition.getFieldOfView()));
                this.camera.setNearClip(definition.getClipNear());
                this.camera.setFarClip(definition.getClipFar());
                if (this.bufferedImage == null || this.width != definition.getImageWidth() || this.height != definition.getImageHeight()) {
                    this.width = definition.getImageWidth();
                    this.height = definition.getImageHeight();
                    this.image = null;
                    this.snapshotParameters.setViewport(new Rectangle2D(0.0, 0.0, (double)this.width, (double)this.height));
                    this.bufferedImage = new BufferedImage(this.width, this.height, 2);
                }
            } else {
                this.period = -1L;
                this.image = null;
                this.bufferedImage = null;
            }
        }

        public void update(long now) {
            if (!this.enable) {
                this.lastFrame = -1L;
                return;
            }
            if (this.lastFrame == -1L || now - this.lastFrame >= this.period) {
                this.actualCameraPose.set(this.sensorFrame.getTransformToRoot());
                this.actualCameraPose.appendOrientation((Orientation3DReadOnly)this.cameraViewOrientationOffset);
                JavaFXMissingTools.convertRigidBodyTransformToAffine(this.actualCameraPose, this.cameraTransform);
                this.image = CameraSensorsManager.this.mainSceneRoot.snapshot(this.snapshotParameters, this.image);
                this.bufferedImage = SwingFXUtils.fromFXImage((Image)this.image, (BufferedImage)this.bufferedImage);
                CameraSensorsManager.this.messager.submitMessage(CameraSensorsManager.this.topics.getCameraSensorFrame(), (Object)new SessionMessagerAPI.Sensors.SensorMessage(this.robotName, this.sensorName, (Object)this.bufferedImage));
                this.lastFrame = now;
            }
        }
    }
}

