/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.shape.Polygon;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;

public class YoPolygonFX2D
extends YoGraphicFX2D {
    private List<Tuple2DProperty> vertices = new ArrayList<Tuple2DProperty>();
    private IntegerProperty numberOfVertices = null;
    private Polygon polygonNode = new Polygon();

    public YoPolygonFX2D() {
        this.polygonNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.polygonNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoPolygonFX2D(ReferenceFrame worldFrame) {
        this();
    }

    @Override
    public void render() {
        this.polygonNode.getPoints().clear();
        if (this.vertices == null) {
            return;
        }
        if (this.numberOfVertices == null) {
            for (Tuple2DProperty vertex : this.vertices) {
                if (vertex.containsNaN()) break;
                this.polygonNode.getPoints().addAll((Object[])new Double[]{vertex.getX(), vertex.getY()});
            }
        } else {
            Point2D vertex;
            int n = Math.min(this.numberOfVertices.get(), this.vertices.size());
            for (int i = 0; i < n && !(vertex = this.vertices.get(i).toPoint2DInWorld()).containsNaN(); ++i) {
                this.polygonNode.getPoints().addAll((Object[])new Double[]{vertex.getX(), vertex.getY()});
            }
        }
        this.polygonNode.setFill(this.fillColor == null ? null : this.fillColor.get());
        this.polygonNode.setStroke(this.strokeColor == null ? null : this.strokeColor.get());
        double scale = this.polygonNode.getLocalToSceneTransform().deltaTransform(1.0, 0.0).getX();
        this.polygonNode.setStrokeWidth(this.strokeWidth.get() / scale);
    }

    public void setVertices(List<Tuple2DProperty> vertices) {
        this.vertices = vertices;
    }

    public void addVertex(DoubleProperty x, DoubleProperty y) {
        this.addVertex(new Tuple2DProperty(null, x, y));
    }

    public void addVertex(Tuple2DProperty vertex) {
        this.vertices.add(vertex);
    }

    public void setNumberOfVertices(IntegerProperty numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    public void setNumberOfVertices(int numberOfVertices) {
        this.setNumberOfVertices((IntegerProperty)new SimpleIntegerProperty(numberOfVertices));
    }

    @Override
    public void clear() {
        this.vertices = null;
        this.numberOfVertices = null;
        this.fillColor = null;
        this.strokeColor = null;
        this.strokeWidth = null;
    }

    @Override
    public YoPolygonFX2D clone() {
        YoPolygonFX2D clone = new YoPolygonFX2D();
        clone.setName(this.getName());
        clone.setVertices(new ArrayList<Tuple2DProperty>(this.vertices));
        clone.setNumberOfVertices(this.numberOfVertices);
        clone.setFillColor(this.fillColor);
        clone.setStrokeColor(this.strokeColor);
        clone.setStrokeWidth(this.strokeWidth);
        return clone;
    }

    public List<Tuple2DProperty> getVertices() {
        return this.vertices;
    }

    public IntegerProperty getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public Node getNode() {
        return this.polygonNode;
    }
}

