/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D;

import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPoint2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D.YoGraphicFX2DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointFX2D;

public class YoPointFX2DEditorController
extends YoGraphicFX2DEditorController<YoPointFX2D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private TextField sizeTextField;
    @FXML
    private ComboBox<String> graphicComboBox;
    @FXML
    private ImageView sizeValidImageView;
    private YoGraphicPoint2DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoPointFX2D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPoint2DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple2DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupDoublePropertyEditor(this.sizeTextField, this.sizeValidImageView, YoPointFX2D::setSize);
        YoGraphicFXResourceManager yoGraphicFXResourceManager = toolkit.getYoGraphicFXManager().getYoGraphicFXResourceManager();
        this.graphicComboBox.setItems(FXCollections.observableArrayList(yoGraphicFXResourceManager.getGraphic2DNameList()));
        this.graphicComboBox.valueProperty().addListener((o, oldValue, newValue) -> yoGraphicToEdit.setGraphicResource(yoGraphicFXResourceManager.loadGraphic2DResource((String)newValue)));
        this.graphicComboBox.valueProperty().addListener(this::updateHasChangesPendingProperty);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicPoint2DDefinition((YoPointFX2D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.sizeTextField.setText(this.definitionBeforeEdits.getSize());
        this.styleEditorController.setInput((YoGraphic2DDefinition)this.definitionBeforeEdits);
        if (this.definitionBeforeEdits.getGraphicName() == null) {
            this.definitionBeforeEdits.setGraphicName(YoGraphicFXResourceManager.DEFAULT_POINT2D_GRAPHIC_RESOURCE.getResourceName());
        }
        this.graphicComboBox.setValue((Object)this.definitionBeforeEdits.getGraphicName());
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoPointFX2D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPoint2DDefinition((YoPointFX2D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

