/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color;

import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import java.util.function.UnaryOperator;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color.PaintEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.RoundedDoubleConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;

public class SimpleColorEditorController
extends PaintEditorController<SimpleColorFX> {
    @FXML
    private Pane mainPane;
    @FXML
    private Label colorLabel;
    @FXML
    private JFXColorPicker colorPicker;
    @FXML
    private Label opacityLabel;
    @FXML
    private JFXSlider opacitySlider;
    @FXML
    private JFXTextField opacityTextField;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        super.initialize(toolkit, new SimpleColorFX(YoGraphicFX3D.DEFAULT_COLOR));
        TextFormatter value = new TextFormatter((StringConverter)new RoundedDoubleConverter(), (Object)this.opacitySlider.getValue(), (UnaryOperator)new PositiveIntegerValueFilter());
        this.opacityTextField.setTextFormatter(value);
        value.valueProperty().bindBidirectional((Property)this.opacitySlider.valueProperty().asObject());
        MutableBoolean enableColorBinding = new MutableBoolean(true);
        this.colorPicker.valueProperty().addListener((o, oldValue, newValue) -> {
            if (enableColorBinding.isFalse()) {
                return;
            }
            enableColorBinding.setFalse();
            SimpleColorFX newSimpleColor = new SimpleColorFX((Color)newValue);
            if (this.colorProperty.getValue() != null) {
                newSimpleColor = SimpleColorEditorController.changeOpacity(newSimpleColor, ((SimpleColorFX)this.colorProperty.getValue()).getOpacity());
            }
            this.colorProperty.setValue((Object)newSimpleColor);
            enableColorBinding.setTrue();
        });
        this.opacitySlider.valueProperty().addListener((o, oldValue, newValue) -> {
            if (enableColorBinding.isFalse()) {
                return;
            }
            enableColorBinding.setFalse();
            this.colorProperty.setValue((Object)SimpleColorEditorController.changeOpacity((SimpleColorFX)this.colorProperty.getValue(), 0.01 * newValue.doubleValue()));
            enableColorBinding.setTrue();
        });
        this.colorProperty.addListener((o, oldValue, newValue) -> {
            if (enableColorBinding.isFalse()) {
                return;
            }
            enableColorBinding.setFalse();
            this.colorPicker.valueProperty().set((Object)newValue.get());
            this.opacitySlider.setValue(100.0 * newValue.get().getOpacity());
            enableColorBinding.setTrue();
        });
        this.inputsValidityProperty = new SimpleBooleanProperty((Object)this, "inputsValidility", true);
    }

    @Override
    public void setInput(PaintDefinition input) {
        if (input instanceof ColorDefinition) {
            ColorDefinition colorDefinition = (ColorDefinition)input;
            this.setInput(colorDefinition);
        } else {
            LogTools.error((String)"Unexpected input: {}", (Object)input);
        }
    }

    public void setInput(ColorDefinition definition) {
        this.colorProperty.setValue((Object)new SimpleColorFX(JavaFXVisualTools.toColor(definition, YoGraphicFX3D.DEFAULT_COLOR)));
    }

    private static SimpleColorFX changeOpacity(SimpleColorFX original, double newOpacity) {
        Color color = original.get();
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        return new SimpleColorFX(new Color(red, green, blue, newOpacity));
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }
}

