/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color;

import java.util.function.BiConsumer;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoDoubleTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoIntegerTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public abstract class PaintEditorController<C extends BaseColorFX> {
    protected ObservableBooleanValue inputsValidityProperty;
    protected final Property<C> colorProperty = new SimpleObjectProperty((Object)this, "color", null);
    protected SessionVisualizerToolkit toolkit;
    protected YoCompositeSearchManager yoCompositeSearchManager;

    public abstract void initialize(SessionVisualizerToolkit var1);

    public void initialize(SessionVisualizerToolkit toolkit, C defaultColor) {
        this.toolkit = toolkit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.colorProperty.setValue(defaultColor);
    }

    public abstract void setInput(PaintDefinition var1);

    protected void setupDoublePropertyEditor(TextField textField, ImageView validImageView, BiConsumer<C, DoubleProperty> colorComponentSetter) {
        LinkedYoRegistry linkedRootRegistry = this.toolkit.getYoManager().getLinkedRootRegistry();
        YoDoubleTextField yoDoubleTextField = new YoDoubleTextField(textField, this.yoCompositeSearchManager, linkedRootRegistry, validImageView);
        yoDoubleTextField.setupAutoCompletion();
        yoDoubleTextField.supplierProperty().addListener((o, oldValue, newValue) -> colorComponentSetter.accept((C)((BaseColorFX)this.colorProperty.getValue()), (DoubleProperty)newValue));
        this.inputsValidityProperty = this.inputsValidityProperty == null ? yoDoubleTextField.getValidityProperty() : Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)yoDoubleTextField.getValidityProperty());
    }

    protected void setupIntegerPropertyEditor(TextField textField, ImageView validImageView, BiConsumer<C, IntegerProperty> colorComponentSetter) {
        LinkedYoRegistry linkedRootRegistry = this.toolkit.getYoManager().getLinkedRootRegistry();
        YoIntegerTextField yoIntegerTextField = new YoIntegerTextField(textField, this.yoCompositeSearchManager, linkedRootRegistry, validImageView);
        yoIntegerTextField.setupAutoCompletion();
        yoIntegerTextField.supplierProperty().addListener((o, oldValue, newValue) -> colorComponentSetter.accept((C)((BaseColorFX)this.colorProperty.getValue()), (IntegerProperty)newValue));
        this.inputsValidityProperty = this.inputsValidityProperty == null ? yoIntegerTextField.getValidityProperty() : Bindings.and((ObservableBooleanValue)this.inputsValidityProperty, (ObservableBooleanValue)yoIntegerTextField.getValidityProperty());
    }

    public ReadOnlyProperty<C> colorProperty() {
        return this.colorProperty;
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public abstract Pane getMainPane();
}

