/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;

public class YoPolygonExtrudedFX3D
extends YoGraphicFX3D {
    private final MeshView polygonNode = new MeshView();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private List<Tuple2DProperty> vertices = new ArrayList<Tuple2DProperty>();
    private IntegerProperty numberOfVertices = null;
    private DoubleProperty thickness = new SimpleDoubleProperty(0.02);
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();
    private PolygonData newData = null;
    private PolygonData oldData = null;
    private Mesh newMesh = null;
    private boolean clearMesh = false;

    public YoPolygonExtrudedFX3D() {
        this.polygonNode.setMaterial((Material)this.material);
        this.polygonNode.getTransforms().add((Object)this.affine);
        this.polygonNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.polygonNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoPolygonExtrudedFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.orientation.containsNaN()) {
            this.affine.setToIdentity();
            this.affine.appendScale(0.0, 0.0, 0.0);
            return;
        }
        this.newData = YoPolygonExtrudedFX3D.newPolygonData(this.vertices, this.numberOfVertices, this.thickness);
        this.affine.setToTransform((Transform)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = new SimpleColorFX();
        }
        this.material.setDiffuseColor(this.color.get());
        if (this.clearMesh) {
            this.clearMesh = false;
            this.polygonNode.setMesh(null);
        }
        if (this.newMesh != null) {
            this.polygonNode.setMesh(this.newMesh);
            this.newMesh = null;
        }
    }

    static PolygonData newPolygonData(List<Tuple2DProperty> vertices, IntegerProperty numberOfVertices, DoubleProperty thickness) {
        PolygonData data = new PolygonData();
        if (YoGraphicTools.isAnyNull(vertices, numberOfVertices, thickness)) {
            return data;
        }
        if (vertices.size() <= 2 || thickness.get() <= 0.0) {
            return data;
        }
        if (numberOfVertices != null && numberOfVertices.get() >= 0 && numberOfVertices.get() < vertices.size()) {
            vertices = vertices.subList(0, numberOfVertices.get());
        }
        data.vertices = vertices.stream().map(Point2D::new).collect(Collectors.toList());
        data.thickness = thickness.get();
        return data;
    }

    @Override
    public void computeBackground() {
        PolygonData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.vertices == null || Double.isNaN(newDataLocal.thickness) || newDataLocal.thickness < 1.0E-5) {
            this.clearMesh = true;
            return;
        }
        if (newDataLocal.equals(this.oldData) && this.polygonNode.getMesh() != null) {
            return;
        }
        List<Point2DReadOnly> vertices = newDataLocal.vertices;
        if (vertices.size() > 2) {
            Vector2D firstEdge = new Vector2D();
            firstEdge.sub((Tuple2DReadOnly)vertices.get(1), (Tuple2DReadOnly)vertices.get(0));
            Vector2D secondEdge = new Vector2D();
            secondEdge.sub((Tuple2DReadOnly)vertices.get(2), (Tuple2DReadOnly)vertices.get(1));
            if (firstEdge.cross((Tuple2DReadOnly)secondEdge) < 0.0) {
                vertices = new ArrayList<Point2DReadOnly>(vertices);
                Collections.reverse(vertices);
            }
        }
        this.newMesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.ExtrudedPolygon(vertices, (double)newDataLocal.thickness));
        this.oldData = newDataLocal;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setVertices(List<Tuple2DProperty> vertices) {
        this.vertices = vertices;
    }

    public void addVertex(DoubleProperty x, DoubleProperty y) {
        this.addVertex(new Tuple2DProperty(null, x, y));
    }

    public void addVertex(Tuple2DProperty vertex) {
        this.vertices.add(vertex);
    }

    public void setNumberOfVertices(IntegerProperty numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    public void setNumberOfVertices(int numberOfVertices) {
        this.setNumberOfVertices((IntegerProperty)new SimpleIntegerProperty(numberOfVertices));
    }

    public void setThickness(DoubleProperty thickness) {
        this.thickness = thickness;
    }

    public void setThickness(double thickness) {
        this.setThickness((DoubleProperty)new SimpleDoubleProperty(thickness));
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.vertices = null;
        this.numberOfVertices = null;
        this.thickness = null;
        this.color = null;
    }

    @Override
    public YoPolygonExtrudedFX3D clone() {
        YoPolygonExtrudedFX3D clone = new YoPolygonExtrudedFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setVertices(new ArrayList<Tuple2DProperty>(this.vertices));
        clone.setNumberOfVertices(this.numberOfVertices);
        clone.setThickness(this.thickness);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public List<Tuple2DProperty> getVertices() {
        return this.vertices;
    }

    public IntegerProperty getNumberOfVertices() {
        return this.numberOfVertices;
    }

    public DoubleProperty getThickness() {
        return this.thickness;
    }

    @Override
    public Node getNode() {
        return this.polygonNode;
    }

    private static class PolygonData {
        private List<Point2DReadOnly> vertices;
        private double thickness;

        private PolygonData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PolygonData) {
                PolygonData other = (PolygonData)object;
                if (this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices)) {
                    return false;
                }
                return this.thickness == other.thickness;
            }
            return false;
        }
    }
}

