/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import gnu.trove.list.array.TLongArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javafx.scene.image.WritableImage;
import us.ihmc.codecs.demuxer.MP4VideoDemuxer;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.JavaFXPictureConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoConverter;

public class VideoDataReader {
    private final TimestampScrubber timestampScrubber;
    private final String name;
    private final MP4VideoDemuxer demuxer;
    private final JavaFXPictureConverter converter = new JavaFXPictureConverter();
    private final File videoFile;
    private final Camera camera;
    private final ConcurrentCopier<FrameData> imageBuffer = new ConcurrentCopier(FrameData::new);

    public VideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.camera = camera;
        this.name = camera.getNameAsString();
        boolean interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        this.videoFile = new File(dataDirectory, camera.getVideoFileAsString());
        if (!this.videoFile.exists()) {
            throw new IOException("Cannot find video: " + this.videoFile);
        }
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.demuxer = new MP4VideoDemuxer(this.videoFile);
        this.timestampScrubber = new TimestampScrubber(timestampFile, hasTimeBase, interlaced);
    }

    public void readVideoFrame(long queryRobotTimestamp) {
        long videoTimestamp = this.timestampScrubber.getVideoTimestamp(queryRobotTimestamp);
        long currentRobotTimestamp = this.timestampScrubber.getCurrentRobotTimestamp();
        try {
            this.demuxer.seekToPTS(videoTimestamp);
            FrameData copyForWriting = (FrameData)this.imageBuffer.getCopyForWriting();
            copyForWriting.queryRobotTimestamp = queryRobotTimestamp;
            copyForWriting.robotTimestamp = currentRobotTimestamp;
            copyForWriting.cameraCurrentPTS = videoTimestamp;
            copyForWriting.demuxerCurrentPTS = this.demuxer.getCurrentPTS();
            YUVPicture nextFrame = this.demuxer.getNextFrame();
            copyForWriting.frame = this.converter.toFXImage(nextFrame, copyForWriting.frame);
            this.imageBuffer.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestamp(endTimestamp);
        int framerate = VideoConverter.crop(this.videoFile, outputFile, startVideoTimestamp, endVideoTimestamp, monitor);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println(1);
        timestampWriter.println(framerate);
        long pts = 0L;
        for (int i = 0; i < this.timestampScrubber.getRobotTimestampsLength(); ++i) {
            long robotTimestamp = this.timestampScrubber.getRobotTimestampAtIndex(i);
            if (robotTimestamp >= startTimestamp && robotTimestamp <= endTimestamp) {
                timestampWriter.print(robotTimestamp);
                timestampWriter.print(" ");
                timestampWriter.println(pts);
                ++pts;
                continue;
            }
            if (robotTimestamp > endTimestamp) break;
        }
        timestampWriter.close();
    }

    public void exportVideo(File selectedFile, long startTimestamp, long endTimestamp, ProgressConsumer progreesConsumer) {
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestamp(endTimestamp);
        try {
            VideoConverter.convert(this.videoFile, selectedFile, startVideoTimestamp, endVideoTimestamp, progreesConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public FrameData pollCurrentFrame() {
        return (FrameData)this.imageBuffer.getCopyForReading();
    }

    public static class TimestampScrubber {
        private final boolean hasTimebase;
        private final boolean interlaced;
        private long[] robotTimestamps;
        private long[] videoTimestamps;
        private int currentIndex = 0;
        private long currentRobotTimestamp = 0L;
        private long videoTimestamp;

        public TimestampScrubber(File timestampFile, boolean hasTimebase, boolean interlaced) throws IOException {
            this.hasTimebase = hasTimebase;
            this.interlaced = interlaced;
            this.parseTimestampData(timestampFile);
        }

        private void parseTimestampData(File timestampFile) throws IOException {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(timestampFile));){
                String line;
                if (this.hasTimebase) {
                    if (bufferedReader.readLine() == null) {
                        throw new IOException("Cannot read numerator");
                    }
                    if (bufferedReader.readLine() == null) {
                        throw new IOException("Cannot read denumerator");
                    }
                }
                TLongArrayList robotTimestamps = new TLongArrayList();
                TLongArrayList videoTimestamps = new TLongArrayList();
                while ((line = bufferedReader.readLine()) != null) {
                    String[] stamps = line.split("\\s");
                    long robotStamp = Long.parseLong(stamps[0]);
                    long videoStamp = Long.parseLong(stamps[1]);
                    if (this.interlaced) {
                        videoStamp /= 2L;
                    }
                    robotTimestamps.add(robotStamp);
                    videoTimestamps.add(videoStamp);
                }
                this.robotTimestamps = robotTimestamps.toArray();
                this.videoTimestamps = videoTimestamps.toArray();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public long getVideoTimestamp(long queryRobotTimestamp) {
            this.currentIndex = this.searchRobotTimestampsForIndex(queryRobotTimestamp);
            this.videoTimestamp = this.videoTimestamps[this.currentIndex];
            this.currentRobotTimestamp = this.robotTimestamps[this.currentIndex];
            return this.videoTimestamp;
        }

        private int searchRobotTimestampsForIndex(long queryRobotTimestamp) {
            if (queryRobotTimestamp <= this.robotTimestamps[0]) {
                return 0;
            }
            if (queryRobotTimestamp >= this.robotTimestamps[this.robotTimestamps.length - 1]) {
                return this.robotTimestamps.length - 1;
            }
            int index = Arrays.binarySearch(this.robotTimestamps, queryRobotTimestamp);
            if (index < 0) {
                int nextIndex;
                index = nextIndex = -index - 1;
            }
            return index;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public long getCurrentRobotTimestamp() {
            return this.currentRobotTimestamp;
        }

        public int getRobotTimestampsLength() {
            return this.robotTimestamps.length;
        }

        public long getRobotTimestampAtIndex(int i) {
            return this.robotTimestamps[i];
        }

        public long[] getRobotTimestampsArray() {
            return this.robotTimestamps;
        }

        public long[] getVideoTimestampsArray() {
            return this.videoTimestamps;
        }

        public long getCurrentVideoTimestamp() {
            return this.videoTimestamp;
        }
    }

    public static class FrameData {
        public WritableImage frame;
        public long queryRobotTimestamp;
        public long robotTimestamp;
        public long cameraCurrentPTS;
        public long demuxerCurrentPTS;
    }
}

