/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIntegerBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class ChartZoomManager
extends ObservedAnimationTimer {
    private final Window owner;
    private final SessionVisualizerTopics topics;
    private final JavaFXMessager messager;
    private final Property<ChartIntegerBounds> currentBoundsProperty = new SimpleObjectProperty((Object)this, "currentBoundsProperty", null);
    private final DoubleProperty zoomFactorProperty = new SimpleDoubleProperty((Object)this, "zoomFactor", 2.0);
    private final Property<YoBufferPropertiesReadOnly> currentBufferPropertiesProperty;
    private int previousBufferSize = -1;
    private boolean initialize = true;

    public ChartZoomManager(Window owner, JavaFXMessager messager, SessionVisualizerTopics topics) {
        this.owner = owner;
        this.topics = topics;
        this.messager = messager;
        messager.addFXTopicListener(topics.getYoChartZoomFactor(), m -> {
            if (m.getKey() == owner) {
                this.zoomFactorProperty.set(((Double)m.getValue()).doubleValue());
            }
        });
        this.currentBufferPropertiesProperty = messager.createPropertyInput(topics.getYoBufferCurrentProperties());
        messager.addTopicListener(topics.getYoChartRequestZoomIn(), this::processZoomInRequest);
        messager.addTopicListener(topics.getYoChartRequestZoomOut(), this::processZoomOutRequest);
        messager.addTopicListener(topics.getYoChartRequestShift(), this::processShiftRequest);
    }

    public void start() {
        super.start();
        this.initialize = true;
    }

    public boolean initializeBounds() {
        if (!this.initialize) {
            return true;
        }
        YoBufferPropertiesReadOnly currentBufferProperties = (YoBufferPropertiesReadOnly)this.currentBufferPropertiesProperty.getValue();
        if (currentBufferProperties == null) {
            return false;
        }
        this.currentBoundsProperty.setValue((Object)new ChartIntegerBounds(0, currentBufferProperties.getSize() - 1));
        this.initialize = false;
        return true;
    }

    @Override
    public void handleImpl(long now) {
        YoBufferPropertiesReadOnly currentBufferProperties = (YoBufferPropertiesReadOnly)this.currentBufferPropertiesProperty.getValue();
        if (currentBufferProperties != null && this.previousBufferSize != currentBufferProperties.getSize()) {
            this.initialize = true;
            this.previousBufferSize = currentBufferProperties.getSize();
        }
        if (!this.initializeBounds()) {
            return;
        }
        ChartIntegerBounds currentBounds = (ChartIntegerBounds)this.currentBoundsProperty.getValue();
        if (currentBounds.getUpper() >= currentBufferProperties.getSize()) {
            System.out.println("Reinitializing bounds");
            this.initialize = true;
            return;
        }
        int minIndex = 0;
        int maxIndex = currentBufferProperties.getSize() - 1;
        if (currentBounds.getLower() == minIndex && currentBounds.getUpper() == maxIndex) {
            return;
        }
        int currentIndex = currentBufferProperties.getCurrentIndex();
        if (currentBounds.isInside(currentIndex)) {
            return;
        }
        this.currentBoundsProperty.setValue((Object)currentBounds.center(currentIndex, minIndex, maxIndex));
    }

    private void processZoomInRequest(Pair<Window, Boolean> request) {
        if (request == null || request.getKey() != this.owner) {
            return;
        }
        if (!this.initializeBounds()) {
            return;
        }
        YoBufferPropertiesReadOnly currentBufferProperties = (YoBufferPropertiesReadOnly)this.currentBufferPropertiesProperty.getValue();
        int currentIndex = currentBufferProperties.getCurrentIndex();
        int minLength = 4;
        int minIndex = 0;
        int maxIndex = currentBufferProperties.getSize() - 1;
        ChartIntegerBounds oldBounds = (ChartIntegerBounds)this.currentBoundsProperty.getValue();
        this.currentBoundsProperty.setValue((Object)oldBounds.zoom(currentIndex, minLength, minIndex, maxIndex, this.zoomFactorProperty.getValue()));
    }

    private void processZoomOutRequest(Pair<Window, Boolean> request) {
        if (request == null || request.getKey() != this.owner) {
            return;
        }
        if (!this.initializeBounds()) {
            return;
        }
        YoBufferPropertiesReadOnly currentBufferProperties = (YoBufferPropertiesReadOnly)this.currentBufferPropertiesProperty.getValue();
        int currentIndex = currentBufferProperties.getCurrentIndex();
        int minLength = 4;
        int minIndex = 0;
        int maxIndex = currentBufferProperties.getSize() - 1;
        ChartIntegerBounds oldBounds = (ChartIntegerBounds)this.currentBoundsProperty.getValue();
        this.currentBoundsProperty.setValue((Object)oldBounds.zoom(currentIndex, minLength, minIndex, maxIndex, 1.0 / this.zoomFactorProperty.getValue()));
    }

    private void processShiftRequest(Pair<Window, Integer> request) {
        if (request == null || request.getKey() != this.owner) {
            return;
        }
        if (!this.initializeBounds()) {
            return;
        }
        ChartIntegerBounds currentBounds = (ChartIntegerBounds)this.currentBoundsProperty.getValue();
        YoBufferPropertiesReadOnly currentBufferProperties = (YoBufferPropertiesReadOnly)this.currentBufferPropertiesProperty.getValue();
        int minIndex = 0;
        int maxIndex = currentBufferProperties.getSize() - 1;
        if (currentBounds.getLower() == minIndex && currentBounds.getUpper() == maxIndex) {
            return;
        }
        int shiftRequest = (Integer)request.getValue();
        int newLowerBound = currentBounds.getLower() + shiftRequest;
        int newUpperBound = currentBounds.getUpper() + shiftRequest;
        int distanceFromMin = newLowerBound - minIndex;
        int distanceFromMax = newUpperBound - maxIndex;
        if (distanceFromMin < 0) {
            newLowerBound -= distanceFromMin;
            newUpperBound -= distanceFromMin;
        }
        if (distanceFromMax > 0) {
            newLowerBound -= distanceFromMax;
            newUpperBound -= distanceFromMax;
        }
        int length = newUpperBound - newLowerBound;
        int margin = Math.max(length / 20, 1);
        int lowerBoundForCurrentIndex = newLowerBound + margin;
        int upperBoundForCurrentIndex = newUpperBound - margin;
        if (currentBufferProperties.getCurrentIndex() <= lowerBoundForCurrentIndex) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)(lowerBoundForCurrentIndex + 2 * margin));
        }
        if (currentBufferProperties.getCurrentIndex() >= upperBoundForCurrentIndex) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)(upperBoundForCurrentIndex - 2 * margin));
        }
        this.currentBoundsProperty.setValue((Object)new ChartIntegerBounds(newLowerBound, newUpperBound));
    }

    public Property<ChartIntegerBounds> chartBoundsProperty() {
        return this.currentBoundsProperty;
    }
}

