/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResource;

public class YoGraphicFXResourceManager {
    public static final double SVG_SCALE = 0.001;
    public static final YoGraphicFXResource DEFAULT_POINT2D_GRAPHIC_RESOURCE = new YoGraphicFXResource(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_URL), SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_URL);
    public static final YoGraphicFXResource DEFAULT_POINT3D_GRAPHIC_RESOURCE = new YoGraphicFXResource(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_3D_SPHERE_URL), SessionVisualizerIOTools.GRAPHIC_3D_SPHERE_URL);
    private final Map<String, URL> graphic2DResourceMap = new LinkedHashMap<String, URL>();
    private final Map<String, URL> graphic3DResourceMap = new LinkedHashMap<String, URL>();

    public YoGraphicFXResourceManager() {
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_CROSS_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_PLUS_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_CROSS_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_PLUS_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_DIAMOND_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_DIAMOND_PLUS_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_SQUARE_URL);
        this.registerNewGraphic2D(SessionVisualizerIOTools.GRAPHIC_2D_SQUARE_CROSS_URL);
        this.registerNewGraphic3D(SessionVisualizerIOTools.GRAPHIC_3D_SPHERE_URL);
        this.registerNewGraphic3D(SessionVisualizerIOTools.GRAPHIC_3D_CUBE_URL);
        this.registerNewGraphic3D(SessionVisualizerIOTools.GRAPHIC_3D_TETRAHEDRON_URL);
        this.registerNewGraphic3D(SessionVisualizerIOTools.GRAPHIC_3D_ICOSAHEDRON_URL);
        this.registerCustomGraphics(SessionVisualizerIOTools.GRAPHIC_2D_CUSTOM_GRAPHICS, this.graphic2DResourceMap, Collections.singleton(".svg"));
        this.registerCustomGraphics(SessionVisualizerIOTools.GRAPHIC_3D_CUSTOM_GRAPHICS, this.graphic3DResourceMap, Arrays.asList(".stl", ".obj", ".dae"));
    }

    private void registerCustomGraphics(Path customGraphicsFolder, Map<String, URL> resourceMap, Collection<String> acceptableFileExtensions) {
        try {
            File[] customGraphics;
            FileTools.ensureDirectoryExists((Path)customGraphicsFolder);
            File customGraphicFolder = customGraphicsFolder.toFile();
            for (File customGraphic : customGraphics = customGraphicFolder.listFiles(file -> file.isFile() && acceptableFileExtensions.contains(file.getName().substring(file.getName().lastIndexOf("."), file.getName().length())))) {
                URL graphicURL = customGraphic.toURI().toURL();
                resourceMap.putIfAbsent(YoGraphicFXResourceManager.graphicName(graphicURL), graphicURL);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getGraphic2DNameList() {
        return this.graphic2DResourceMap.keySet();
    }

    public Collection<String> getGraphic3DNameList() {
        return this.graphic3DResourceMap.keySet();
    }

    public void registerNewGraphic2D(URL graphicURL) {
        this.graphic2DResourceMap.putIfAbsent(YoGraphicFXResourceManager.graphicName(graphicURL), graphicURL);
    }

    public void registerNewGraphic3D(URL graphicURL) {
        this.graphic3DResourceMap.putIfAbsent(YoGraphicFXResourceManager.graphicName(graphicURL), graphicURL);
    }

    public YoGraphicFXResource loadGraphic2DResource(String resourceName) {
        return new YoGraphicFXResource(resourceName, this.graphic2DResourceMap.get(resourceName));
    }

    public YoGraphicFXResource loadGraphic3DResource(String resourceName) {
        return new YoGraphicFXResource(resourceName, this.graphic3DResourceMap.get(resourceName));
    }

    public static String graphicName(URL graphicURL) {
        Object graphicName;
        FileSystem fs = null;
        try {
            Path path;
            URI graphicURI = graphicURL.toURI();
            if (graphicURI.toString().contains("!")) {
                HashMap env = new HashMap();
                String[] array = graphicURI.toString().split("!");
                fs = FileSystems.newFileSystem(URI.create(array[0]), env);
                path = fs.getPath(array[1], new String[0]);
            } else {
                path = Paths.get(graphicURI);
            }
            graphicName = path.getFileName().toString();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (((String)graphicName).contains(".")) {
            graphicName = ((String)graphicName).substring(0, ((String)graphicName).lastIndexOf("."));
        }
        graphicName = ((String)graphicName).replace("_", " ");
        graphicName = Character.toUpperCase(((String)graphicName).charAt(0)) + ((String)graphicName).substring(1);
        return graphicName;
    }
}

