/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.SimpleColorFX;

public class YoEllipsoidFX3D
extends YoGraphicFX3D {
    private final Sphere ellipsoidNode = new Sphere();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private Tuple3DProperty radii = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();

    public YoEllipsoidFX3D() {
        this.ellipsoidNode.setMaterial((Material)this.material);
        this.ellipsoidNode.getTransforms().add((Object)this.affine);
        this.ellipsoidNode.idProperty().bind((ObservableValue)this.nameProperty());
    }

    public YoEllipsoidFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
        this.radii.setReferenceFrame(worldFrame);
        this.ellipsoidNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.orientation.containsNaN()) {
            this.affine.setToIdentity();
            this.affine.appendScale(0.0, 0.0, 0.0);
            return;
        }
        this.affine.setToTransform((Transform)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        this.affine.appendScale(this.radii.getX(), this.radii.getY(), this.radii.getZ());
        if (this.color == null) {
            this.color = new SimpleColorFX();
        }
        this.material.setDiffuseColor(this.color.get());
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.radii = null;
        this.color = null;
    }

    @Override
    public YoGraphicFX clone() {
        YoEllipsoidFX3D clone = new YoEllipsoidFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setRadii(new Tuple3DProperty(this.radii));
        clone.setColor(this.color);
        return clone;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setRadii(Tuple3DProperty radii) {
        this.radii = radii;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public Tuple3DProperty getRadii() {
        return this.radii;
    }

    @Override
    public Node getNode() {
        return this.ellipsoidNode;
    }
}

