/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SecondaryWindowControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.ChartTable2D;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartGroupPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu.MainWindowMenuBarController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class SecondaryWindowController
implements VisualizerController {
    @FXML
    private VBox mainNode;
    @FXML
    private MainWindowMenuBarController menuController;
    @FXML
    private SecondaryWindowControlsController controlsController;
    private SessionVisualizerWindowToolkit toolkit;
    private YoChartGroupPanelController chartGroupController = null;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.menuController.initialize(toolkit);
        this.controlsController.initialize(toolkit);
        Stage owner = toolkit.getWindow();
        owner.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (e.isConsumed()) {
                return;
            }
            this.closeAndDispose();
            owner.close();
        });
    }

    public void setupChartGroup() throws IOException {
        Stage stage = this.toolkit.getWindow();
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_GROUP_PANEL_URL);
        AnchorPane chartGroupPane = (AnchorPane)loader.load();
        this.chartGroupController = (YoChartGroupPanelController)loader.getController();
        this.chartGroupController.initialize(this.toolkit);
        this.chartGroupController.start();
        this.chartGroupController.maxSizeProperty().setValue((Object)new ChartTable2D.ChartTable2DSize(9, 6));
        SessionVisualizerIOTools.addSCSIconToWindow((Window)stage);
        this.mainNode.getChildren().set(1, (Object)chartGroupPane);
        VBox.setVgrow((Node)chartGroupPane, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)this.mainNode, 1024.0, 768.0);
        stage.setScene(scene);
        String windowTitlePrefix = "Chart";
        stage.setTitle(windowTitlePrefix);
        this.chartGroupController.chartGroupNameProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                stage.setTitle(windowTitlePrefix);
            } else {
                stage.setTitle(windowTitlePrefix + ": " + newValue);
            }
        });
        stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (e.isConsumed()) {
                return;
            }
            stage.close();
            this.chartGroupController.closeAndDispose();
        });
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        configuration.addSecondaryWindowConfiguration(SecondaryWindowManager.toWindowConfigurationDefinition(this.toolkit.getWindow()));
        this.chartGroupController.saveChartGroupConfiguration((Window)this.toolkit.getWindow(), configuration.addSecondaryYoChartGroupConfigurationFile());
    }

    public void start() {
        this.toolkit.start();
    }

    public void closeAndDispose() {
        this.chartGroupController.closeAndDispose();
        this.toolkit.getWindow().close();
        this.toolkit.stop();
    }
}

