/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.hamburger.HamburgerTransition;
import java.util.ArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import us.ihmc.euclid.tools.EuclidCoreTools;

public class HamburgerAnimationTransition
extends CachedTransition
implements HamburgerTransition {
    private static final Interpolator interpolation = Interpolator.EASE_BOTH;
    private final Duration startTime = Duration.ZERO;
    private final Duration finalTime = Duration.millis((double)1000.0);
    private final JFXHamburger burger;
    private final Node line0;
    private final Node line1;
    private final Node line2;

    public HamburgerAnimationTransition(JFXHamburger burger) {
        this(burger, FrameType.LEFT_SHORT_ARROW, FrameType.RIGHT_ANGLE);
    }

    public HamburgerAnimationTransition(JFXHamburger burger, FrameType startType, FrameType finalType) {
        super((Node)burger, null);
        this.burger = burger;
        this.line0 = (Node)burger.getChildren().get(0);
        this.line1 = (Node)burger.getChildren().get(1);
        this.line2 = (Node)burger.getChildren().get(2);
        this.timeline.set((Object)this.createTimeline(startType, finalType));
        this.timeline.bind((ObservableValue)Bindings.createObjectBinding(() -> this.createTimeline(startType, finalType), (Observable[])new Observable[]{burger.widthProperty(), burger.heightProperty(), ((Region)this.line0).widthProperty(), ((Region)this.line0).heightProperty()}));
        this.setCycleDuration(Duration.seconds((double)0.5));
        this.setDelay(Duration.seconds((double)0.0));
        this.initializeFrameType();
    }

    public void initializeFrameType() {
        Platform.runLater(() -> {
            for (KeyValue keyValue : ((KeyFrame)((Timeline)this.timeline.get()).getKeyFrames().get(0)).getValues()) {
                keyValue.getTarget().setValue(keyValue.getEndValue());
            }
        });
    }

    private Timeline createTimeline(FrameType startType, FrameType finalType) {
        return new Timeline(new KeyFrame[]{this.keyFrame(this.startTime, startType), this.keyFrame(this.finalTime, finalType)});
    }

    private KeyFrame keyFrame(Duration time, FrameType type) {
        switch (type) {
            case BURGER: {
                return new KeyFrame(time, this.defaultKeyValues());
            }
            case LEFT_ARROW: {
                return new KeyFrame(time, this.arrowKeyValues(false, false));
            }
            case RIGHT_ARROW: {
                return new KeyFrame(time, this.arrowKeyValues(true, false));
            }
            case LEFT_SHORT_ARROW: {
                return new KeyFrame(time, this.arrowKeyValues(false, true));
            }
            case RIGHT_SHORT_ARROW: {
                return new KeyFrame(time, this.arrowKeyValues(true, true));
            }
            case LEFT_ANGLE: {
                return new KeyFrame(time, this.angleKeyValues(false, true));
            }
            case RIGHT_ANGLE: {
                return new KeyFrame(time, this.angleKeyValues(true, true));
            }
            case LEFT_CLOSE: {
                return new KeyFrame(time, this.closeKeyValues(false));
            }
            case RIGHT_CLOSE: {
                return new KeyFrame(time, this.closeKeyValues(true));
            }
        }
        throw new RuntimeException();
    }

    private KeyValue[] defaultKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (Node node : new Node[]{this.burger, this.line0, this.line1, this.line2}) {
            keyValues.add(new KeyValue((WritableValue)node.rotateProperty(), (Object)0, interpolation));
            keyValues.add(new KeyValue((WritableValue)node.translateXProperty(), (Object)0, interpolation));
            keyValues.add(new KeyValue((WritableValue)node.translateYProperty(), (Object)0, interpolation));
            keyValues.add(new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, interpolation));
            keyValues.add(new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, interpolation));
            keyValues.add(new KeyValue((WritableValue)node.opacityProperty(), (Object)1, interpolation));
        }
        return keyValues.toArray(new KeyValue[keyValues.size()]);
    }

    private KeyValue[] arrowKeyValues(boolean rightArrow, boolean shortArrow) {
        double translationX;
        double line1_translationX;
        double line1_scaleX;
        double line0Height = this.line0.getLayoutBounds().getHeight();
        double line0HalfHeight = line0Height / 2.0;
        double line0Width = this.line0.getBoundsInParent().getWidth();
        double line0HalfWidth = line0Width / 2.0;
        double burgerWidth = this.line0.getLayoutBounds().getWidth();
        double burgerHalfWidth = burgerWidth / 2.0;
        double burgerHeight = this.line2.getBoundsInParent().getMaxY() - this.line0.getBoundsInParent().getMinY();
        double burgerHalfHeight = burgerHeight / 2.0;
        double hypotenuse = EuclidCoreTools.norm((double)(burgerHalfHeight - line0HalfHeight), (double)burgerHalfWidth);
        double angle = Math.asin((burgerHalfHeight - line0HalfHeight) / hypotenuse);
        double angleDegrees = Math.toDegrees(angle);
        double burgerDiagonal = EuclidCoreTools.norm((double)line0Height, (double)line0HalfWidth);
        double theta = 1.5707963267948966 - angle + Math.atan(line0Height / line0HalfWidth);
        double hOffset = Math.cos(theta) * burgerDiagonal / 2.0;
        if (shortArrow) {
            line1_scaleX = 0.6;
            line1_translationX = -0.1 * burgerHalfWidth;
            translationX = 0.5 * burgerHalfWidth - Math.sin(theta) * (burgerDiagonal / 2.0);
        } else {
            line1_scaleX = 1.0;
            line1_translationX = 0.0;
            translationX = burgerHalfWidth - Math.sin(theta) * (burgerDiagonal / 2.0);
        }
        double translationY = line0HalfHeight + this.burger.getSpacing() - hOffset;
        if (!rightArrow) {
            angleDegrees = -angleDegrees;
            line1_translationX = -line1_translationX;
            translationX = -translationX;
        }
        return new KeyValue[]{new KeyValue((WritableValue)this.burger.rotateProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line0.rotateProperty(), (Object)angleDegrees, interpolation), new KeyValue((WritableValue)this.line0.translateXProperty(), (Object)translationX, interpolation), new KeyValue((WritableValue)this.line0.translateYProperty(), (Object)translationY, interpolation), new KeyValue((WritableValue)this.line0.scaleXProperty(), (Object)0.5, interpolation), new KeyValue((WritableValue)this.line0.opacityProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line1.translateXProperty(), (Object)line1_translationX, interpolation), new KeyValue((WritableValue)this.line1.translateYProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line1.scaleXProperty(), (Object)line1_scaleX, interpolation), new KeyValue((WritableValue)this.line1.opacityProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line2.rotateProperty(), (Object)(-angleDegrees), interpolation), new KeyValue((WritableValue)this.line2.translateXProperty(), (Object)translationX, interpolation), new KeyValue((WritableValue)this.line2.translateYProperty(), (Object)(-translationY), interpolation), new KeyValue((WritableValue)this.line2.scaleXProperty(), (Object)0.5, interpolation), new KeyValue((WritableValue)this.line2.opacityProperty(), (Object)1, interpolation)};
    }

    private KeyValue[] angleKeyValues(boolean rightAngle, boolean shortArrow) {
        double translationX;
        double line0Height = this.line0.getLayoutBounds().getHeight();
        double line0HalfHeight = line0Height / 2.0;
        double line0Width = this.line0.getBoundsInParent().getWidth();
        double line0HalfWidth = line0Width / 2.0;
        double burgerWidth = this.line0.getLayoutBounds().getWidth();
        double burgerHalfWidth = burgerWidth / 2.0;
        double burgerHeight = this.line2.getBoundsInParent().getMaxY() - this.line0.getBoundsInParent().getMinY();
        double burgerHalfHeight = burgerHeight / 2.0;
        double hypotenuse = EuclidCoreTools.norm((double)(burgerHalfHeight - line0HalfHeight), (double)burgerHalfWidth);
        double angle = Math.asin((burgerHalfHeight - line0HalfHeight) / hypotenuse);
        double angleDegrees = Math.toDegrees(angle);
        double burgerDiagonal = EuclidCoreTools.norm((double)line0Height, (double)line0HalfWidth);
        double theta = 1.5707963267948966 - angle + Math.atan(line0Height / line0HalfWidth);
        double hOffset = Math.cos(theta) * burgerDiagonal / 2.0;
        double line1_translationX = -this.burger.getWidth() / 1.1;
        if (shortArrow) {
            translationX = 0.5 * burgerHalfWidth - Math.sin(theta) * (burgerDiagonal / 2.0);
        } else {
            line1_translationX = 0.0;
            translationX = burgerHalfWidth - Math.sin(theta) * (burgerDiagonal / 2.0);
        }
        double translationY = 1.5 * line0HalfHeight + this.burger.getSpacing() - hOffset;
        if (!rightAngle) {
            angleDegrees = -angleDegrees;
            line1_translationX = -line1_translationX;
            translationX = -translationX;
        }
        return new KeyValue[]{new KeyValue((WritableValue)this.burger.rotateProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line0.rotateProperty(), (Object)angleDegrees, interpolation), new KeyValue((WritableValue)this.line0.translateXProperty(), (Object)translationX, interpolation), new KeyValue((WritableValue)this.line0.translateYProperty(), (Object)translationY, interpolation), new KeyValue((WritableValue)this.line0.scaleXProperty(), (Object)0.5, interpolation), new KeyValue((WritableValue)this.line0.opacityProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line1.translateXProperty(), (Object)line1_translationX, interpolation), new KeyValue((WritableValue)this.line1.translateYProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line1.scaleXProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line1.opacityProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line2.rotateProperty(), (Object)(-angleDegrees), interpolation), new KeyValue((WritableValue)this.line2.translateXProperty(), (Object)translationX, interpolation), new KeyValue((WritableValue)this.line2.translateYProperty(), (Object)(-translationY), interpolation), new KeyValue((WritableValue)this.line2.scaleXProperty(), (Object)0.5, interpolation), new KeyValue((WritableValue)this.line2.opacityProperty(), (Object)1, interpolation)};
    }

    private KeyValue[] closeKeyValues(boolean closeRight) {
        double burgerWidth = this.line0.getLayoutBounds().getWidth();
        double burgerHeight = this.line2.getBoundsInParent().getMaxY() - this.line0.getBoundsInParent().getMinY();
        double burgerHalfHeight = burgerHeight / 2.0;
        double hypotenuse = EuclidCoreTools.norm((double)burgerHeight, (double)burgerWidth);
        double angle = Math.toDegrees(Math.asin(burgerWidth / hypotenuse)) + 80.0;
        double line0_translationY = burgerHalfHeight - this.line0.getBoundsInLocal().getHeight() / 2.0;
        double line2_translationY = -burgerHalfHeight + this.line2.getBoundsInLocal().getHeight() / 2.0;
        double line1_translationX = -this.burger.getWidth() / 1.1;
        if (closeRight) {
            angle = -angle;
            line1_translationX = -line1_translationX;
        }
        return new KeyValue[]{new KeyValue((WritableValue)this.burger.rotateProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line0.rotateProperty(), (Object)angle, interpolation), new KeyValue((WritableValue)this.line0.translateXProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line0.translateYProperty(), (Object)line0_translationY, interpolation), new KeyValue((WritableValue)this.line0.scaleXProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line2.rotateProperty(), (Object)(-angle), interpolation), new KeyValue((WritableValue)this.line2.translateXProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line2.translateYProperty(), (Object)line2_translationY, interpolation), new KeyValue((WritableValue)this.line2.scaleXProperty(), (Object)1, interpolation), new KeyValue((WritableValue)this.line1.opacityProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line1.translateXProperty(), (Object)line1_translationX, interpolation), new KeyValue((WritableValue)this.line1.translateYProperty(), (Object)0, interpolation), new KeyValue((WritableValue)this.line1.scaleXProperty(), (Object)1, interpolation)};
    }

    public Transition getAnimation(JFXHamburger burger) {
        return new HamburgerAnimationTransition(burger);
    }

    public static enum FrameType {
        BURGER,
        LEFT_ARROW,
        RIGHT_ARROW,
        LEFT_SHORT_ARROW,
        RIGHT_SHORT_ARROW,
        LEFT_ANGLE,
        RIGHT_ANGLE,
        LEFT_CLOSE,
        RIGHT_CLOSE;

    }
}

