/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.entry;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Window;
import javax.xml.bind.JAXBException;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoEntry.YoEntryConfigurationDefinition;
import us.ihmc.scs2.definition.yoEntry.YoEntryListDefinition;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.entry.YoEntryListViewController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TabPaneTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;

public class YoEntryTabPaneController {
    @FXML
    private TabPane yoEntryTabPane;
    @FXML
    private Tab initialTab;
    @FXML
    private YoEntryListViewController initialListViewController;
    private final Map<Tab, YoEntryListViewController> tabToControllerMap = new HashMap<Tab, YoEntryListViewController>();
    private SessionVisualizerToolkit toolkit;
    private Window owner;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.owner = toolkit.getMainWindow();
        this.initialListViewController.initialize(toolkit);
        Label initialTabHeader = TabPaneTools.editableTabHeader(this.initialTab);
        this.initialListViewController.nameProperty().bindBidirectional((Property)initialTabHeader.textProperty());
        this.tabToControllerMap.put(this.initialTab, this.initialListViewController);
        MenuTools.setupContextMenu(this.yoEntryTabPane, TabPaneTools.addBeforeMenuItemFactory(this::newEmptyTab), TabPaneTools.addAfterMenuItemFactory(this::newEmptyTab), TabPaneTools.removeMenuItemFactory(), TabPaneTools.removeAllMenuItemFactory(false), this.exportTabMenuItemFactory(), this.exportAllTabMenuItemFactory(), this.importTabMenuItemFactory());
        this.yoEntryTabPane.getTabs().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Tab removedTab : change.getRemoved()) {
                    if (removedTab == this.initialTab) {
                        JavaFXMissingTools.runLater(this.getClass(), () -> this.yoEntryTabPane.getTabs().add((Object)this.initialTab));
                        initialTabHeader.setText("Default");
                        this.initialListViewController.clear();
                        continue;
                    }
                    this.tabToControllerMap.remove(removedTab);
                }
            }
        });
        this.yoEntryTabPane.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            for (Tab tab : this.yoEntryTabPane.getTabs()) {
                Node content = tab.getContent();
                if (content == null) continue;
                content.setDisable(tab != newValue);
            }
        });
        SCS2JavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        messager.addFXTopicListener(topics.getSessionCurrentState(), state -> {
            if (state == SessionState.INACTIVE) {
                this.yoEntryTabPane.getTabs().clear();
            }
        });
        messager.addFXTopicListener(topics.getYoEntryListAdd(), this::addYoEntryList);
    }

    public void setInput(YoEntryConfigurationDefinition input) {
        if (input.getYoEntryLists() == null) {
            return;
        }
        ObservableList tabs = this.yoEntryTabPane.getTabs();
        tabs.retainAll((Object[])new Tab[]{this.initialTab});
        while (tabs.size() < input.getYoEntryLists().size()) {
            tabs.add((Object)this.newEmptyTab());
        }
        List yoEntryLists = input.getYoEntryLists();
        for (int i = 0; i < yoEntryLists.size(); ++i) {
            this.tabToControllerMap.get(tabs.get(i)).setInput((YoEntryListDefinition)yoEntryLists.get(i));
        }
    }

    public void addYoEntryList(YoEntryListDefinition yoEntryListDefinition) {
        if (yoEntryListDefinition.getName() == null) {
            this.tabToControllerMap.get(this.initialTab).addYoEntries(yoEntryListDefinition.getYoEntries());
        } else {
            for (Tab tab : this.yoEntryTabPane.getTabs()) {
                if (!yoEntryListDefinition.getName().equals(tab.getText())) continue;
                this.tabToControllerMap.get(tab).addYoEntries(yoEntryListDefinition.getYoEntries());
                return;
            }
            Tab newTab = this.newEmptyTab();
            this.tabToControllerMap.get(newTab).setInput(yoEntryListDefinition);
            this.yoEntryTabPane.getTabs().add((Object)newTab);
        }
    }

    public YoEntryConfigurationDefinition toYoEntryConfigurationDefinition() {
        YoEntryConfigurationDefinition definition = new YoEntryConfigurationDefinition();
        definition.setYoEntryLists(new ArrayList());
        for (Tab tab : this.yoEntryTabPane.getTabs()) {
            definition.getYoEntryLists().add(this.tabToControllerMap.get(tab).toYoEntryListDefinition());
        }
        return definition;
    }

    private Function<TabPane, MenuItem> exportTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.yoEntryTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export active tab...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoEntryConfigurationSaveFileDialog(this.owner);
                if (result != null) {
                    this.exportSingleTab(result, selectedTab);
                }
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> exportAllTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.yoEntryTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export all tabs...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoEntryConfigurationSaveFileDialog(this.owner);
                if (result != null) {
                    this.exportAllTabs(result);
                }
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> importTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.yoEntryTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"load-icon-view");
            MenuItem menuItem = new MenuItem("Import tab(s)...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoEntryConfigurationOpenFileDialog(this.owner);
                if (result != null) {
                    this.importTabsAt(result, selectedTab);
                }
            });
            return menuItem;
        };
    }

    private Tab newEmptyTab() {
        try {
            Tab tab = new Tab("Tab" + (this.yoEntryTabPane.getTabs().size() - 1));
            Label tabHeader = TabPaneTools.editableTabHeader(tab);
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_ENTRY_LIST_VIEW_URL);
            Node node = (Node)loader.load();
            tab.setContent(node);
            YoEntryListViewController controller = (YoEntryListViewController)loader.getController();
            controller.nameProperty().bindBidirectional((Property)tabHeader.textProperty());
            controller.initialize(this.toolkit);
            this.tabToControllerMap.put(tab, controller);
            return tab;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportAllTabs(File file) {
        LogTools.info((String)("Saving to file: " + file));
        try {
            XMLTools.saveYoEntryConfigurationDefinition(new FileOutputStream(file), this.toYoEntryConfigurationDefinition());
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void exportSingleTab(File file, Tab tabToExport) {
        LogTools.info((String)("Saving single tab to file: " + file));
        try {
            YoEntryListDefinition tabDefinition = this.tabToControllerMap.get(tabToExport).toYoEntryListDefinition();
            XMLTools.saveYoEntryConfigurationDefinition(new FileOutputStream(file), new YoEntryConfigurationDefinition(tabDefinition));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoEntryConfigurationDefinition definition = XMLTools.loadYoEntryConfigurationDefinition(new FileInputStream(file));
            this.setInput(definition);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void importTabsAt(File file, Tab insertionPoint) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoEntryConfigurationDefinition definition = XMLTools.loadYoEntryConfigurationDefinition(new FileInputStream(file));
            List yoEntryLists = definition.getYoEntryLists();
            if (yoEntryLists == null || yoEntryLists.isEmpty()) {
                return;
            }
            int startIndex = 0;
            if (this.isTabEmpty(insertionPoint)) {
                this.tabToControllerMap.get(insertionPoint).setInput((YoEntryListDefinition)yoEntryLists.get(0));
                ++startIndex;
            }
            ObservableList tabs = this.yoEntryTabPane.getTabs();
            int insertionIndex = tabs.indexOf((Object)insertionPoint) + 1;
            for (int i = startIndex; i < yoEntryLists.size(); ++i) {
                Tab newEmptyTab = this.newEmptyTab();
                this.tabToControllerMap.get(newEmptyTab).setInput((YoEntryListDefinition)yoEntryLists.get(i));
                tabs.add(insertionIndex, (Object)newEmptyTab);
                ++insertionIndex;
            }
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private boolean isTabEmpty(Tab query) {
        return this.tabToControllerMap.get(query).isEmpty();
    }

    public void start() {
    }

    public void stop() {
    }
}

