/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import com.google.common.base.Objects;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.xml.bind.JAXBException;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000SliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TabPaneTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;

public class YoMultiBCF2000SliderboardWindowController {
    public static final String DEFAULT_SLIDERBOARD_NAME = "Default";
    @FXML
    private TabPane sliderboardTabPane;
    @FXML
    private Tab initialTab;
    @FXML
    private YoBCF2000SliderboardWindowController initialSliderboardPaneController;
    private final Map<Tab, YoBCF2000SliderboardWindowController> tabToControllerMap = new HashMap<Tab, YoBCF2000SliderboardWindowController>();
    private SessionVisualizerToolkit toolkit;
    private Stage window;
    private Window owner;
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.owner = toolkit.getMainWindow();
        this.window = new Stage(StageStyle.UTILITY);
        this.initialSliderboardPaneController.initialize((Window)this.window, toolkit);
        Label initialTabHeader = TabPaneTools.editableTabHeader(this.initialTab);
        this.tabToControllerMap.put(this.initialTab, this.initialSliderboardPaneController);
        MenuTools.setupContextMenu(this.sliderboardTabPane, TabPaneTools.addBeforeMenuItemFactory(this::newSliderboardTab), TabPaneTools.addAfterMenuItemFactory(this::newSliderboardTab), TabPaneTools.removeMenuItemFactory(), TabPaneTools.removeAllMenuItemFactory(false), this.exportTabMenuItemFactory(), this.exportAllTabMenuItemFactory(), this.importTabMenuItemFactory());
        ListChangeListener preserveInitialTabListener = change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Tab removedTab : change.getRemoved()) {
                    if (removedTab == this.initialTab) {
                        JavaFXMissingTools.runLater(this.getClass(), () -> this.sliderboardTabPane.getTabs().add((Object)this.initialTab));
                        initialTabHeader.setText(DEFAULT_SLIDERBOARD_NAME);
                        this.initialSliderboardPaneController.clear();
                        continue;
                    }
                    this.tabToControllerMap.remove(removedTab);
                }
            }
        };
        this.sliderboardTabPane.getTabs().addListener(preserveInitialTabListener);
        this.cleanupTasks.add(() -> this.sliderboardTabPane.getTabs().removeListener(preserveInitialTabListener));
        ChangeListener controllerScheduler = (o, oldValue, newValue) -> {
            if (oldValue != null) {
                this.tabToControllerMap.get(oldValue).stop();
            }
            if (newValue != null) {
                this.tabToControllerMap.get(newValue).start();
            }
        };
        this.sliderboardTabPane.getSelectionModel().selectedItemProperty().addListener(controllerScheduler);
        this.cleanupTasks.add(() -> this.sliderboardTabPane.getSelectionModel().selectedItemProperty().removeListener(controllerScheduler));
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, e -> {
            LogTools.info((String)"Stopping sliderboard binding.");
            this.tabToControllerMap.get(this.sliderboardTabPane.getSelectionModel().getSelectedItem()).stop();
        });
        this.window.addEventHandler(WindowEvent.WINDOW_SHOWING, e -> {
            LogTools.info((String)"Starting sliderboard binding.");
            this.tabToControllerMap.get(this.sliderboardTabPane.getSelectionModel().getSelectedItem()).start();
        });
        this.window.setTitle("YoSliderboard controller");
        this.window.setScene(new Scene((Parent)this.sliderboardTabPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
    }

    public void setInput(YoSliderboardListDefinition input) {
        if (input.getYoSliderboards() == null || input.getYoSliderboards().isEmpty()) {
            return;
        }
        ObservableList tabs = this.sliderboardTabPane.getTabs();
        tabs.retainAll((Object[])new Tab[]{this.initialTab});
        while (tabs.size() < input.getYoSliderboards().size()) {
            tabs.add((Object)this.newSliderboardTab());
        }
        List sliderboards = input.getYoSliderboards();
        for (int i = 0; i < sliderboards.size(); ++i) {
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)sliderboards.get(i);
            if (Objects.equal((Object)DEFAULT_SLIDERBOARD_NAME, (Object)sliderboard.getName())) {
                this.initialSliderboardPaneController.setInput(sliderboard);
                continue;
            }
            this.tabToControllerMap.get(tabs.get(i)).setInput(sliderboard);
        }
    }

    public void setSliderboard(YoSliderboardDefinition sliderboardDefinition) {
        Tab tab = this.findTabByName(sliderboardDefinition.getName());
        if (tab == null) {
            tab = this.newSliderboardTab();
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setInput(sliderboardDefinition);
    }

    public void closeSliderboard(String name) {
        Tab tabToRemove = this.findTabByName(name);
        if (tabToRemove != null) {
            this.sliderboardTabPane.getTabs().remove((Object)tabToRemove);
        }
    }

    public void setButtonInput(String sliderboardName, YoButtonDefinition buttonDefinition) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            tab = this.newSliderboardTab();
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setButtonInput(buttonDefinition);
    }

    public void removeButtonInput(String sliderboardName, int buttonIndex) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeButtonInput(buttonIndex);
    }

    public void setKnobInput(String sliderboardName, YoKnobDefinition knobDefinition) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            tab = this.newSliderboardTab();
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setKnobInput(knobDefinition);
    }

    public void removeKnobInput(String sliderboardName, int knobIndex) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeKnobInput(knobIndex);
    }

    public void setSliderInput(String sliderboardName, YoSliderDefinition sliderDefinition) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            tab = this.newSliderboardTab();
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setSliderInput(sliderDefinition);
    }

    public void removeSliderInput(String sliderboardName, int sliderIndex) {
        Tab tab = this.findTabByName(sliderboardName);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeSliderInput(sliderIndex);
    }

    private Tab findTabByName(String name) {
        if (name == null) {
            return null;
        }
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            if (!name.equals(this.tabToControllerMap.get(tab).nameProperty().get())) continue;
            return tab;
        }
        return null;
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void clear() {
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            YoBCF2000SliderboardWindowController controller = this.tabToControllerMap.get(tab);
            controller.close();
        }
        this.sliderboardTabPane.getTabs().clear();
        this.tabToControllerMap.clear();
        this.tabToControllerMap.put(this.initialTab, this.initialSliderboardPaneController);
    }

    public void close() {
        this.cleanupTasks.forEach(Runnable::run);
        this.cleanupTasks.clear();
        this.clear();
        this.window.close();
        BCF2000SliderboardController.closeMidiDevices();
    }

    public Stage getWindow() {
        return this.window;
    }

    private Function<TabPane, MenuItem> exportTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export active tab...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoSliderboardConfigurationSaveFileDialog(this.owner);
                if (result != null) {
                    this.tabToControllerMap.get(selectedTab).save(result);
                }
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> exportAllTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export all tabs...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoSliderboardConfigurationSaveFileDialog(this.owner);
                if (result != null) {
                    this.exportAllTabs(result);
                }
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> importTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            FontAwesomeIconView exportIcon = new FontAwesomeIconView();
            exportIcon.getStyleClass().add((Object)"load-icon-view");
            MenuItem menuItem = new MenuItem("Import tab(s)...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoSliderboardConfigurationOpenFileDialog(this.owner);
                if (result != null) {
                    this.importTabsAt(result, selectedTab);
                }
            });
            return menuItem;
        };
    }

    private Tab newSliderboardTab() {
        try {
            Tab tab = new Tab("Sliderboard" + (this.sliderboardTabPane.getTabs().size() - 1));
            Label tabHeader = TabPaneTools.editableTabHeader(tab);
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_SLIDERBOARD_BCF2000_WINDOW_URL);
            Node node = (Node)loader.load();
            tab.setContent(node);
            YoBCF2000SliderboardWindowController controller = (YoBCF2000SliderboardWindowController)loader.getController();
            controller.nameProperty().bindBidirectional((Property)tabHeader.textProperty());
            controller.initialize((Window)this.window, this.toolkit);
            this.tabToControllerMap.put(tab, controller);
            return tab;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportAllTabs(File file) {
        LogTools.info((String)("Saving to file: " + file));
        try {
            XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), this.toYoSliderboardListDefinition());
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void importTabsAt(File file, Tab insertionPoint) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoSliderboardListDefinition definition = XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file));
            List yoEntryLists = definition.getYoSliderboards();
            if (yoEntryLists == null || yoEntryLists.isEmpty()) {
                return;
            }
            int startIndex = 0;
            if (this.isTabEmpty(insertionPoint)) {
                this.tabToControllerMap.get(insertionPoint).setInput((YoSliderboardDefinition)yoEntryLists.get(0));
                ++startIndex;
            }
            ObservableList tabs = this.sliderboardTabPane.getTabs();
            int insertionIndex = tabs.indexOf((Object)insertionPoint) + 1;
            for (int i = startIndex; i < yoEntryLists.size(); ++i) {
                Tab newEmptyTab = this.newSliderboardTab();
                this.tabToControllerMap.get(newEmptyTab).setInput((YoSliderboardDefinition)yoEntryLists.get(i));
                tabs.add(insertionIndex, (Object)newEmptyTab);
                this.sliderboardTabPane.getSelectionModel().select(insertionIndex);
                ++insertionIndex;
            }
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private boolean isTabEmpty(Tab query) {
        return this.tabToControllerMap.get(query).isEmpty();
    }

    public YoSliderboardListDefinition toYoSliderboardListDefinition() {
        YoSliderboardListDefinition definition = new YoSliderboardListDefinition();
        definition.setYoSliderboards(new ArrayList());
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            definition.getYoSliderboards().add(this.tabToControllerMap.get(tab).toYoSliderboardDefinition());
        }
        return definition;
    }
}

