/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBCF2000KnobController
extends YoBCF2000InputController {
    @FXML
    private VBox rootPane;
    @FXML
    private JFXTextField knobMaxTextField;
    @FXML
    private JFXTextField knobMinTextField;
    @FXML
    private JFXSpinner spinner;
    @FXML
    private Label yoVariableDropLabel;
    private SliderboardVariable sliderVariable;
    private YoVariableSlider yoVariableSlider;
    private YoManager yoManager;
    private BCF2000SliderboardController.Knob knobChannel;

    public void initialize(SessionVisualizerToolkit toolkit, BCF2000SliderboardController.Knob knobChannel, SliderboardVariable sliderVariable) {
        this.knobChannel = knobChannel;
        this.sliderVariable = sliderVariable;
        this.yoManager = toolkit.getYoManager();
        super.initialize(toolkit, (Region)this.rootPane, (Labeled)this.yoVariableDropLabel);
        this.clear();
    }

    @Override
    public void clear() {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        this.yoVariableSlider = null;
        super.clear();
        this.spinner.setProgress(0.0);
        this.spinner.setDisable(true);
        this.knobMaxTextField.setText("");
        this.knobMinTextField.setText("");
        this.knobMaxTextField.setDisable(true);
        this.knobMinTextField.setDisable(true);
    }

    public void setInput(YoKnobDefinition definition) {
        YoVariable yoVariable;
        if (definition == null) {
            this.clear();
            return;
        }
        if (definition.getVariableName() != null) {
            yoVariable = this.yoManager.getRootRegistryDatabase().searchExact(definition.getVariableName());
            if (yoVariable == null) {
                LogTools.warn((String)("Could not find variable for slider: " + definition.getVariableName()));
            }
        } else {
            yoVariable = null;
        }
        this.setYoVariableInput(yoVariable, definition.getMinValue(), definition.getMaxValue());
    }

    @Override
    public void setYoVariableInput(YoVariable yoVariable) {
        this.setYoVariableInput(yoVariable, null, null);
    }

    private void setYoVariableInput(YoVariable yoVariable, String minValue, String maxValue) {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        if (yoVariable == null) {
            this.clear();
            return;
        }
        this.spinner.setDisable(false);
        this.yoVariableSlider = YoVariableSlider.newYoVariableSlider(yoVariable, this.yoManager.getLinkedRootRegistry());
        this.yoVariableSlider.bindMinTextField(this.knobMinTextField);
        this.yoVariableSlider.bindMaxTextField(this.knobMaxTextField);
        if (this.sliderVariable != null) {
            this.yoVariableSlider.bindSliderVariable(this.sliderVariable);
        }
        this.yoVariableSlider.bindVirtualKnob(this.spinner);
        if (minValue != null && !this.knobMinTextField.isDisabled()) {
            if (this.isMinValid(yoVariable, minValue)) {
                this.knobMinTextField.setText(minValue);
            } else {
                LogTools.warn((String)"Discarding invalid minValue (={}) for knob bound to the variable {}", (Object)minValue, (Object)yoVariable);
            }
        }
        if (maxValue != null && !this.knobMaxTextField.isDisabled()) {
            if (this.isMaxValid(yoVariable, maxValue)) {
                this.knobMaxTextField.setText(maxValue);
            } else {
                LogTools.warn((String)"Discarding invalid maxValue (={}) for knob bound to the variable {}", (Object)maxValue, (Object)yoVariable);
            }
        }
        this.setupYoVariableSlider(this.yoVariableSlider);
    }

    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = this.yoVariableSlider == null ? new YoKnobDefinition() : this.yoVariableSlider.toYoKnobDefinition();
        definition.setIndex(this.knobChannel.ordinal());
        return definition;
    }
}

