/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.stage.Window;
import javafx.util.Pair;
import javax.xml.bind.JAXBException;
import us.ihmc.log.LogTools;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoMultiBCF2000SliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;

public class YoSliderboardManager
implements Manager {
    private final Property<YoMultiBCF2000SliderboardWindowController> bcf2000Sliderboard = new SimpleObjectProperty((Object)this, "bcf2000Sliderboard", null);
    private final SessionVisualizerToolkit toolkit;
    private final SessionVisualizerTopics topics;
    private final JavaFXMessager messager;
    private YoSliderboardListDefinition initialConfiguration = null;
    private final TopicListener<File> saveRequestListener = m -> this.handleSaveRequest((File)m);
    private final TopicListener<File> loadRequestListener = m -> this.handleLoadRequest((File)m);
    private final TopicListener<Boolean> clearAllRequestListener = m -> this.handleClearRequest((Boolean)m);
    private final TopicListener<YoSliderboardListDefinition> setMultiRequestListener = m -> this.handleSetRequest((YoSliderboardListDefinition)m);
    private final TopicListener<YoSliderboardDefinition> setSingleRequestListener = m -> this.handleSetRequest((YoSliderboardDefinition)m);
    private final TopicListener<String> removeRequestListener = m -> this.handleRemoveRequest((String)m);
    private final TopicListener<Pair<String, YoButtonDefinition>> setButtonRequestListener = m -> this.handleSetButtonRequest((String)m.getKey(), (YoButtonDefinition)m.getValue());
    private final TopicListener<Pair<String, YoKnobDefinition>> setKnobRequestListener = m -> this.handleSetKnobRequest((String)m.getKey(), (YoKnobDefinition)m.getValue());
    private final TopicListener<Pair<String, YoSliderDefinition>> setSliderRequestListener = m -> this.handleSetSliderRequest((String)m.getKey(), (YoSliderDefinition)m.getValue());
    private final TopicListener<Pair<String, Integer>> clearButtonRequestListener = m -> this.handleClearButtonRequest((String)m.getKey(), (Integer)m.getValue());
    private final TopicListener<Pair<String, Integer>> clearKnobRequestListener = m -> this.handleClearKnobRequest((String)m.getKey(), (Integer)m.getValue());
    private final TopicListener<Pair<String, Integer>> clearSliderRequestListener = m -> this.handleClearSliderRequest((String)m.getKey(), (Integer)m.getValue());

    public YoSliderboardManager(SessionVisualizerToolkit toolkit) {
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.toolkit = toolkit;
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        this.handleSaveRequest(configuration.getYoSliderboardConfigurationFile());
    }

    @Override
    public void startSession(Session session) {
        this.initialConfiguration = null;
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardSave(), this.saveRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardLoad(), this.loadRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardClearAll(), this.clearAllRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardSet(), this.setMultiRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSet(), this.setSingleRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardRemove(), this.removeRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetButton(), this.setButtonRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetKnob(), this.setKnobRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetSlider(), this.setSliderRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearButton(), this.clearButtonRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearKnob(), this.clearKnobRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearSlider(), this.clearSliderRequestListener);
    }

    @Override
    public void stopSession() {
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardSave(), this.saveRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardLoad(), this.loadRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardClearAll(), this.clearAllRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardSet(), this.setMultiRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSet(), this.setSingleRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardRemove(), this.removeRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetButton(), this.setButtonRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetKnob(), this.setKnobRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetSlider(), this.setSliderRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearButton(), this.clearButtonRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearKnob(), this.clearKnobRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearSlider(), this.clearSliderRequestListener);
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).close();
            this.bcf2000Sliderboard.setValue(null);
        }
    }

    @Override
    public boolean isSessionLoaded() {
        return false;
    }

    private void handleSaveRequest(File file) {
        YoSliderboardListDefinition definitionToSave = this.bcf2000Sliderboard.getValue() != null ? ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).toYoSliderboardListDefinition() : this.initialConfiguration;
        if (definitionToSave != null) {
            try {
                XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), definitionToSave);
            }
            catch (IOException | JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleLoadRequest(File file) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            this.handleSetRequest(XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file)));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private void handleClearRequest(Boolean m) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).clear();
        } else {
            this.initialConfiguration = null;
        }
    }

    private void handleSetRequest(YoSliderboardListDefinition definition) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).setInput(definition);
        } else {
            this.initialConfiguration = new YoSliderboardListDefinition(definition);
        }
    }

    private void handleSetRequest(YoSliderboardDefinition definition) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).setSliderboard(definition);
        } else {
            int index;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((index = this.findSliderboardIndex(definition.getName())) != -1) {
                ((YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(index)).set(definition);
            } else {
                this.initialConfiguration.getYoSliderboards().add(definition);
            }
        }
    }

    private void handleRemoveRequest(String sliderboardName) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).closeSliderboard(sliderboardName);
        } else {
            int index;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((index = this.findSliderboardIndex(sliderboardName)) != -1) {
                this.initialConfiguration.getYoSliderboards().remove(index);
            }
        }
    }

    private void handleSetButtonRequest(String sliderboardName, YoButtonDefinition buttonDefinition) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).setButtonInput(sliderboardName, buttonDefinition);
        } else {
            YoSliderboardDefinition sliderboard;
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) != -1) {
                sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            } else {
                sliderboard = new YoSliderboardDefinition(sliderboardName);
                this.initialConfiguration.getYoSliderboards().add(sliderboard);
            }
            sliderboard.getButtons().add(new YoButtonDefinition(buttonDefinition));
        }
    }

    private void handleSetKnobRequest(String sliderboardName, YoKnobDefinition knobDefinition) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).setKnobInput(sliderboardName, knobDefinition);
        } else {
            YoSliderboardDefinition sliderboard;
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) != -1) {
                sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            } else {
                sliderboard = new YoSliderboardDefinition(sliderboardName);
                this.initialConfiguration.getYoSliderboards().add(sliderboard);
            }
            sliderboard.getKnobs().add(new YoKnobDefinition(knobDefinition));
        }
    }

    private void handleSetSliderRequest(String sliderboardName, YoSliderDefinition sliderDefinition) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).setSliderInput(sliderboardName, sliderDefinition);
        } else {
            YoSliderboardDefinition sliderboard;
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) != -1) {
                sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            } else {
                sliderboard = new YoSliderboardDefinition(sliderboardName);
                this.initialConfiguration.getYoSliderboards().add(sliderboard);
            }
            sliderboard.getSliders().add(new YoSliderDefinition(sliderDefinition));
        }
    }

    private void handleClearButtonRequest(String sliderboardName, int buttonIndex) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).removeButtonInput(sliderboardName, buttonIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List buttons = sliderboard.getButtons();
            for (int i = buttons.size() - 1; i >= 0; --i) {
                if (i == buttonIndex && ((YoButtonDefinition)buttons.get(i)).getIndex() == -1) {
                    buttons.remove(i);
                    continue;
                }
                if (((YoButtonDefinition)buttons.get(i)).getIndex() != buttonIndex) continue;
                buttons.remove(i);
            }
        }
    }

    private void handleClearKnobRequest(String sliderboardName, int knobIndex) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).removeKnobInput(sliderboardName, knobIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List knobs = sliderboard.getKnobs();
            for (int i = knobs.size() - 1; i >= 0; --i) {
                if (i == knobIndex && ((YoKnobDefinition)knobs.get(i)).getIndex() == -1) {
                    knobs.remove(i);
                    continue;
                }
                if (((YoKnobDefinition)knobs.get(i)).getIndex() != knobIndex) continue;
                knobs.remove(i);
            }
        }
    }

    private void handleClearSliderRequest(String sliderboardName, int sliderIndex) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).removeSliderInput(sliderboardName, sliderIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List sliders = sliderboard.getSliders();
            for (int i = sliders.size() - 1; i >= 0; --i) {
                if (i == sliderIndex && ((YoSliderDefinition)sliders.get(i)).getIndex() == -1) {
                    sliders.remove(i);
                    continue;
                }
                if (((YoSliderDefinition)sliders.get(i)).getIndex() != sliderIndex) continue;
                sliders.remove(i);
            }
        }
    }

    private int findSliderboardIndex(String sliderboardName) {
        if (sliderboardName == null) {
            return -1;
        }
        List yoSliderboards = this.initialConfiguration.getYoSliderboards();
        for (int i = 0; i < yoSliderboards.size(); ++i) {
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)yoSliderboards.get(i);
            if (!sliderboardName.equals(sliderboard.getName())) continue;
            return i;
        }
        return -1;
    }

    public void openBCF2000SliderboardWindow(Window requestSource) {
        if (this.bcf2000Sliderboard.getValue() != null) {
            ((YoMultiBCF2000SliderboardWindowController)this.bcf2000Sliderboard.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_MULTI_SLIDERBOARD_BCF2000_WINDOW_URL);
            fxmlLoader.load();
            YoMultiBCF2000SliderboardWindowController controller = (YoMultiBCF2000SliderboardWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            if (this.initialConfiguration != null) {
                controller.setInput(this.initialConfiguration);
                this.initialConfiguration = null;
            }
            this.bcf2000Sliderboard.setValue((Object)controller);
            SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

