/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXButton;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.ChartTable2D;

public class TableSizeQuickAccess {
    private static final String UNSELECTED = "-fx-stroke:black; -fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.8), 3, 0, 0, 0);";
    private static final String SELECTED = "-fx-stroke:darkred; -fx-effect: dropshadow(three-pass-box, rgba(0.3,0,0,0.8), 5, 0, 0, 0);";
    private final AnchorPane anchorPane = new AnchorPane();
    private final VBox vBox = new VBox(5.0);
    private final GridPane gridPane = new GridPane();
    private final Tooltip tooltip = new Tooltip();
    private final Rectangle[][] boxes;
    private final JFXButton clearAllButton;
    private final JFXButton clearEmptyButton;
    private final ChartTable2D.ChartTable2DSize maxSize;
    private final IntegerProperty selectedRowsProperty = new SimpleIntegerProperty((Object)this, "selectedRows", -1);
    private final IntegerProperty selectedColumnsProperty = new SimpleIntegerProperty((Object)this, "selectedColumns", -1);

    public TableSizeQuickAccess(String title, ChartTable2D.ChartTable2DSize currentSize, ChartTable2D.ChartTable2DSize maxSize) {
        this.maxSize = maxSize;
        this.anchorPane.getChildren().add((Object)this.vBox);
        AnchorPane.setTopAnchor((Node)this.vBox, (Double)5.0);
        AnchorPane.setLeftAnchor((Node)this.vBox, (Double)5.0);
        AnchorPane.setRightAnchor((Node)this.vBox, (Double)5.0);
        AnchorPane.setBottomAnchor((Node)this.vBox, (Double)5.0);
        this.vBox.getChildren().add((Object)this.gridPane);
        this.clearAllButton = new JFXButton("Clear All");
        this.clearAllButton.getStyleClass().add((Object)"chart-table-view-clear-button");
        this.clearEmptyButton = new JFXButton("Clear Empty");
        this.clearEmptyButton.getStyleClass().add((Object)"chart-table-view-clear-button");
        this.vBox.getChildren().add((Object)new HBox(3.0, new Node[]{this.clearAllButton, this.clearEmptyButton}));
        this.vBox.getStylesheets().add((Object)SessionVisualizerIOTools.GENERAL_STYLESHEET.toExternalForm());
        if (title != null) {
            Text titleText = new Text(title);
            this.vBox.getChildren().add(0, (Object)titleText);
        }
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setOnMouseExited(e -> {
            this.updateSelectionStyleHandler(-1, -1);
            this.tooltip.hide();
        });
        this.gridPane.setOnMouseMoved(e -> this.tooltip.show((Node)this.gridPane, e.getScreenX() + 10.0, e.getScreenY() + 20.0));
        this.boxes = new Rectangle[maxSize.getNumberOfRows()][maxSize.getNumberOfCols()];
        for (int row = 0; row < maxSize.getNumberOfRows(); ++row) {
            int col = 0;
            while (col < maxSize.getNumberOfCols()) {
                Paint boxPaint = row < currentSize.getNumberOfRows() && col < currentSize.getNumberOfCols() ? Paint.valueOf((String)"#b5b576") : Paint.valueOf((String)"#a0a4a8");
                Rectangle box = new Rectangle(30.0, 30.0, boxPaint);
                box.setStroke((Paint)Color.BLACK);
                box.setStrokeWidth(2.0);
                box.setStrokeType(StrokeType.INSIDE);
                box.setStrokeLineCap(StrokeLineCap.SQUARE);
                box.setStrokeLineJoin(StrokeLineJoin.MITER);
                box.setStrokeMiterLimit(10.0);
                box.setStyle(UNSELECTED);
                this.boxes[row][col] = box;
                this.gridPane.getChildren().add((Object)box);
                GridPane.setRowIndex((Node)box, (Integer)row);
                GridPane.setColumnIndex((Node)box, (Integer)col);
                int finalRow = row;
                int finalCol = col++;
                box.setOnMouseEntered(e -> this.updateSelectionStyleHandler(finalRow, finalCol));
            }
        }
    }

    private void updateSelectionStyleHandler(int lastSelectedRow, int lastSelectedCol) {
        int row;
        for (row = 0; row <= lastSelectedRow; ++row) {
            int col;
            Rectangle[] rowBoxes = this.boxes[row];
            for (col = 0; col <= lastSelectedCol; ++col) {
                rowBoxes[col].setStyle(SELECTED);
            }
            for (col = lastSelectedCol + 1; col < this.maxSize.getNumberOfCols(); ++col) {
                rowBoxes[col].setStyle(UNSELECTED);
            }
        }
        for (row = lastSelectedRow + 1; row < this.maxSize.getNumberOfRows(); ++row) {
            for (int col = 0; col < this.maxSize.getNumberOfCols(); ++col) {
                this.boxes[row][col].setStyle(UNSELECTED);
            }
        }
        this.selectedRowsProperty.set(lastSelectedRow + 1);
        this.selectedColumnsProperty.set(lastSelectedCol + 1);
        this.tooltip.setText(String.format("Rows: %d, columns: %d", this.selectedRowsProperty.get(), this.selectedColumnsProperty.get()));
    }

    public IntegerProperty selectedRowsProperty() {
        return this.selectedRowsProperty;
    }

    public IntegerProperty selectedColumnsProperty() {
        return this.selectedColumnsProperty;
    }

    public JFXButton getClearAllButton() {
        return this.clearAllButton;
    }

    public JFXButton getClearEmptyButton() {
        return this.clearEmptyButton;
    }

    public AnchorPane getMainPane() {
        return this.anchorPane;
    }
}

