/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResource;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoPointFX3D
extends YoGraphicFX3D {
    private final Group pointNode = new Group();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private DoubleProperty size = new SimpleDoubleProperty(0.1);
    private final Translate translate = new Translate();
    private final Scale scale = new Scale();
    private final PhongMaterial material = new PhongMaterial();
    private YoGraphicFXResource graphicResource;

    public YoPointFX3D() {
        this.pointNode.getTransforms().addAll((Object[])new Transform[]{this.translate, this.scale});
        this.setGraphicResource(YoGraphicFXResourceManager.DEFAULT_POINT3D_GRAPHIC_RESOURCE);
        this.pointNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.pointNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoPointFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
    }

    public void setGraphicResource(YoGraphicFXResource graphicResource) {
        if (graphicResource == null || graphicResource.getResourceURL() == null) {
            return;
        }
        this.graphicResource = graphicResource;
        this.pointNode.getChildren().clear();
        Object[] nodes = JavaFXVisualTools.importModel(graphicResource.getResourceURL());
        List<Shape3D> shapes = YoGraphicTools.extractShape3Ds(Arrays.asList(nodes));
        for (Shape3D shape : shapes) {
            shape.setMaterial((Material)this.material);
            shape.idProperty().bind((ObservableValue)this.nameProperty());
        }
        this.pointNode.getChildren().addAll(nodes);
    }

    @Override
    public void render() {
        if (this.position.containsNaN() || this.size != null && Double.isNaN(this.size.get())) {
            this.scale.setX(0.0);
            this.scale.setY(0.0);
            this.scale.setZ(0.0);
            return;
        }
        Point3D positionInWorld = this.position.toPoint3DInWorld();
        this.translate.setX(positionInWorld.getX());
        this.translate.setY(positionInWorld.getY());
        this.translate.setZ(positionInWorld.getZ());
        if (this.size == null) {
            this.size = new SimpleDoubleProperty(0.1);
        }
        this.scale.setX(this.size.get());
        this.scale.setY(this.size.get());
        this.scale.setZ(this.size.get());
        this.material.setDiffuseColor(this.color.get());
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setSize(DoubleProperty size) {
        this.size = size;
    }

    public void setSize(double size) {
        this.size = new SimpleDoubleProperty(size);
    }

    @Override
    public void clear() {
        this.position = null;
        this.size = null;
        this.color = null;
    }

    @Override
    public YoPointFX3D clone() {
        YoPointFX3D clone = new YoPointFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setSize(this.size);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public DoubleProperty getSize() {
        return this.size;
    }

    public YoGraphicFXResource getGraphicResource() {
        return this.graphicResource;
    }

    @Override
    public Node getNode() {
        return this.pointNode;
    }
}

