/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartDataManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartZoomManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.KeyFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionDataPreferenceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.WindowShortcutManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoGraphicFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class SessionVisualizerWindowToolkit {
    private final Stage window;
    private final SessionVisualizerToolkit globalToolkit;
    private final ChartZoomManager chartZoomManager;
    private final WindowShortcutManager windowShortcutManager;

    public SessionVisualizerWindowToolkit(Stage window, SessionVisualizerToolkit globalToolkit) {
        this.window = window;
        this.globalToolkit = globalToolkit;
        this.chartZoomManager = new ChartZoomManager((Window)window, this.getMessager(), this.getTopics());
        this.windowShortcutManager = new WindowShortcutManager((Window)window, this.getMessager(), this.getTopics());
    }

    public void start() {
        this.chartZoomManager.start();
        this.windowShortcutManager.start();
    }

    public void stop() {
        this.chartZoomManager.stop();
        this.windowShortcutManager.stop();
    }

    public Stage getWindow() {
        return this.window;
    }

    public SessionVisualizerToolkit getGlobalToolkit() {
        return this.globalToolkit;
    }

    public BufferedJavaFXMessager getMessager() {
        return this.globalToolkit.getMessager();
    }

    public SessionVisualizerTopics getTopics() {
        return this.globalToolkit.getTopics();
    }

    public YoCompositeSearchManager getYoCompositeSearchManager() {
        return this.globalToolkit.getYoCompositeSearchManager();
    }

    public BackgroundExecutorManager getBackgroundExecutorManager() {
        return this.globalToolkit.getBackgroundExecutorManager();
    }

    public ChartDataManager getChartDataManager() {
        return this.globalToolkit.getChartDataManager();
    }

    public ChartRenderManager getChartRenderManager() {
        return this.globalToolkit.getChartRenderManager();
    }

    public ChartZoomManager getChartZoomManager() {
        return this.chartZoomManager;
    }

    public YoManager getYoManager() {
        return this.globalToolkit.getYoManager();
    }

    public KeyFrameManager getKeyFrameManager() {
        return this.globalToolkit.getKeyFrameManager();
    }

    public YoGroupFX getYoGraphicFXRootGroup() {
        return this.globalToolkit.getYoGraphicFXRootGroup();
    }

    public ReferenceFrameManager getReferenceFrameManager() {
        return this.globalToolkit.getReferenceFrameManager();
    }

    public YoGraphicFXManager getYoGraphicFXManager() {
        return this.globalToolkit.getYoGraphicFXManager();
    }

    public SessionDataPreferenceManager getSessionDataPreferenceManager() {
        return this.globalToolkit.getSessionDataPreferenceManager();
    }
}

