/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicBox3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoBoxFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoBoxFX3DEditorController
extends YoGraphicFX3DEditorController<YoBoxFX3D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private YoCompositeEditorPaneController orientationEditorController;
    @FXML
    private YoCompositeEditorPaneController sizeEditorController;
    private YoGraphicBox3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoBoxFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicBox3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupOrientation3DProperty(this.orientationEditorController, "Orientation", true, yoGraphicToEdit.getOrientation());
        this.setupTuple3DPropertyEditor(this.sizeEditorController, "Size", false, yoGraphicToEdit.getSize());
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicBox3DDefinition((YoBoxFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.orientationEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrientation());
        this.sizeEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getSize());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoBoxFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicBox3DDefinition((YoBoxFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

