/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.controlsfx.control.CheckTreeView;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.SearchEngines;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXCreatorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXItemTreeCell;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicItemCreatorDialogController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TreeViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class YoGraphicPropertyWindowController
extends ObservedAnimationTimer {
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private CheckTreeView<YoGraphicFXItem> yoGraphicTreeView;
    @FXML
    private Button addItemButton;
    @FXML
    private Button removeItemButton;
    @FXML
    private TextField searchTextField;
    @FXML
    private Label yoGraphicTypeLabel;
    @FXML
    private AnchorPane yoGraphicEditorPane;
    @FXML
    private Button saveChangesButton;
    @FXML
    private Button revertChangesButton;
    private CheckBoxTreeItem<YoGraphicFXItem> defaultRootItem;
    private CheckBoxTreeItem<YoGraphicFXItem> searchResult = null;
    private List<YoGraphicFXItem> allGraphicItems;
    private Future<CheckBoxTreeItem<YoGraphicFXItem>> backgroundSearch;
    private BackgroundExecutorManager backgroundExecutorManager;
    private SessionVisualizerToolkit toolkit;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private final ObjectProperty<YoGraphicItemCreatorDialogController> cachedItemCreator = new SimpleObjectProperty((Object)this, "cachedItemCreator", null);
    private final ObjectProperty<YoGraphicFXCreatorController<YoGraphicFXItem>> activeEditor = new SimpleObjectProperty((Object)this, "activeEditor", null);
    private final Map<YoGraphicFXItem, YoGraphicFXCreatorController<YoGraphicFXItem>> cachedEditors = new HashMap<YoGraphicFXItem, YoGraphicFXCreatorController<YoGraphicFXItem>>();
    private final ObjectProperty<ContextMenu> activeContexMenu = new SimpleObjectProperty((Object)this, "activeContextMenu", null);
    private YoGroupFX rootGroup;
    private YoGroupFX sessionRootGroup;
    private Stage window;
    private final SetChangeListener<YoGraphicFXItem> treeViewAutoRefreshListener = new SetChangeListener<YoGraphicFXItem>(){

        public void onChanged(SetChangeListener.Change<? extends YoGraphicFXItem> change) {
            if (change.wasAdded()) {
                ((YoGraphicFXItem)change.getElementAdded()).getItemChildren().addListener(YoGraphicPropertyWindowController.this.treeViewAutoRefreshListener);
            } else if (change.wasRemoved()) {
                ((YoGraphicFXItem)change.getElementRemoved()).getItemChildren().removeListener(YoGraphicPropertyWindowController.this.treeViewAutoRefreshListener);
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                YoGraphicPropertyWindowController.this.ignoreTreeSelectionUpdate = true;
                YoGraphicPropertyWindowController.this.refreshTreeView();
                YoGraphicPropertyWindowController.this.ignoreTreeSelectionUpdate = false;
            });
        }
    };
    private boolean ignoreTreeSelectionUpdate = false;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.rootGroup = toolkit.getYoGraphicFXRootGroup();
        this.sessionRootGroup = toolkit.getYoGraphicFXSessionRootGroup();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.initializeTreeViewAutoRefreshListener(this.rootGroup);
        this.yoGraphicTreeView.setCellFactory(param -> new YoGraphicFXItemTreeCell(this.rootGroup));
        this.yoGraphicTreeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.yoGraphicTreeView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.processTreeSelectionUpdate((TreeItem<YoGraphicFXItem>)oldValue, (TreeItem<YoGraphicFXItem>)newValue));
        this.yoGraphicTreeView.setShowRoot(true);
        this.yoGraphicTreeView.setOnDragDetected(this::handleDragDetected);
        this.yoGraphicTreeView.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.DELETE) {
                this.removeItem();
            }
        });
        this.yoGraphicTreeView.setOnContextMenuRequested(e -> {
            if (this.activeContexMenu.get() != null) {
                ((ContextMenu)this.activeContexMenu.get()).hide();
                this.activeContexMenu.set(null);
            }
            FontAwesomeIconView collapseIcon = new FontAwesomeIconView(FontAwesomeIcon.MINUS_SQUARE_ALT);
            FontAwesomeIconView expandIcon = new FontAwesomeIconView(FontAwesomeIcon.PLUS_SQUARE_ALT);
            FontAwesomeIconView addIcon = new FontAwesomeIconView(FontAwesomeIcon.PLUS);
            FontAwesomeIconView deleteIcon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
            FontAwesomeIconView duplicateIcon = new FontAwesomeIconView(FontAwesomeIcon.CLONE);
            addIcon.setFill((Paint)Color.web((String)"#89e0c0"));
            deleteIcon.setFill((Paint)Color.web((String)"#edafb7"));
            duplicateIcon.setFill((Paint)Color.web((String)"#8996e0"));
            MenuItem collapseItem = new MenuItem("Collapse all", (Node)collapseIcon);
            MenuItem expandItem = new MenuItem("Expand all", (Node)expandIcon);
            MenuItem addItem = new MenuItem("Add item...", (Node)addIcon);
            MenuItem removeItem = new MenuItem("Remove item", (Node)deleteIcon);
            MenuItem duplicateItem = new MenuItem("Duplicate item", (Node)duplicateIcon);
            collapseItem.setOnAction(e2 -> this.collapseAll());
            expandItem.setOnAction(e2 -> this.expandAll());
            addItem.setOnAction(e2 -> this.addItem());
            removeItem.setOnAction(e2 -> this.removeItem());
            duplicateItem.setOnAction(e2 -> this.duplicateItem());
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{collapseItem, expandItem, addItem, removeItem, duplicateItem});
            contextMenu.show(this.yoGraphicTreeView, e.getScreenX(), e.getScreenY());
            this.activeContexMenu.set((Object)contextMenu);
        });
        this.refreshTreeView();
        this.saveChangesButton.setDisable(true);
        this.revertChangesButton.setDisable(true);
        this.activeEditor.addListener((observable, oldValue, newValue) -> {
            this.saveChangesButton.disableProperty().unbind();
            this.revertChangesButton.disableProperty().unbind();
            if (newValue == null) {
                this.saveChangesButton.setDisable(true);
                this.revertChangesButton.setDisable(true);
            } else {
                this.saveChangesButton.disableProperty().bind((ObservableValue)newValue.hasChangesPendingProperty().and(newValue.inputsValidityProperty()).not());
                this.revertChangesButton.disableProperty().bind((ObservableValue)newValue.hasChangesPendingProperty().not());
                newValue.saveChanges();
                newValue.resetFields();
            }
        });
        this.yoGraphicEditorPane.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.CONTROL) {
                return;
            }
            if (e.isControlDown()) {
                if (e.getCode() == KeyCode.S && !this.saveChangesButton.isDisabled()) {
                    this.saveChangesButton.fire();
                } else if (e.getCode() == KeyCode.Z && !this.revertChangesButton.isDisabled()) {
                    this.revertChangesButton.fire();
                }
            }
        });
        this.searchTextField.textProperty().addListener((observable, oldValue, newValue) -> this.search((String)newValue));
        this.window = new Stage(StageStyle.UTILITY);
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.setOnHidden(e -> this.stop());
        this.window.setOnShowing(e -> this.start());
        this.window.setTitle("YoGraphic properties");
        this.window.setScene(new Scene((Parent)this.mainAnchorPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void closeAndDispose() {
        this.window.close();
    }

    private void initializeTreeViewAutoRefreshListener(YoGraphicFXItem item) {
        item.getItemChildren().addListener(this.treeViewAutoRefreshListener);
        for (YoGraphicFXItem child : item.getItemChildren()) {
            this.initializeTreeViewAutoRefreshListener(child);
        }
    }

    private void refreshTreeView() {
        this.unloadEditor();
        CheckBoxTreeItem<YoGraphicFXItem> oldRootItem = this.defaultRootItem;
        this.defaultRootItem = new CheckBoxTreeItem((Object)this.rootGroup);
        this.defaultRootItem.setExpanded(true);
        this.defaultRootItem.selectedProperty().bindBidirectional((Property)((YoGraphicFXItem)this.defaultRootItem.getValue()).visibleProperty());
        this.buildTreeRecursively((TreeItem<YoGraphicFXItem>)this.defaultRootItem);
        this.yoGraphicTreeView.setRoot(this.defaultRootItem);
        this.copyExpandedPropertyRecursively((TreeItem<?>)oldRootItem, (TreeItem<?>)this.defaultRootItem);
        this.allGraphicItems = this.rootGroup.collectSubtreeItems();
    }

    private void collapseSubTreeView(TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            item.setExpanded(false);
            for (TreeItem child : item.getChildren()) {
                this.collapseSubTreeView(child);
            }
        }
    }

    private void expandSubTreeView(TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            item.setExpanded(true);
            for (TreeItem child : item.getChildren()) {
                this.expandSubTreeView(child);
            }
        }
    }

    private void copyExpandedPropertyRecursively(TreeItem<?> reference, TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            for (TreeItem child : item.getChildren()) {
                if (reference == null) {
                    this.expandSubTreeView(child);
                    continue;
                }
                TreeItem referenceChild = reference.getChildren().stream().filter(refChild -> refChild.getValue() == child.getValue()).findFirst().orElse(null);
                if (referenceChild == null) {
                    this.expandSubTreeView(child);
                    continue;
                }
                child.setExpanded(referenceChild.isExpanded());
                this.copyExpandedPropertyRecursively(referenceChild, child);
            }
        }
    }

    private void selectItem(TreeItem<YoGraphicFXItem> treeItem, YoGraphicFXItem itemToSelect) {
        if (treeItem == null) {
            return;
        }
        if (treeItem.getValue() == itemToSelect) {
            this.yoGraphicTreeView.getSelectionModel().select(treeItem);
            return;
        }
        for (TreeItem child : treeItem.getChildren()) {
            this.selectItem((TreeItem<YoGraphicFXItem>)child, itemToSelect);
        }
    }

    private void processTreeSelectionUpdate(TreeItem<YoGraphicFXItem> oldSelectedValue, TreeItem<YoGraphicFXItem> newSelectedValue) {
        if (this.ignoreTreeSelectionUpdate) {
            return;
        }
        if (this.shouldCancelAction(oldSelectedValue)) {
            return;
        }
        this.unloadEditor();
        if (newSelectedValue == null) {
            return;
        }
        YoGraphicFXItem item = (YoGraphicFXItem)newSelectedValue.getValue();
        Class<?> itemType = item.getClass();
        YoGraphicFXCreatorController controller = this.cachedEditors.get(item);
        if (controller == null) {
            try {
                if (item instanceof YoGroupFX) {
                    Class<? extends YoGraphicFX> commonItemType = YoGraphicPropertyWindowController.findCommonChildrenType((YoGroupFX)item);
                    if (commonItemType == null) {
                        return;
                    }
                    FXMLLoader loader = SessionVisualizerIOTools.getYoGraphicFXGroupEditorFXMLLoader(commonItemType);
                    loader.load();
                    controller = (YoGraphicFXCreatorController)loader.getController();
                    controller.initialize(this.toolkit, item);
                    this.cachedEditors.put(item, controller);
                } else {
                    FXMLLoader loader = SessionVisualizerIOTools.getYoGraphicFXEditorFXMLLoader(itemType);
                    loader.load();
                    controller = (YoGraphicFXCreatorController)loader.getController();
                    controller.initialize(this.toolkit, item);
                    this.cachedEditors.put(item, controller);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (controller != null) {
            Pane editorPane = controller.getMainPane();
            this.activeEditor.set(controller);
            this.yoGraphicEditorPane.getChildren().add((Object)editorPane);
            AnchorPane.setLeftAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setTopAnchor((Node)editorPane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)editorPane, (Double)0.0);
            this.yoGraphicTypeLabel.setText(itemType.getSimpleName());
        }
    }

    private static Class<? extends YoGraphicFX> findCommonChildrenType(YoGroupFX group) {
        if (!group.getYoGraphicFX2DSet().isEmpty()) {
            if (!group.getYoGraphicFX3DSet().isEmpty()) {
                return null;
            }
            Class<?> commonType = null;
            for (YoGraphicFX2D item : group.getYoGraphicFX2DSet()) {
                if (commonType == null) {
                    commonType = item.getClass();
                    continue;
                }
                if (commonType == item.getClass()) continue;
                return null;
            }
            return commonType;
        }
        if (!group.getYoGraphicFX3DSet().isEmpty()) {
            Class<?> commonType = null;
            for (YoGraphicFX3D item : group.getYoGraphicFX3DSet()) {
                if (commonType == null) {
                    commonType = item.getClass();
                    continue;
                }
                if (commonType == item.getClass()) continue;
                return null;
            }
            return commonType;
        }
        return null;
    }

    private void unloadEditor() {
        this.yoGraphicEditorPane.getChildren().clear();
        this.activeEditor.set(null);
    }

    @FXML
    public void clearSearch() {
        this.searchTextField.clear();
    }

    public void search(String searchQuery) {
        if (this.backgroundSearch != null) {
            this.backgroundSearch.cancel(true);
            this.backgroundSearch = null;
        }
        if (searchQuery != null && !searchQuery.isEmpty()) {
            this.backgroundSearch = this.backgroundExecutorManager.executeInBackground(() -> {
                if (this.allGraphicItems == null) {
                    return null;
                }
                return this.createFilteredRootItem(YoVariableTools.search(this.allGraphicItems, item -> item.getName(), searchQuery, YoVariableTools.fromSearchEnginesEnum(SearchEngines.DEFAULT), Integer.MAX_VALUE, Collectors.toSet()));
            });
        } else {
            this.searchResult = this.defaultRootItem;
            this.expandAll();
        }
    }

    private CheckBoxTreeItem<YoGraphicFXItem> createFilteredRootItem(Set<YoGraphicFXItem> subSelection) {
        CheckBoxTreeItem root = new CheckBoxTreeItem((Object)this.rootGroup);
        this.buildTreeRecursively((TreeItem<YoGraphicFXItem>)root);
        YoGraphicPropertyWindowController.filterItems((TreeItem<YoGraphicFXItem>)root, subSelection);
        TreeViewTools.expandRecursively(root);
        return root;
    }

    private static void filterItems(TreeItem<YoGraphicFXItem> parent, Set<YoGraphicFXItem> itemsToKeep) {
        YoGraphicPropertyWindowController.filterItems(parent, itemsToKeep.contains(parent.getValue()), itemsToKeep);
    }

    private static void filterItems(TreeItem<YoGraphicFXItem> parent, boolean isAncestorInSelection, Set<YoGraphicFXItem> itemsToKeep) {
        if (parent == null || parent.isLeaf()) {
            return;
        }
        for (TreeItem child : parent.getChildren()) {
            if (child.getChildren().isEmpty()) continue;
            YoGraphicPropertyWindowController.filterItems((TreeItem<YoGraphicFXItem>)child, isAncestorInSelection || itemsToKeep.contains(child.getValue()), itemsToKeep);
        }
        for (int i = parent.getChildren().size() - 1; i >= 0; --i) {
            TreeItem child;
            child = (TreeItem)parent.getChildren().get(i);
            if (!child.isLeaf() || child.getValue() == null || isAncestorInSelection || itemsToKeep.contains(child.getValue())) continue;
            parent.getChildren().remove(i);
        }
    }

    @Override
    public void handleImpl(long now) {
        if (this.backgroundSearch != null && this.backgroundSearch.isDone() && !this.backgroundSearch.isCancelled()) {
            try {
                this.searchResult = this.backgroundSearch.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.searchResult != null) {
            this.yoGraphicTreeView.setRoot(this.searchResult);
            this.searchResult = null;
        }
    }

    public void collapseAll() {
        this.collapseSubTreeView(this.yoGraphicTreeView.getRoot());
    }

    public void expandAll() {
        this.expandSubTreeView(this.yoGraphicTreeView.getRoot());
    }

    @FXML
    public void addItem() {
        YoGroupFX group;
        if (this.shouldCancelAction(null)) {
            return;
        }
        TreeItem selectedItem = (TreeItem)this.yoGraphicTreeView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            group = this.rootGroup;
        } else {
            YoGraphicFXItem yoGraphicFXItem = (YoGraphicFXItem)selectedItem.getValue();
            if (yoGraphicFXItem instanceof YoGraphicFX) {
                group = (YoGroupFX)((YoGraphicFX)yoGraphicFXItem).parentGroupProperty().get();
            } else if (yoGraphicFXItem instanceof YoGroupFX) {
                group = (YoGroupFX)yoGraphicFXItem;
            } else {
                throw new RuntimeException("Unexpected item type: " + yoGraphicFXItem.getClass().getSimpleName());
            }
        }
        try {
            if (this.cachedItemCreator.get() == null) {
                FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_ITEM_CREATOR_URL);
                loader.load();
                YoGraphicItemCreatorDialogController controller = (YoGraphicItemCreatorDialogController)loader.getController();
                controller.initialize(this.toolkit);
                this.cachedItemCreator.set((Object)controller);
            }
            YoGraphicItemCreatorDialogController controller = (YoGraphicItemCreatorDialogController)this.cachedItemCreator.get();
            controller.setParent(group);
            controller.showAndWait();
            YoGraphicFXItem newItem = controller.createItem();
            if (newItem != null) {
                JavaFXMissingTools.runLater(((Object)((Object)this)).getClass(), () -> {
                    this.selectItem((TreeItem<YoGraphicFXItem>)this.defaultRootItem, newItem);
                    this.yoGraphicTreeView.requestFocus();
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void removeItem() {
        if (this.shouldCancelAction(null)) {
            return;
        }
        TreeItem selectedItem = (TreeItem)this.yoGraphicTreeView.getSelectionModel().getSelectedItem();
        if (selectedItem == null || ((YoGraphicFXItem)selectedItem.getValue()).parentGroupProperty() == null) {
            return;
        }
        int selectedIndex = this.yoGraphicTreeView.getSelectionModel().getSelectedIndex();
        ObservableList itemsToRemove = this.yoGraphicTreeView.getSelectionModel().getSelectedItems();
        int nextSelectedIndexGuess = selectedIndex - 1;
        TreeItem nextSelectedItemGuess = this.yoGraphicTreeView.getTreeItem(nextSelectedIndexGuess);
        if ((nextSelectedItemGuess == null || itemsToRemove.contains((Object)nextSelectedItemGuess)) && ((nextSelectedItemGuess = this.yoGraphicTreeView.getTreeItem(nextSelectedIndexGuess = selectedIndex + 1)) == null || itemsToRemove.contains((Object)nextSelectedItemGuess))) {
            nextSelectedIndexGuess = selectedIndex - 1;
            nextSelectedItemGuess = this.yoGraphicTreeView.getTreeItem(nextSelectedIndexGuess);
            do {
                if (--nextSelectedIndexGuess >= 0) continue;
                nextSelectedItemGuess = null;
                nextSelectedIndexGuess = 0;
                break;
            } while ((nextSelectedItemGuess = this.yoGraphicTreeView.getTreeItem(nextSelectedIndexGuess)) == null || itemsToRemove.contains((Object)nextSelectedItemGuess));
        }
        YoGraphicFXItem nextSelectedItem = nextSelectedItemGuess == null ? null : (YoGraphicFXItem)nextSelectedItemGuess.getValue();
        for (TreeItem itemToRemove : itemsToRemove) {
            YoGraphicFXItem yoGraphicFXItem = (YoGraphicFXItem)itemToRemove.getValue();
            if (!yoGraphicFXItem.getItemChildren().isEmpty()) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setContentText("Do you really want to delete this group and all its children?");
                alert.initOwner((Window)this.window);
                ButtonType answer = (ButtonType)alert.showAndWait().get();
                if (answer.getButtonData().isCancelButton()) {
                    return;
                }
            }
            yoGraphicFXItem.clear();
            if (yoGraphicFXItem == this.sessionRootGroup) continue;
            yoGraphicFXItem.detachFromParent();
        }
        this.cachedEditors.remove(selectedItem.getValue());
        JavaFXMissingTools.runLater(((Object)((Object)this)).getClass(), () -> {
            this.ignoreTreeSelectionUpdate = true;
            this.yoGraphicTreeView.getSelectionModel().clearSelection();
            this.ignoreTreeSelectionUpdate = false;
            if (nextSelectedItem == null) {
                this.yoGraphicTreeView.getSelectionModel().select(0);
            } else {
                this.selectItem((TreeItem<YoGraphicFXItem>)this.defaultRootItem, nextSelectedItem);
            }
            this.yoGraphicTreeView.requestFocus();
        });
    }

    public void duplicateItem() {
        if (this.shouldCancelAction(null)) {
            return;
        }
        TreeItem selectedItem = (TreeItem)this.yoGraphicTreeView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        YoGraphicFXItem newItem = YoGraphicFXControllerTools.duplicateYoGraphicFXItemAndRegister((YoGraphicFXItem)selectedItem.getValue());
        JavaFXMissingTools.runLater(((Object)((Object)this)).getClass(), () -> {
            this.selectItem((TreeItem<YoGraphicFXItem>)this.defaultRootItem, newItem);
            this.yoGraphicTreeView.requestFocus();
        });
    }

    @FXML
    public void saveChanges() {
        if (this.activeEditor.get() != null) {
            ((YoGraphicFXCreatorController)this.activeEditor.get()).saveChanges();
        }
    }

    @FXML
    public void cancelChanges() {
        if (this.activeEditor.get() != null) {
            ((YoGraphicFXCreatorController)this.activeEditor.get()).resetFields();
        }
    }

    @FXML
    public void exportYoGraphicFXItems() {
        File result = SessionVisualizerIOTools.yoGraphicConfigurationSaveFileDialog((Window)this.window);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoGraphicSaveRequest(), (Object)result);
        }
    }

    @FXML
    public void importYoGraphicFXItems() {
        File result = SessionVisualizerIOTools.yoGraphicConfigurationOpenFileDialog((Window)this.window);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoGraphicLoadRequest(), (Object)result);
        }
    }

    public Stage getWindow() {
        return this.window;
    }

    private boolean shouldCancelAction(TreeItem<YoGraphicFXItem> itemToSelectOnCancel) {
        if (this.activeEditor.get() != null && ((YoGraphicFXCreatorController)this.activeEditor.get()).hasChangesPending()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to discard the changes?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
            SessionVisualizerIOTools.addSCSIconToDialog(alert);
            Optional result = alert.showAndWait();
            ButtonType answer = (ButtonType)result.get();
            if (answer == ButtonType.YES) {
                this.cancelChanges();
                return false;
            }
            if (answer == ButtonType.NO) {
                if (itemToSelectOnCancel != null) {
                    JavaFXMissingTools.runLater(((Object)((Object)this)).getClass(), () -> {
                        this.ignoreTreeSelectionUpdate = true;
                        this.yoGraphicTreeView.getSelectionModel().clearSelection();
                        this.yoGraphicTreeView.getSelectionModel().select((Object)itemToSelectOnCancel);
                        this.ignoreTreeSelectionUpdate = false;
                    });
                }
                return true;
            }
        }
        return false;
    }

    private void buildTreeRecursively(TreeItem<YoGraphicFXItem> parent) {
        for (YoGraphicFXItem child : ((YoGraphicFXItem)parent.getValue()).getItemChildren()) {
            CheckBoxTreeItem childItem = new CheckBoxTreeItem((Object)child);
            childItem.setIndependent(true);
            childItem.selectedProperty().bindBidirectional((Property)((YoGraphicFXItem)childItem.getValue()).visibleProperty());
            parent.getChildren().add((Object)childItem);
            this.buildTreeRecursively((TreeItem<YoGraphicFXItem>)childItem);
        }
    }

    public void handleDragDetected(MouseEvent event) {
        List items = this.yoGraphicTreeView.getSelectionModel().getSelectedItems().stream().map(TreeItem::getValue).collect(Collectors.toList());
        Dragboard dragBoard = this.yoGraphicTreeView.startDragAndDrop(TransferMode.ANY);
        dragBoard.setContent((Map)DragAndDropTools.toClipboardContent(items));
        event.consume();
    }
}

