/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import javax.xml.bind.JAXBException;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple2D;
import us.ihmc.yoVariables.variable.YoDouble;

public interface SessionVisualizerControls {
    public void setCameraOrientation(double var1, double var3);

    default public void setCameraPosition(Point3DReadOnly position) {
        this.setCameraPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setCameraPosition(double var1, double var3, double var5);

    default public void setCameraFocusPosition(Point3DReadOnly position) {
        this.setCameraFocusPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setCameraFocusPosition(double var1, double var3, double var5);

    public void setCameraZoom(double var1);

    public void requestCameraRigidBodyTracking(String var1, String var2);

    public void showOverheadPlotter2D(boolean var1);

    default public void requestPlotter2DCoordinateTracking(YoFrameTuple2D position) {
        this.requestPlotter2DCoordinateTracking((YoTuple2D)position, position.getReferenceFrame().getNameId());
    }

    default public void requestPlotter2DCoordinateTracking(YoTuple2D position, String frameName) {
        this.requestPlotter2DCoordinateTracking(position.getYoX(), position.getYoY(), frameName);
    }

    default public void requestPlotter2DCoordinateTracking(YoDouble xVariable, YoDouble yVariable, String frameName) {
        this.requestPlotter2DCoordinateTracking(xVariable.getFullNameString(), yVariable.getFullNameString(), frameName);
    }

    public void requestPlotter2DCoordinateTracking(String var1, String var2, String var3);

    public void addStaticVisual(VisualDefinition var1);

    default public void addStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.addStaticVisual(visualDefinition);
        }
    }

    public void removeStaticVisual(VisualDefinition var1);

    default public void removeStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.removeStaticVisual(visualDefinition);
        }
    }

    public void addYoGraphic(YoGraphicDefinition var1);

    default public void addYoGraphics(Collection<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphic(yoGraphicDefinition);
        }
    }

    default public void addYoGraphic(String namespace, YoGraphicDefinition yoGraphicDefinition) {
        String[] subNames = namespace.split(":");
        if (subNames == null || subNames.length == 0) {
            this.addYoGraphic(yoGraphicDefinition);
        } else {
            for (int i = subNames.length - 1; i >= 0; --i) {
                yoGraphicDefinition = new YoGraphicGroupDefinition(subNames[i], new YoGraphicDefinition[]{yoGraphicDefinition});
            }
            this.addYoGraphic(yoGraphicDefinition);
        }
    }

    default public void addYoGraphic(String namespace, Collection<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        String[] subNames = namespace.split(":");
        if (subNames == null || subNames.length == 0) {
            this.addYoGraphics(yoGraphicDefinitions);
        } else {
            YoGraphicGroupDefinition group = new YoGraphicGroupDefinition(subNames[subNames.length - 1], yoGraphicDefinitions);
            for (int i = subNames.length - 2; i >= 0; --i) {
                group = new YoGraphicGroupDefinition(subNames[i], new YoGraphicDefinition[]{group});
            }
            this.addYoGraphic((YoGraphicDefinition)group);
        }
    }

    default public void addYoEntry(String variableName) {
        this.addYoEntry(Collections.singletonList(variableName));
    }

    default public void addYoEntry(Collection<String> variableNames) {
        this.addYoEntry(null, variableNames);
    }

    default public void addYoEntry(String groupName, String variableName) {
        this.addYoEntry(groupName, Collections.singletonList(variableName));
    }

    public void addYoEntry(String var1, Collection<String> var2);

    default public void loadSliderboards(InputStream inputStream) {
        try {
            this.setSliderboards(XMLTools.loadYoSliderboardListDefinition(inputStream));
        }
        catch (IOException | JAXBException e) {
            LogTools.error((String)"Failed to load sliderboard configuration: {}, {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    public void setSliderboards(YoSliderboardListDefinition var1);

    public void clearAllSliderboards();

    default public void setDefaultSliderboard(YoSliderboardDefinition sliderboardDefinition) {
        sliderboardDefinition.setName("Default");
        this.setSliderboard(sliderboardDefinition);
    }

    default public void clearDefaultSliderboard() {
        this.removeSliderboard("Default");
    }

    public void setSliderboard(YoSliderboardDefinition var1);

    public void removeSliderboard(String var1);

    default public void setDefaultSliderboardButton(int buttonIndex, String variableName) {
        this.setSliderboardButton("Default", new YoButtonDefinition(variableName, buttonIndex));
    }

    default public void setDefaultSliderboardButton(YoButtonDefinition buttonDefinition) {
        this.setSliderboardButton("Default", buttonDefinition);
    }

    default public void setSliderboardButton(String sliderboardName, int buttonIndex, String variableName) {
        this.setSliderboardButton(sliderboardName, new YoButtonDefinition(variableName, buttonIndex));
    }

    public void setSliderboardButton(String var1, YoButtonDefinition var2);

    default public void clearDefaultSliderboardButton(int buttonIndex) {
        this.clearSliderboardButton("Default", buttonIndex);
    }

    public void clearSliderboardButton(String var1, int var2);

    default public void setDefaultSliderboardKnob(int knobIndex, String variableName) {
        this.setSliderboardKnob("Default", new YoKnobDefinition(variableName, knobIndex));
    }

    default public void setDefaultSliderboardKnob(YoKnobDefinition knobDefinition) {
        this.setSliderboardKnob("Default", knobDefinition);
    }

    default public void setSliderboardKnob(String sliderboardName, int knobIndex, String variableName) {
        this.setSliderboardKnob(sliderboardName, new YoKnobDefinition(variableName, knobIndex));
    }

    public void setSliderboardKnob(String var1, YoKnobDefinition var2);

    default public void clearDefaultSliderboardKnob(int knobIndex) {
        this.clearSliderboardKnob("Default", knobIndex);
    }

    public void clearSliderboardKnob(String var1, int var2);

    default public void setDefaultSliderboardSlider(int sliderIndex, String variableName) {
        this.setSliderboardSlider("Default", new YoSliderDefinition(variableName, sliderIndex));
    }

    default public void setDefaultSliderboardSlider(YoSliderDefinition sliderDefinition) {
        this.setSliderboardSlider("Default", sliderDefinition);
    }

    default public void setSliderboardSlider(String sliderboardName, int sliderIndex, String variableName) {
        this.setSliderboardSlider(sliderboardName, new YoSliderDefinition(variableName, sliderIndex));
    }

    public void setSliderboardSlider(String var1, YoSliderDefinition var2);

    default public void clearDefaultSliderboardSlider(int sliderIndex) {
        this.clearSliderboardSlider("Default", sliderIndex);
    }

    public void clearSliderboardSlider(String var1, int var2);

    default public void exportVideo(File file) {
        SceneVideoRecordingRequest request = new SceneVideoRecordingRequest();
        request.setFile(file);
        this.exportVideo(request);
    }

    public void exportVideo(SceneVideoRecordingRequest var1);

    public void disableGUIControls();

    public void enableGUIControls();

    public Window getPrimaryGUIWindow();

    public void addCustomGUIControl(Node var1);

    public boolean removeCustomGUIControl(Node var1);

    public void loadCustomGUIPane(String var1, URL var2);

    public void addCustomGUIPane(String var1, Pane var2);

    public boolean removeCustomGUIPane(String var1);

    public YoDoubleProperty newYoDoubleProperty(String var1);

    public YoIntegerProperty newYoIntegerProperty(String var1);

    public YoLongProperty newYoLongProperty(String var1);

    public YoBooleanProperty newYoBooleanProperty(String var1);

    public <E extends Enum<E>> YoEnumAsStringProperty<E> newYoEnumProperty(String var1);

    public void addSessionChangedListener(SessionChangeListener var1);

    public boolean removeSessionChangedListener(SessionChangeListener var1);

    public void requestVisualizerShutdown();

    public void shutdownSession();

    public boolean isVisualizerShutdown();

    public void addVisualizerShutdownListener(Runnable var1);

    public void waitUntilVisualizerFullyUp();

    public void waitUntilVisualizerDown();
}

