/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;

public class YoLineFX2D
extends YoGraphicFX2D {
    private Tuple2DProperty origin = new Tuple2DProperty(null, 0.0, 0.0);
    private Tuple2DProperty direction = new Tuple2DProperty(null, 0.0, 1.0);
    private Tuple2DProperty destination = null;
    private final Line lineNode = new Line();

    public YoLineFX2D() {
        this.lineNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.lineNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoLineFX2D(ReferenceFrame worldFrame) {
        this();
        this.origin.setReferenceFrame(worldFrame);
        this.direction.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        if (this.fillColor == null) {
            this.fillColor = () -> null;
        }
        if (this.strokeColor == null) {
            this.strokeColor = () -> null;
        }
        if (this.strokeWidth == null) {
            this.strokeWidth = DEFAULT_STROKE_WIDTH;
        }
        this.lineNode.setFill((Paint)this.fillColor.get());
        this.lineNode.setStroke((Paint)this.strokeColor.get());
        double scale = this.lineNode.getLocalToSceneTransform().deltaTransform(1.0, 0.0).getX();
        this.lineNode.setStrokeWidth(this.strokeWidth.get() / scale);
        if (this.origin == null || this.direction == null && this.destination == null) {
            this.handleNaN();
            return;
        }
        if (this.origin.containsNaN()) {
            this.handleNaN();
            return;
        }
        Point2D originInWorld = this.origin.toPoint2DInWorld();
        this.lineNode.setStartX(originInWorld.getX());
        this.lineNode.setStartY(originInWorld.getY());
        if (this.direction != null) {
            if (this.direction.containsNaN()) {
                this.handleNaN();
                return;
            }
            Vector2D directionInWorld = this.direction.toVector2DInWorld();
            this.lineNode.setEndX(originInWorld.getX() + directionInWorld.getX());
            this.lineNode.setEndY(originInWorld.getY() + directionInWorld.getY());
        } else {
            if (this.destination.containsNaN()) {
                this.handleNaN();
                return;
            }
            Point2D destinationInWorld = this.destination.toPoint2DInWorld();
            this.lineNode.setEndX(destinationInWorld.getX());
            this.lineNode.setEndY(destinationInWorld.getY());
        }
    }

    private void handleNaN() {
        this.lineNode.setStartX(Double.NEGATIVE_INFINITY);
        this.lineNode.setStartY(Double.NEGATIVE_INFINITY);
        this.lineNode.setEndX(Double.NEGATIVE_INFINITY);
        this.lineNode.setEndY(Double.NEGATIVE_INFINITY);
    }

    public void setOrigin(Tuple2DProperty origin) {
        this.origin = origin;
    }

    public void setDirection(Tuple2DProperty direction) {
        this.direction = direction;
    }

    public void setDestination(Tuple2DProperty destination) {
        this.destination = destination;
    }

    @Override
    public void clear() {
        this.origin = null;
        this.direction = null;
        this.destination = null;
        this.fillColor = null;
        this.strokeColor = null;
        this.strokeWidth = null;
    }

    @Override
    public YoGraphicFX clone() {
        YoLineFX2D clone = new YoLineFX2D();
        clone.setName(this.getName());
        clone.setOrigin(new Tuple2DProperty(this.origin));
        clone.setDirection(this.direction != null ? new Tuple2DProperty(this.direction) : null);
        clone.setDestination(this.destination != null ? new Tuple2DProperty(this.destination) : null);
        clone.setFillColor(this.fillColor);
        clone.setStrokeColor(this.strokeColor);
        clone.setStrokeWidth(this.strokeWidth);
        return clone;
    }

    public Tuple2DProperty getOrigin() {
        return this.origin;
    }

    public Tuple2DProperty getDirection() {
        return this.direction;
    }

    public Tuple2DProperty getDestination() {
        return this.destination;
    }

    @Override
    public Node getNode() {
        return this.lineNode;
    }
}

