/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Pair;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupLayout;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.TableSizeQuickAccess;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.ChartTable2D;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartGroupTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.StringTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoChartGroupPanelController
implements VisualizerController {
    private SessionVisualizerWindowToolkit toolkit;
    private YoCompositeSearchManager yoCompositeSearchManager;
    private final StringProperty chartGroupName = new SimpleStringProperty((Object)this, "chartGroupName", null);
    private final StringProperty userDefinedChartGroupName = new SimpleStringProperty((Object)this, "userDefinedChartGroupName", null);
    private final StringProperty automatedChartGroupName = new SimpleStringProperty((Object)this, "automatedChartGroupName", null);
    private final GridPane gridPane = new GridPane();
    private final BooleanProperty isRunning = new SimpleBooleanProperty((Object)this, "isRunning", false);
    private final ChartTable2D chartTable2D = new ChartTable2D(() -> this.createNewChartPanel(this.isRunning.get()));
    @FXML
    private AnchorPane mainPane;
    @FXML
    private JFXButton dropDownMenuButton;
    private TopicListener<Pair<Window, File>> loadChartGroupConfigurationListener = m -> this.loadChartGroupConfiguration((Window)m.getKey(), (File)m.getValue());
    private TopicListener<Pair<Window, File>> saveChartGroupConfigurationListener = m -> this.saveChartGroupConfiguration((Window)m.getKey(), (File)m.getValue());
    private TopicListener<Pair<Window, String>> userDefinedChartGroupNameListener = m -> {
        if (m.getKey() == this.toolkit.getWindow()) {
            this.setUserDefinedChartGroupName((String)m.getValue());
        }
    };
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private boolean isMessagerSetup = false;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.mainPane.getChildren().add(0, (Object)this.gridPane);
        AnchorPane.setTopAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.gridPane, (Double)0.0);
        this.gridPane.getStyleClass().add((Object)"chart-group-grid-pane");
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.messager.submitMessage(this.topics.getRegisterRecordable(), (Object)this.mainPane);
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), m -> this.mainPane.setDisable(m.booleanValue()));
        toolkit.getWindow().iconifiedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue() != this.isRunning.get()) {
                return;
            }
            if (newValue.booleanValue()) {
                this.stop();
            } else {
                this.start();
            }
        });
        this.chartGroupName.bind((ObservableValue)this.automatedChartGroupName);
        this.userDefinedChartGroupName.addListener((ChangeListener)new ChangeListener<String>(){
            private Observable currentBind;
            {
                this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
            }

            public void changed(ObservableValue<? extends String> o, String oldValue, String newValue) {
                if (newValue != null) {
                    if (this.currentBind != YoChartGroupPanelController.this.userDefinedChartGroupName) {
                        this.currentBind = YoChartGroupPanelController.this.userDefinedChartGroupName;
                        YoChartGroupPanelController.this.chartGroupName.unbind();
                        YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.userDefinedChartGroupName);
                    }
                } else if (newValue == null && this.currentBind != YoChartGroupPanelController.this.automatedChartGroupName) {
                    this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
                    YoChartGroupPanelController.this.chartGroupName.unbind();
                    YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.automatedChartGroupName);
                }
            }
        });
        ObservableSet allVariableNames = FXCollections.observableSet(new HashSet());
        allVariableNames.addListener(change -> {
            if (change.getSet().isEmpty()) {
                this.automatedChartGroupName.set(null);
                this.userDefinedChartGroupName.set(null);
            } else {
                this.automatedChartGroupName.set((Object)StringTools.commonSubString((Collection<? extends String>)change.getSet()));
            }
        });
        final SetChangeListener plottedVariableChangeListener = change -> {
            if (change.wasAdded()) {
                allVariableNames.add((Object)((YoVariable)change.getElementAdded()).getName());
            }
            if (change.wasRemoved()) {
                allVariableNames.remove((Object)((YoVariable)change.getElementRemoved()).getName());
            }
        };
        this.chartTable2D.addListener(new ChartTable2D.ChartChangeListener(){

            @Override
            public void onChange(ChartTable2D.ChartChange c) {
                YoChartPanelController chart = c.getChart();
                switch (c.type()) {
                    case ADD: {
                        YoChartGroupPanelController.this.gridPane.add((Node)chart.getMainPane(), c.toCol(), c.toRow());
                        chart.getPlottedVariables().addListener(plottedVariableChangeListener);
                        break;
                    }
                    case REMOVE: {
                        YoChartGroupPanelController.this.gridPane.getChildren().remove((Object)chart.getMainPane());
                        chart.getPlottedVariables().removeListener(plottedVariableChangeListener);
                        break;
                    }
                    case MOVE: {
                        GridPane.setConstraints((Node)chart.getMainPane(), (int)c.toCol(), (int)c.toRow());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected change type: " + c.type());
                    }
                }
            }
        });
    }

    public void setChartGroupConfiguration(YoChartGroupConfigurationDefinition definition) {
        if (!this.chartTable2D.set(definition)) {
            return;
        }
        this.userDefinedChartGroupName.set((Object)definition.getName());
    }

    public void setupMessager() {
        if (this.isMessagerSetup) {
            return;
        }
        this.isMessagerSetup = true;
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoChartGroupLoadConfiguration(), this.loadChartGroupConfigurationListener);
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoChartGroupSaveConfiguration(), this.saveChartGroupConfigurationListener);
        this.messager.registerTopicListener(this.topics.getYoChartGroupName(), this.userDefinedChartGroupNameListener);
    }

    public void scheduleMessagerCleanup() {
        this.toolkit.getBackgroundExecutorManager().executeInBackground(() -> {
            if (!this.isMessagerSetup) {
                return;
            }
            this.isMessagerSetup = false;
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoChartGroupLoadConfiguration(), this.loadChartGroupConfigurationListener);
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoChartGroupSaveConfiguration(), this.saveChartGroupConfigurationListener);
            this.messager.removeTopicListener(this.topics.getYoChartGroupName(), this.userDefinedChartGroupNameListener);
        });
    }

    private void handleCloseChart(ActionEvent event, YoChartPanelController chartToClose) {
        this.chartTable2D.removeChart(this.getChartIdentifier(chartToClose));
        this.chartTable2D.removeNullRowsAndColumns();
        event.consume();
    }

    public YoChartPanelController getChartController(ChartIdentifier chartIdentifier) {
        return this.chartTable2D.get(chartIdentifier.getRow(), chartIdentifier.getColumn());
    }

    public ChartIdentifier getChartIdentifier(YoChartPanelController controller) {
        return new ChartIdentifier(GridPane.getRowIndex((Node)controller.getMainPane()), GridPane.getColumnIndex((Node)controller.getMainPane()));
    }

    private YoChartPanelController createNewChartPanel(boolean start) {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_PANEL_FXML_URL);
            AnchorPane graphNode = (AnchorPane)loader.load();
            YoChartPanelController controller = (YoChartPanelController)loader.getController();
            controller.initialize(this.toolkit);
            DynamicLineChart chartNode = controller.getLineChart();
            chartNode.setOnDragOver(e -> this.handleDragOver((DragEvent)e, controller));
            chartNode.setOnDragDropped(e -> this.handleDragDropped((DragEvent)e, controller));
            chartNode.setOnDragEntered(e -> this.handleDragEntered((DragEvent)e, controller));
            chartNode.setOnDragExited(e -> this.handleDragExited((DragEvent)e, controller));
            controller.getCloseButton().setOnAction(e -> this.handleCloseChart((ActionEvent)e, controller));
            controller.getChartMoveIcon().setOnDragDetected(e -> this.startChartMove((MouseEvent)e, controller));
            controller.getChartMoveIcon().setOnDragDone(e -> this.finishChartMove((DragEvent)e, controller));
            YoChartGroupPanelController.setGrowProperty((Node)graphNode);
            if (start) {
                controller.start();
            }
            return controller;
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not create new line chart panel:", e2);
        }
    }

    private static void setGrowProperty(Node graphNode) {
        GridPane.setHgrow((Node)graphNode, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)graphNode, (Priority)Priority.ALWAYS);
    }

    public void start() {
        this.isRunning.set(true);
        this.setupMessager();
        this.chartTable2D.forEachChart(AnimationTimer::start);
    }

    public void stop() {
        this.isRunning.set(false);
        this.chartTable2D.forEachChart(AnimationTimer::stop);
    }

    public void closeAndDispose() {
        this.isRunning.set(false);
        this.chartTable2D.clear();
        this.scheduleMessagerCleanup();
    }

    @FXML
    void openMenu(ActionEvent event) {
        Popup popup = new Popup();
        popup.autoHideProperty().set(true);
        TableSizeQuickAccess tableSizeQuickAccess = new TableSizeQuickAccess("Select graph table size:", this.chartTable2D.getSize(), this.chartTable2D.getMaxSize());
        AnchorPane rootNode = tableSizeQuickAccess.getMainPane();
        Pane backgroundPane = new Pane();
        backgroundPane.setStyle("-fx-background-radius:10;-fx-background-color:rgba(79,132,186,0.5);");
        backgroundPane.setEffect((Effect)new GaussianBlur(10.0));
        rootNode.getChildren().add(0, (Object)backgroundPane);
        AnchorPane.setTopAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setBottomAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setLeftAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setRightAnchor((Node)backgroundPane, (Double)-5.0);
        rootNode.setOnMouseClicked(e -> {
            this.chartTable2D.resize(new ChartTable2D.ChartTable2DSize(tableSizeQuickAccess.selectedRowsProperty().get(), tableSizeQuickAccess.selectedColumnsProperty().get()));
            popup.hide();
        });
        tableSizeQuickAccess.getClearAllButton().setOnMouseClicked(e -> {
            this.chartTable2D.clear();
            popup.hide();
        });
        tableSizeQuickAccess.getClearEmptyButton().setOnMouseClicked(e -> {
            this.chartTable2D.removeEmptyCharts();
            this.chartTable2D.removeNullRowsAndColumns();
            popup.hide();
        });
        popup.getContent().add((Object)rootNode);
        this.dropDownMenuButton.setDisable(true);
        popup.setOnHiding(e -> this.dropDownMenuButton.setDisable(false));
        Bounds boundsInLocal = this.dropDownMenuButton.getBoundsInLocal();
        Point2D anchorPosition = this.dropDownMenuButton.localToScreen(boundsInLocal.getMinX(), boundsInLocal.getMaxY());
        popup.show((Node)this.dropDownMenuButton, anchorPosition.getX(), anchorPosition.getY());
        event.consume();
    }

    public Property<ChartTable2D.ChartTable2DSize> maxSizeProperty() {
        return this.chartTable2D.maxSizeProperty();
    }

    public void setUserDefinedChartGroupName(String name) {
        this.userDefinedChartGroupName.set((Object)name);
    }

    public ReadOnlyStringProperty chartGroupNameProperty() {
        return this.chartGroupName;
    }

    private void handleDragEntered(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            if (event.getTransferMode() == TransferMode.MOVE) {
                controller.setSelectionHighlight(true);
            } else {
                List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
                List<ChartGroupLayout> configurations = ChartGroupTools.toChartGroupLayouts(yoComposites);
                configurations = this.shiftConfigurationsToSelectedChart(controller, configurations);
                List<YoChartPanelController> controllers = this.controllersInConfigurations(configurations);
                controllers.forEach(c -> c.setSelectionHighlight(true));
            }
        }
        event.consume();
    }

    private void handleDragExited(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
        }
        event.consume();
    }

    private void handleDragOver(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            if (controller.isEmpty()) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event, YoChartPanelController controller) {
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
        if (yoComposites != null) {
            if (event.getTransferMode() == TransferMode.MOVE) {
                yoComposites.forEach(yoComposite -> yoComposite.getYoComponents().forEach(controller::addYoVariableToPlot));
            } else {
                List<ChartGroupLayout> layouts = ChartGroupTools.toChartGroupLayouts(yoComposites);
                if ((layouts = this.shiftConfigurationsToSelectedChart(controller, layouts)).size() > 1) {
                    ContextMenu contextMenu = new ContextMenu();
                    for (ChartGroupLayout layout : layouts) {
                        Label label = new Label(layout.getName());
                        CustomMenuItem menuItem = new CustomMenuItem((Node)label);
                        label.setOnMouseEntered(e -> {
                            this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
                            this.controllersInConfiguration(layout).forEach(c -> c.setSelectionHighlight(true));
                        });
                        menuItem.setOnAction(e -> this.applyLayout(layout));
                        contextMenu.getItems().add((Object)menuItem);
                    }
                    contextMenu.show((Node)this.mainPane, event.getScreenX(), event.getScreenY());
                } else if (layouts.size() == 1) {
                    this.applyLayout(layouts.get(0));
                } else {
                    yoComposites.forEach(yoComposite -> yoComposite.getYoComponents().forEach(controller::addYoVariableToPlot));
                }
            }
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void startChartMove(MouseEvent event, YoChartPanelController controller) {
        if (!event.isPrimaryButtonDown()) {
            return;
        }
        ArrayList<YoVariable> yoVariables = new ArrayList<YoVariable>((Collection<YoVariable>)controller.getPlottedVariables());
        FontAwesomeIconView chartMoveIcon = controller.getChartMoveIcon();
        Dragboard dragBoard = chartMoveIcon.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        SnapshotParameters params = new SnapshotParameters();
        params.setTransform((Transform)new Scale(0.5, 0.5));
        dragBoard.setDragView((Image)controller.getMainPane().snapshot(params, null));
        ClipboardContent clipboardContent = new ClipboardContent();
        if (yoVariables.size() == 1) {
            YoVariable yoVariable = (YoVariable)yoVariables.get(0);
            if (yoVariable == null) {
                return;
            }
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(YoCompositeTools.YO_VARIABLE, yoVariable.getFullNameString()));
        } else {
            ArrayList<String> content = new ArrayList<String>();
            for (YoVariable yoVariable : yoVariables) {
                content.add(YoCompositeTools.YO_VARIABLE);
                content.add(yoVariable.getFullNameString());
            }
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_LIST_REFERENCE, content);
        }
        dragBoard.setContent((Map)clipboardContent);
        event.consume();
    }

    private void finishChartMove(DragEvent event, YoChartPanelController controller) {
        if (!event.isAccepted()) {
            return;
        }
        if (event.getTransferMode() != TransferMode.MOVE) {
            return;
        }
        controller.clear();
    }

    private void applyLayout(ChartGroupLayout layout) {
        this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
        for (ChartIdentifier chartIdentifier : layout.getChartIdentifiers()) {
            List<YoVariable> yoVariables = layout.getYoVariables(chartIdentifier);
            YoChartPanelController chartController = this.getChartController(chartIdentifier);
            chartController.addYoVariablesToPlot(yoVariables);
        }
    }

    private List<YoChartPanelController> controllersInConfiguration(ChartGroupModel configuration) {
        if (!this.doesConfigurationFit(configuration)) {
            return null;
        }
        return configuration.getChartIdentifiers().stream().map(this::getChartController).collect(Collectors.toList());
    }

    public List<YoChartPanelController> controllersInConfigurations(List<? extends ChartGroupModel> configurations) {
        return configurations.stream().flatMap(config -> config.getChartIdentifiers().stream()).distinct().map(this::getChartController).collect(Collectors.toList());
    }

    private List<ChartGroupLayout> shiftConfigurationsToSelectedChart(YoChartPanelController selectedChart, List<ChartGroupLayout> layouts) {
        ChartIdentifier selectedId = this.getChartIdentifier(selectedChart);
        return layouts.stream().map(config -> config.shift(selectedId.getRow(), selectedId.getColumn())).filter(this::doesConfigurationFit).collect(Collectors.toList());
    }

    private boolean acceptDragEventForDrop(DragEvent event, YoChartPanelController controller) {
        if (event.getGestureSource() == this.mainPane || event.getGestureSource() == controller.getChartMoveIcon()) {
            return false;
        }
        if (event.getTransferMode() == TransferMode.MOVE && !controller.isEmpty()) {
            return false;
        }
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager) != null;
    }

    private boolean doesConfigurationFit(ChartGroupModel configuration) {
        return this.chartTable2D.getSize().contains(configuration.rowEnd(), configuration.columnEnd());
    }

    public void loadChartGroupConfiguration(Window source, File file) {
        if (source != this.toolkit.getWindow()) {
            return;
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{YoChartGroupConfigurationDefinition.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.setChartGroupConfiguration((YoChartGroupConfigurationDefinition)unmarshaller.unmarshal(file));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void saveChartGroupConfiguration(Window source, File file) {
        if (source != null && source != this.toolkit.getWindow()) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Saving file: " + file));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{YoChartGroupConfigurationDefinition.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.toYoChartGroupConfigurationDefinition(), file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public YoChartGroupConfigurationDefinition toYoChartGroupConfigurationDefinition() {
        YoChartGroupConfigurationDefinition definition = new YoChartGroupConfigurationDefinition();
        definition.setName((String)this.chartGroupName.get());
        definition.setNumberOfRows(this.chartTable2D.getSize().getNumberOfRows());
        definition.setNumberOfColumns(this.chartTable2D.getSize().getNumberOfCols());
        definition.setChartConfigurations(this.chartTable2D.toChartDefinitions());
        return definition;
    }
}

