/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicListDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class YoGraphicFXManager
extends ObservedAnimationTimer
implements Manager {
    private static final String SESSION_GRAPHICS = "SessionGraphics";
    private final YoGroupFX root = YoGroupFX.createGUIRoot();
    private final YoGroupFX sessionRoot = new YoGroupFX("SessionGraphics");
    private final YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private final ReferenceFrameManager referenceFrameManager;
    private Future<?> backgroundTask = null;
    private final YoGraphicFXResourceManager yoGraphicFXResourceManager = new YoGraphicFXResourceManager();

    public YoGraphicFXManager(JavaFXMessager messager, SessionVisualizerTopics topics, YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager, ReferenceFrameManager referenceFrameManager) {
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.referenceFrameManager = referenceFrameManager;
        messager.registerJavaFXSyncedTopicListener(topics.getYoGraphicLoadRequest(), this::loadYoGraphicFromFile);
        messager.registerJavaFXSyncedTopicListener(topics.getYoGraphicSaveRequest(), this::saveYoGraphicToFile);
        messager.registerTopicListener(topics.getAddYoGraphicRequest(), this::setupYoGraphicDefinition);
    }

    private void computeBackground() {
        try {
            this.root.computeBackground();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleImpl(long now) {
        try {
            this.root.render();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startSession(Session session) {
        if (!session.getYoGraphicDefinitions().isEmpty()) {
            this.setupYoGraphics(new YoGraphicListDefinition((Collection)session.getYoGraphicDefinitions()), this.sessionRoot, () -> this.root.addChild(this.sessionRoot));
        }
        this.start();
        this.backgroundTask = this.backgroundExecutorManager.scheduleTaskInBackground(this::computeBackground, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stopSession() {
        this.root.clear();
        this.sessionRoot.clear();
        this.stop();
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel(false);
            this.backgroundTask = null;
        }
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    private void loadYoGraphicFromFile(File file) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.loadYoGraphicFromFileNow(file));
    }

    private void loadYoGraphicFromFileNow(File file) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Load must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            YoGraphicListDefinition yoGraphicListDefinition = XMLTools.loadYoGraphicListDefinition(new FileInputStream(file));
            this.setupYoGraphics(yoGraphicListDefinition, this.root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupYoGraphics(YoGraphicListDefinition definition, YoGroupFX parentGroup) {
        this.setupYoGraphics(definition, parentGroup, null);
    }

    private void setupYoGraphics(YoGraphicListDefinition definition, YoGroupFX parentGroup, Runnable postLoadingCallback) {
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> {
            List<YoGraphicFXItem> items = YoGraphicTools.createYoGraphicFXs(this.yoManager.getRootRegistryDatabase(), parentGroup, this.yoGraphicFXResourceManager, this.referenceFrameManager, definition);
            if (items != null && !items.isEmpty()) {
                JavaFXMissingTools.runLater(this.getClass(), () -> {
                    items.forEach(parentGroup::addYoGraphicFXItem);
                    if (postLoadingCallback != null) {
                        postLoadingCallback.run();
                    }
                });
            }
        });
    }

    private void setupYoGraphicDefinition(YoGraphicDefinition definition) {
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> {
            YoGraphicFXItem item = YoGraphicTools.createYoGraphicFX(this.yoManager.getRootRegistryDatabase(), this.root, this.yoGraphicFXResourceManager, this.referenceFrameManager, definition);
            if (item != null) {
                JavaFXMissingTools.runLater(this.getClass(), () -> this.root.addYoGraphicFXItem(item));
            }
        });
    }

    public void saveYoGraphicToFile(File file) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Saving file: " + file));
        try {
            YoGraphicListDefinition yoGraphicListDefinition = YoGraphicTools.toYoGraphicListDefinition(this.root.getItemChildren().stream().filter(item -> item != this.sessionRoot).collect(Collectors.toList()));
            XMLTools.saveYoGraphicListDefinition(new FileOutputStream(file), yoGraphicListDefinition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public YoGroupFX getRootGroup() {
        return this.root;
    }

    public YoGroupFX getSessionRootGroup() {
        return this.sessionRoot;
    }

    public Node getRootNode2D() {
        return this.root.getNode2D();
    }

    public Node getRootNode3D() {
        return this.root.getNode3D();
    }

    public YoGraphicFXResourceManager getYoGraphicFXResourceManager() {
        return this.yoGraphicFXResourceManager;
    }
}

