/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.StringPropertyBase;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEnumAsStringProperty<E extends Enum<E>>
extends StringPropertyBase
implements YoVariableProperty<YoEnum<E>, String> {
    private final YoEnum<E> yoEnum;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoEnumPropertyUpdater(this);
    private final List<String> enumConstants;
    private LinkedYoEnum<E> linkedBuffer;

    public YoEnumAsStringProperty(YoEnum<E> yoEnum) {
        this(yoEnum, null);
    }

    public YoEnumAsStringProperty(YoEnum<E> yoEnum, Object bean) {
        this.yoEnum = yoEnum;
        this.bean = bean;
        this.enumConstants = Arrays.asList(yoEnum.getEnumValuesAsString());
        this.pullYoEnumValue();
        yoEnum.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoEnum<E> linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
        this.linkedBuffer = linkedBuffer;
        if (linkedBuffer != null) {
            linkedBuffer.addUser((Object)this);
            this.pullYoEnumValue();
        }
    }

    @Override
    public LinkedYoEnum<E> getLinkedBuffer() {
        return this.linkedBuffer;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.yoEnum.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
    }

    public void set(String newValue) {
        super.set(newValue);
        this.yoEnum.set(this.toEnumOrdinal(newValue));
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoEnumValue() {
        super.set(this.toEnumString(this.yoEnum.getOrdinal()));
    }

    public void bindStringProperty(Property<String> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue(newValue);
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.set((String)newValue);
            updatingThis.setFalse();
        });
    }

    public int toEnumOrdinal(String newValue) {
        if (newValue == null || newValue.equals("null")) {
            return -1;
        }
        int indexOf = this.enumConstants.indexOf(newValue);
        if (indexOf == -1) {
            throw new IllegalArgumentException("The value " + newValue + " is not part of the constants of the YoEnum: " + this.yoEnum.getName());
        }
        return indexOf;
    }

    public String toEnumString(int ordinal) {
        if (ordinal == -1) {
            return null;
        }
        return this.enumConstants.get(this.yoEnum.getOrdinal());
    }

    @Override
    public YoEnum<E> getYoVariable() {
        return this.yoEnum;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoEnum.getName();
    }

    private static class YoEnumPropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoEnumAsStringProperty<?>> propertyRef;

        public YoEnumPropertyUpdater(YoEnumAsStringProperty<?> property) {
            this.propertyRef = new WeakReference(property);
        }

        public void changed(YoVariable source) {
            YoEnumAsStringProperty property = (YoEnumAsStringProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoEnumValue();
            }
        }
    }
}

