/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.Property;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SharedMemoryJavaFXMessager;

public class BufferedJavaFXMessager
extends SharedMemoryJavaFXMessager {
    private final HashMap<MessagerAPIFactory.Topic<?>, AtomicReference<?>> internalBuffer = new HashMap();

    public BufferedJavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        super(messagerAPI);
        for (MessagerAPIFactory.Topic topic : messagerAPI.getAllTopics()) {
            this.internalBuffer.put(topic, super.createInput(topic, null));
        }
    }

    public <T> T getLastValue(MessagerAPIFactory.Topic<T> topic) {
        return (T)this.internalBuffer.get(topic).get();
    }

    @Override
    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        if (defaultValue == null) {
            return super.createInput(topic, this.internalBuffer.get(topic).get());
        }
        return super.createInput(topic, defaultValue);
    }

    public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic, T initialValue) {
        if (initialValue == null) {
            return super.createPropertyInput(topic, this.internalBuffer.get(topic).get());
        }
        return super.createPropertyInput(topic, initialValue);
    }
}

