/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Pair;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.definition.yoChart.YoChartConfigurationDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupLayout;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.TableSizeQuickAccess;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartGroupTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.StringTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoChartGroupPanelController
implements VisualizerController {
    private SessionVisualizerWindowToolkit toolkit;
    private YoCompositeSearchManager yoCompositeSearchManager;
    private final StringProperty chartGroupName = new SimpleStringProperty((Object)this, "chartGroupName", null);
    private final StringProperty userDefinedChartGroupName = new SimpleStringProperty((Object)this, "userDefinedChartGroupName", null);
    private final StringProperty automatedChartGroupName = new SimpleStringProperty((Object)this, "automatedChartGroupName", null);
    private final IntegerProperty numberOfRows = new SimpleIntegerProperty((Object)this, "numberOfRows", 0);
    private final IntegerProperty numberOfCols = new SimpleIntegerProperty((Object)this, "numberOfCols", 0);
    private final GridPane gridPane = new GridPane();
    private final ObservableList<YoChartPanelController> chartControllers = FXCollections.observableArrayList();
    private final BooleanProperty isRunning = new SimpleBooleanProperty((Object)this, "isRunning", false);
    private final IntegerProperty maximumRowNumberProperty = new SimpleIntegerProperty((Object)this, "maximumRow", 6);
    private final IntegerProperty maximumColNumberProperty = new SimpleIntegerProperty((Object)this, "maximumColumn", 6);
    @FXML
    private AnchorPane mainPane;
    @FXML
    private JFXButton dropDownMenuButton;
    private TopicListener<Pair<Window, File>> loadChartGroupConfigurationListener = m -> this.loadChartGroupConfiguration((Window)m.getKey(), (File)m.getValue());
    private TopicListener<Pair<Window, File>> saveChartGroupConfigurationListener = m -> this.saveChartGroupConfiguration((Window)m.getKey(), (File)m.getValue());
    private TopicListener<Pair<Window, String>> userDefinedChartGroupNameListener = m -> {
        if (m.getKey() == this.toolkit.getWindow()) {
            this.setUserDefinedChartGroupName((String)m.getValue());
        }
    };
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private boolean isMessagerSetup = false;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.mainPane.getChildren().add(0, (Object)this.gridPane);
        AnchorPane.setTopAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.gridPane, (Double)0.0);
        this.gridPane.getStyleClass().add((Object)"chart-group-grid-pane");
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.messager.submitMessage(this.topics.getRegisterRecordable(), (Object)this.mainPane);
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), m -> this.mainPane.setDisable(m.booleanValue()));
        toolkit.getWindow().iconifiedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue() != this.isRunning.get()) {
                return;
            }
            if (newValue.booleanValue()) {
                this.stop();
            } else {
                this.start();
            }
        });
        this.chartGroupName.bind((ObservableValue)this.automatedChartGroupName);
        this.userDefinedChartGroupName.addListener((ChangeListener)new ChangeListener<String>(){
            private Observable currentBind;
            {
                this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
            }

            public void changed(ObservableValue<? extends String> o, String oldValue, String newValue) {
                if (newValue != null) {
                    if (this.currentBind != YoChartGroupPanelController.this.userDefinedChartGroupName) {
                        this.currentBind = YoChartGroupPanelController.this.userDefinedChartGroupName;
                        YoChartGroupPanelController.this.chartGroupName.unbind();
                        YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.userDefinedChartGroupName);
                    }
                } else if (newValue == null && this.currentBind != YoChartGroupPanelController.this.automatedChartGroupName) {
                    this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
                    YoChartGroupPanelController.this.chartGroupName.unbind();
                    YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.automatedChartGroupName);
                }
            }
        });
        ObservableSet allVariableNames = FXCollections.observableSet(new HashSet());
        allVariableNames.addListener(change -> {
            if (change.getSet().isEmpty()) {
                this.automatedChartGroupName.set(null);
                this.userDefinedChartGroupName.set(null);
            } else {
                this.automatedChartGroupName.set((Object)StringTools.commonSubString((Collection<? extends String>)change.getSet()));
            }
        });
        SetChangeListener plottedVariableChangeListener = change -> {
            if (change.wasAdded()) {
                allVariableNames.add((Object)((YoVariable)change.getElementAdded()).getName());
            }
            if (change.wasRemoved()) {
                allVariableNames.remove((Object)((YoVariable)change.getElementRemoved()).getName());
            }
        };
        this.chartControllers.addListener(change -> {
            while (change.next()) {
                if (change.wasPermutated()) continue;
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(controller -> controller.getPlottedVariables().addListener(plottedVariableChangeListener));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(controller -> controller.getPlottedVariables().removeListener(plottedVariableChangeListener));
            }
        });
    }

    public void setChartGroupConfiguration(YoChartGroupConfigurationDefinition definition) {
        if (definition.getNumberOfRows() > this.maximumRowNumberProperty.get() || definition.getNumberOfColumns() > this.maximumColNumberProperty.get()) {
            LogTools.warn((String)"Cannot set from configuration, required number of rows/columns is too large.");
            return;
        }
        this.clear();
        this.userDefinedChartGroupName.set((Object)definition.getName());
        this.numberOfRows.set(definition.getNumberOfRows());
        this.numberOfCols.set(definition.getNumberOfColumns());
        this.updateChartLayout();
        if (definition.getChartConfigurations() != null) {
            for (YoChartConfigurationDefinition chartConfiguration : definition.getChartConfigurations()) {
                YoChartPanelController chartController = this.getChartController(new ChartIdentifier(chartConfiguration.getIdentifier()));
                chartController.setChartConfiguration(chartConfiguration);
            }
        }
    }

    private void clear() {
        new ArrayList<YoChartPanelController>((Collection<YoChartPanelController>)this.chartControllers).forEach(this::closeAndDisposeChart);
        this.numberOfRows.set(0);
        this.numberOfCols.set(0);
    }

    public void setupMessager() {
        if (this.isMessagerSetup) {
            return;
        }
        this.isMessagerSetup = true;
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoChartGroupLoadConfiguration(), this.loadChartGroupConfigurationListener);
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoChartGroupSaveConfiguration(), this.saveChartGroupConfigurationListener);
        this.messager.registerTopicListener(this.topics.getYoChartGroupName(), this.userDefinedChartGroupNameListener);
    }

    public void scheduleMessagerCleanup() {
        this.toolkit.getBackgroundExecutorManager().executeInBackground(() -> {
            if (!this.isMessagerSetup) {
                return;
            }
            this.isMessagerSetup = false;
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoChartGroupLoadConfiguration(), this.loadChartGroupConfigurationListener);
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoChartGroupSaveConfiguration(), this.saveChartGroupConfigurationListener);
            this.messager.removeTopicListener(this.topics.getYoChartGroupName(), this.userDefinedChartGroupNameListener);
        });
    }

    private void updateChartLayout() {
        int excess;
        int preferredNumberOfCharts = this.numberOfRows.get() * this.numberOfCols.get();
        if (this.chartControllers.size() > preferredNumberOfCharts) {
            excess = this.chartControllers.size() - preferredNumberOfCharts;
            ArrayDeque emptyCharts = this.chartControllers.stream().filter(YoChartPanelController::isEmpty).collect(Collectors.toCollection(ArrayDeque::new));
            if (!emptyCharts.isEmpty()) {
                while (emptyCharts.size() > excess) {
                    emptyCharts.removeFirst();
                }
                emptyCharts.forEach(this::closeAndDisposeChart);
            }
        }
        if (this.chartControllers.size() > preferredNumberOfCharts) {
            excess = this.chartControllers.size() - preferredNumberOfCharts;
            int numberOfRowsToAdd = excess / this.numberOfCols.get() + 1;
            this.numberOfRows.set(this.numberOfRows.get() + numberOfRowsToAdd);
            preferredNumberOfCharts = this.numberOfRows.get() * this.numberOfCols.get();
        }
        while (this.chartControllers.size() < preferredNumberOfCharts) {
            YoChartPanelController newController = this.createNewChartPanel(this.isRunning.get());
            this.gridPane.getChildren().add((Object)newController.getMainPane());
            this.chartControllers.add((Object)newController);
        }
        this.updateConstraint();
    }

    private void updateConstraint() {
        int row = 0;
        int col = 0;
        for (YoChartPanelController chart : this.chartControllers) {
            GridPane.setConstraints((Node)chart.getMainPane(), (int)col, (int)row);
            if (++col != this.numberOfCols.get()) continue;
            ++row;
            col = 0;
        }
    }

    private void removeEmptyRowsAndColumns() {
        boolean isEmpty;
        if (this.chartControllers.isEmpty()) {
            return;
        }
        int lastRow = this.chartControllers.stream().mapToInt(chart -> GridPane.getRowIndex((Node)chart.getMainPane())).max().getAsInt();
        int lastColumn = this.chartControllers.stream().mapToInt(chart -> GridPane.getColumnIndex((Node)chart.getMainPane())).max().getAsInt();
        for (int row = lastRow; row >= 0; --row) {
            int rowFinal = row;
            isEmpty = this.chartControllers.stream().noneMatch(chart -> GridPane.getRowIndex((Node)chart.getMainPane()) == rowFinal);
            if (!isEmpty) continue;
            for (YoChartPanelController chart2 : this.chartControllers) {
                int chartRow = GridPane.getRowIndex((Node)chart2.getMainPane());
                if (chartRow <= row) continue;
                GridPane.setRowIndex((Node)chart2.getMainPane(), (Integer)(chartRow - 1));
            }
        }
        for (int column = lastColumn; column >= 0; --column) {
            int columnFinal = column;
            isEmpty = this.chartControllers.stream().noneMatch(chart -> GridPane.getColumnIndex((Node)chart.getMainPane()) == columnFinal);
            if (!isEmpty) continue;
            for (YoChartPanelController chart2 : this.chartControllers) {
                int chartColumn = GridPane.getColumnIndex((Node)chart2.getMainPane());
                if (chartColumn <= column) continue;
                GridPane.setColumnIndex((Node)chart2.getMainPane(), (Integer)(chartColumn - 1));
            }
        }
    }

    private void handleCloseChart(ActionEvent event, YoChartPanelController chartToClose) {
        this.closeAndDisposeChart(chartToClose);
        event.consume();
    }

    private void closeAndDisposeChart(YoChartPanelController chartToClose) {
        chartToClose.closeAndDispose();
        this.gridPane.getChildren().remove((Object)chartToClose.getMainPane());
        this.chartControllers.remove((Object)chartToClose);
        this.removeEmptyRowsAndColumns();
        this.numberOfRows.set(this.chartControllers.size() / this.numberOfCols.intValue());
    }

    private void closeEmptyCharts() {
        Iterator chartControllersIterator = this.chartControllers.iterator();
        while (chartControllersIterator.hasNext()) {
            YoChartPanelController controller = (YoChartPanelController)chartControllersIterator.next();
            if (!controller.isEmpty()) continue;
            chartControllersIterator.remove();
            this.closeAndDisposeChart(controller);
        }
    }

    public YoChartPanelController getChartController(ChartIdentifier chartIdentifier) {
        return this.getChartController(chartIdentifier.getRow(), chartIdentifier.getColumn());
    }

    public YoChartPanelController getChartController(int row, int column) {
        for (YoChartPanelController controller : this.chartControllers) {
            AnchorPane node = controller.getMainPane();
            if (GridPane.getRowIndex((Node)node) != row || GridPane.getColumnIndex((Node)node) != column) continue;
            return controller;
        }
        return null;
    }

    public ChartIdentifier getChartIdentifier(YoChartPanelController controller) {
        return new ChartIdentifier(GridPane.getRowIndex((Node)controller.getMainPane()), GridPane.getColumnIndex((Node)controller.getMainPane()));
    }

    private YoChartPanelController createNewChartPanel(boolean start) {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_PANEL_FXML_URL);
            AnchorPane graphNode = (AnchorPane)loader.load();
            YoChartPanelController controller = (YoChartPanelController)loader.getController();
            controller.initialize(this.toolkit);
            DynamicLineChart chartNode = controller.getLineChart();
            chartNode.setOnDragOver(e -> this.handleDragOver((DragEvent)e, controller));
            chartNode.setOnDragDropped(e -> this.handleDragDropped((DragEvent)e, controller));
            chartNode.setOnDragEntered(e -> this.handleDragEntered((DragEvent)e, controller));
            chartNode.setOnDragExited(e -> this.handleDragExited((DragEvent)e, controller));
            controller.getCloseButton().setOnAction(e -> this.handleCloseChart((ActionEvent)e, controller));
            YoChartGroupPanelController.setGrowProperty((Node)graphNode);
            if (start) {
                controller.start();
            }
            return controller;
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not create new line chart panel:", e2);
        }
    }

    private static void setGrowProperty(Node graphNode) {
        GridPane.setHgrow((Node)graphNode, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)graphNode, (Priority)Priority.ALWAYS);
    }

    public void start() {
        this.isRunning.set(true);
        this.setupMessager();
        this.chartControllers.forEach(AnimationTimer::start);
    }

    public void stop() {
        this.isRunning.set(false);
        this.chartControllers.forEach(AnimationTimer::stop);
    }

    public void closeAndDispose() {
        this.isRunning.set(false);
        this.clear();
        this.scheduleMessagerCleanup();
    }

    @FXML
    void openMenu(ActionEvent event) {
        Popup popup = new Popup();
        popup.autoHideProperty().set(true);
        TableSizeQuickAccess tableSizeQuickAccess = new TableSizeQuickAccess("Select graph table size:", this.numberOfRows.get(), this.numberOfCols.get(), this.maximumRowNumberProperty.get(), this.maximumColNumberProperty.get());
        AnchorPane rootNode = tableSizeQuickAccess.getMainPane();
        Pane backgroundPane = new Pane();
        backgroundPane.setStyle("-fx-background-radius:10;-fx-background-color:rgba(79,132,186,0.5);");
        backgroundPane.setEffect((Effect)new GaussianBlur(10.0));
        rootNode.getChildren().add(0, (Object)backgroundPane);
        AnchorPane.setTopAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setBottomAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setLeftAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setRightAnchor((Node)backgroundPane, (Double)-5.0);
        rootNode.setOnMouseClicked(e -> {
            this.numberOfRows.set(tableSizeQuickAccess.selectedRowsProperty().get());
            this.numberOfCols.set(tableSizeQuickAccess.selectedColumnsProperty().get());
            this.updateChartLayout();
            popup.hide();
        });
        tableSizeQuickAccess.getClearAllButton().setOnMouseClicked(e -> {
            this.clear();
            popup.hide();
        });
        tableSizeQuickAccess.getClearEmptyButton().setOnMouseClicked(e -> {
            this.closeEmptyCharts();
            popup.hide();
        });
        popup.getContent().add((Object)rootNode);
        this.dropDownMenuButton.setDisable(true);
        popup.setOnHiding(e -> this.dropDownMenuButton.setDisable(false));
        Bounds boundsInLocal = this.dropDownMenuButton.getBoundsInLocal();
        Point2D anchorPosition = this.dropDownMenuButton.localToScreen(boundsInLocal.getMinX(), boundsInLocal.getMaxY());
        popup.show((Node)this.dropDownMenuButton, anchorPosition.getX(), anchorPosition.getY());
        event.consume();
    }

    public IntegerProperty maximumRowProperty() {
        return this.maximumRowNumberProperty;
    }

    public IntegerProperty maximumColProperty() {
        return this.maximumColNumberProperty;
    }

    public void setUserDefinedChartGroupName(String name) {
        this.userDefinedChartGroupName.set((Object)name);
    }

    public ReadOnlyStringProperty chartGroupNameProperty() {
        return this.chartGroupName;
    }

    private void handleDragEntered(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event)) {
            List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
            List<ChartGroupLayout> configurations = ChartGroupTools.toChartGroupLayouts(yoComposites);
            configurations = this.shiftConfigurationsToSelectedChart(controller, configurations);
            List<YoChartPanelController> controllers = this.controllersInConfigurations(configurations);
            controllers.forEach(c -> c.setSelectionHighlight(true));
        }
        event.consume();
    }

    private void handleDragExited(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event)) {
            this.chartControllers.forEach(c -> c.setSelectionHighlight(false));
        }
        event.consume();
    }

    private void handleDragOver(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event, YoChartPanelController controller) {
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
        if (yoComposites != null) {
            List<ChartGroupLayout> layouts = ChartGroupTools.toChartGroupLayouts(yoComposites);
            if ((layouts = this.shiftConfigurationsToSelectedChart(controller, layouts)).size() > 1) {
                ContextMenu contextMenu = new ContextMenu();
                for (ChartGroupLayout layout : layouts) {
                    Label label = new Label(layout.getName());
                    CustomMenuItem menuItem = new CustomMenuItem((Node)label);
                    label.setOnMouseEntered(e -> {
                        this.chartControllers.forEach(c -> c.setSelectionHighlight(false));
                        this.controllersInConfiguration(layout).forEach(c -> c.setSelectionHighlight(true));
                    });
                    menuItem.setOnAction(e -> this.applyLayout(layout));
                    contextMenu.getItems().add((Object)menuItem);
                }
                contextMenu.show((Node)this.mainPane, event.getScreenX(), event.getScreenY());
            } else if (layouts.size() == 1) {
                this.applyLayout(layouts.get(0));
            } else {
                yoComposites.forEach(yoComposite -> yoComposite.getYoComponents().forEach(controller::addYoVariableToPlot));
            }
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void applyLayout(ChartGroupLayout layout) {
        this.chartControllers.forEach(c -> c.setSelectionHighlight(false));
        for (ChartIdentifier chartIdentifier : layout.getChartIdentifiers()) {
            List<YoVariable> yoVariables = layout.getYoVariables(chartIdentifier);
            YoChartPanelController chartController = this.getChartController(chartIdentifier);
            chartController.addYoVariablesToPlot(yoVariables);
        }
    }

    private List<YoChartPanelController> controllersInConfiguration(ChartGroupModel configuration) {
        if (!this.doesConfigurationFit(configuration)) {
            return null;
        }
        return configuration.getChartIdentifiers().stream().map(this::getChartController).collect(Collectors.toList());
    }

    public List<YoChartPanelController> controllersInConfigurations(List<? extends ChartGroupModel> configurations) {
        return configurations.stream().flatMap(config -> config.getChartIdentifiers().stream()).distinct().map(this::getChartController).collect(Collectors.toList());
    }

    private List<ChartGroupLayout> shiftConfigurationsToSelectedChart(YoChartPanelController selectedChart, List<ChartGroupLayout> layouts) {
        ChartIdentifier selectedId = this.getChartIdentifier(selectedChart);
        return layouts.stream().map(config -> config.shift(selectedId.getRow(), selectedId.getColumn())).filter(this::doesConfigurationFit).collect(Collectors.toList());
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.mainPane) {
            return false;
        }
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager) != null;
    }

    private boolean doesConfigurationFit(ChartGroupModel configuration) {
        return configuration.rowEnd() < this.numberOfRows.get() && configuration.columnEnd() < this.numberOfCols.get();
    }

    public void loadChartGroupConfiguration(Window source, File file) {
        if (source != this.toolkit.getWindow()) {
            return;
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{YoChartGroupConfigurationDefinition.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.setChartGroupConfiguration((YoChartGroupConfigurationDefinition)unmarshaller.unmarshal(file));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void saveChartGroupConfiguration(Window source, File file) {
        if (source != null && source != this.toolkit.getWindow()) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Saving file: " + file));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{YoChartGroupConfigurationDefinition.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.toYoChartGroupConfigurationDefinition(), file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public YoChartGroupConfigurationDefinition toYoChartGroupConfigurationDefinition() {
        YoChartGroupConfigurationDefinition definition = new YoChartGroupConfigurationDefinition();
        definition.setName((String)this.chartGroupName.get());
        definition.setNumberOfRows(this.numberOfRows.get());
        definition.setNumberOfColumns(this.numberOfCols.get());
        definition.setChartConfigurations(this.chartControllers.stream().map(chart -> chart.toYoChartConfigurationDefinition(this.getChartIdentifier((YoChartPanelController)chart))).collect(Collectors.toList()));
        return definition;
    }
}

