/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.layout.FlowPane;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class SessionAdvancedControlsController
implements VisualizerController {
    public static final String INACTIVE_MODE = "session-controls-inactive-mode";
    public static final String ACTIVE_MODE = "session-controls-active-mode";
    private Window owner;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    @FXML
    private FlowPane buttonsContainer;
    @FXML
    private JFXButton previousKeyFrameButton;
    @FXML
    private JFXButton nextKeyFrameButton;
    @FXML
    private FontAwesomeIconView runningIconView;
    @FXML
    private FontAwesomeIconView playbackIconView;
    @FXML
    private FontAwesomeIconView pauseIconView;
    private Property<YoBufferPropertiesReadOnly> bufferProperties;
    private BooleanProperty showProperty = new SimpleBooleanProperty((Object)this, "show", false);

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.bufferProperties = this.messager.createPropertyInput(this.topics.getYoBufferCurrentProperties());
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getShowAdvancedControls(), show -> this.showProperty.set(show.booleanValue()));
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), disable -> this.buttonsContainer.setDisable(disable.booleanValue()));
        this.showProperty.addListener((o, oldValue, newValue) -> this.show((boolean)newValue));
        this.show(this.showProperty.get());
        ReadOnlyObjectProperty<int[]> keyFrameIndicesProperty = toolkit.getKeyFrameManager().keyFrameIndicesProperty();
        keyFrameIndicesProperty.addListener((o, oldValue, newValue) -> {
            boolean disableKeyFrameButtons = newValue == null || ((int[])newValue).length == 0;
            this.previousKeyFrameButton.setDisable(disableKeyFrameButtons);
            this.nextKeyFrameButton.setDisable(disableKeyFrameButtons);
        });
        boolean disableKeyFrameButtons = keyFrameIndicesProperty.get() == null || ((int[])keyFrameIndicesProperty.get()).length == 0;
        this.previousKeyFrameButton.setDisable(disableKeyFrameButtons);
        this.nextKeyFrameButton.setDisable(disableKeyFrameButtons);
        SessionAdvancedControlsController.setupMainControlsActiveMode(this, this.messager, this.topics, this.runningIconView, this.playbackIconView, this.pauseIconView);
    }

    public static void setupMainControlsActiveMode(Object bean, JavaFXMessager messager, SessionVisualizerTopics topics, FontAwesomeIconView runningIconView, FontAwesomeIconView playbackIconView, FontAwesomeIconView pauseIconView) {
        Property sessionCurrentStateProperty = messager.createPropertyInput(topics.getSessionCurrentState(), null);
        Property sessionCurrentModeProperty = messager.createPropertyInput(topics.getSessionCurrentMode(), null);
        SimpleBooleanProperty isRunningActive = new SimpleBooleanProperty((Object)runningIconView, "isRunningActive", false);
        SimpleBooleanProperty isPlaybackActive = new SimpleBooleanProperty((Object)runningIconView, "isPlaybackActive", false);
        SimpleBooleanProperty isPauseActive = new SimpleBooleanProperty((Object)runningIconView, "isPauseActive", false);
        sessionCurrentStateProperty.addListener((arg_0, arg_1, arg_2) -> SessionAdvancedControlsController.lambda$setupMainControlsActiveMode$4((BooleanProperty)isRunningActive, (BooleanProperty)isPlaybackActive, (BooleanProperty)isPauseActive, arg_0, arg_1, arg_2));
        ChangeListener listener = (arg_0, arg_1, arg_2) -> SessionAdvancedControlsController.lambda$setupMainControlsActiveMode$5(sessionCurrentStateProperty, (BooleanProperty)isRunningActive, (BooleanProperty)isPlaybackActive, (BooleanProperty)isPauseActive, arg_0, arg_1, arg_2);
        sessionCurrentModeProperty.addListener(listener);
        listener.changed(null, null, (Object)((SessionMode)sessionCurrentModeProperty.getValue()));
        SessionAdvancedControlsController.setupActiveMode((ObservableBooleanValue)isRunningActive, runningIconView, ACTIVE_MODE, INACTIVE_MODE);
        SessionAdvancedControlsController.setupActiveMode((ObservableBooleanValue)isPlaybackActive, playbackIconView, ACTIVE_MODE, INACTIVE_MODE);
        SessionAdvancedControlsController.setupActiveMode((ObservableBooleanValue)isPauseActive, pauseIconView, ACTIVE_MODE, INACTIVE_MODE);
    }

    public static void setupActiveMode(ObservableBooleanValue observableActive, FontAwesomeIconView iconView, String activeStyleClass, String inactiveStyleClass) {
        InvalidationListener listener = observable -> {
            if (observableActive.get()) {
                iconView.getStyleClass().remove((Object)inactiveStyleClass);
                iconView.getStyleClass().add((Object)activeStyleClass);
            } else {
                iconView.getStyleClass().remove((Object)activeStyleClass);
                iconView.getStyleClass().add((Object)inactiveStyleClass);
            }
        };
        observableActive.addListener(listener);
        listener.invalidated((Observable)observableActive);
    }

    public BooleanProperty showProperty() {
        return this.showProperty;
    }

    public void show(boolean show) {
        this.buttonsContainer.setVisible(show);
        if (show) {
            this.buttonsContainer.setMinHeight(-1.0);
            this.buttonsContainer.setPrefHeight(-1.0);
        } else {
            this.buttonsContainer.setMinHeight(0.0);
            this.buttonsContainer.setPrefHeight(0.0);
        }
    }

    @FXML
    private void startRunning() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.RUNNING);
    }

    @FXML
    private void startPlayback() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PLAYBACK);
    }

    @FXML
    private void pause() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
    }

    @FXML
    private void setInPoint() {
        this.messager.submitMessage(this.topics.getYoBufferInPointIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
    }

    @FXML
    private void gotoInPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
        }
    }

    @FXML
    private void stepBack() {
        this.messager.submitMessage(this.topics.getYoBufferDecrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void stepForward() {
        this.messager.submitMessage(this.topics.getYoBufferIncrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void gotoOutPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
        }
    }

    @FXML
    private void setOutPoint() {
        this.messager.submitMessage(this.topics.getYoBufferOutPointIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
    }

    @FXML
    private void gotoPreviousKeyFrame() {
        this.messager.submitMessage(this.topics.getGoToPreviousKeyFrame(), new Object());
    }

    @FXML
    private void addRemoveKeyFrame() {
        this.messager.submitMessage(this.topics.getToggleKeyFrame(), new Object());
    }

    @FXML
    private void gotoNextKeyFrame() {
        this.messager.submitMessage(this.topics.getGoToNextKeyFrame(), new Object());
    }

    @FXML
    private void requestZoomInGraphs() {
        this.messager.submitMessage(this.topics.getYoChartRequestZoomIn(), (Object)new Pair((Object)this.owner, (Object)true));
    }

    @FXML
    private void requestZoomOutGraphs() {
        this.messager.submitMessage(this.topics.getYoChartRequestZoomOut(), (Object)new Pair((Object)this.owner, (Object)true));
    }

    @FXML
    private void openSimpleControls() {
        this.messager.submitMessage(this.topics.getShowAdvancedControls(), (Object)false);
    }

    private static /* synthetic */ void lambda$setupMainControlsActiveMode$5(Property sessionCurrentStateProperty, BooleanProperty isRunningActive, BooleanProperty isPlaybackActive, BooleanProperty isPauseActive, ObservableValue o, SessionMode oldValue, SessionMode newValue) {
        boolean isSessionActive = sessionCurrentStateProperty.getValue() == SessionState.ACTIVE;
        isRunningActive.set(isSessionActive && newValue == SessionMode.RUNNING);
        isPlaybackActive.set(isSessionActive && newValue == SessionMode.PLAYBACK);
        isPauseActive.set(isSessionActive && newValue == SessionMode.PAUSE);
    }

    private static /* synthetic */ void lambda$setupMainControlsActiveMode$4(BooleanProperty isRunningActive, BooleanProperty isPlaybackActive, BooleanProperty isPauseActive, ObservableValue o, SessionState oldValue, SessionState newValue) {
        if (newValue == SessionState.INACTIVE) {
            isRunningActive.set(false);
            isPlaybackActive.set(false);
            isPauseActive.set(false);
        }
    }
}

