/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.plotter;

import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.PlotterGrid2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXToEuclidConversions;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;

public class Plotter2D
extends Region {
    private final Group root = new Group();
    private final PlotterGrid2D grid2D = new PlotterGrid2D((ReadOnlyObjectProperty<Transform>)this.root.localToSceneTransformProperty());
    private final Translate rootTranslation = new Translate();
    private final Translate trackingTranslation = new Translate();
    private final ObjectProperty<MouseButton> mouseButtonForTranslation = new SimpleObjectProperty((Object)this, "mouseButtonForTranslation", (Object)MouseButton.PRIMARY);
    private final Scale rootScale = new Scale(1.0, -1.0);
    private final DoubleProperty scaleModifier = new SimpleDoubleProperty((Object)this, "scaleModifier", -0.0025);
    private final DoubleProperty minScale = new SimpleDoubleProperty((Object)this, "minScale", 0.01);
    private final Point2D center = new Point2D();
    private final Property<Tuple2DProperty> coordinateToTrack = new SimpleObjectProperty((Object)this, "coordinateToTrackProperty", null);
    private final AnimationTimer trackingAnimation = new AnimationTimer(){
        private boolean initialized = false;

        public void start() {
            this.initialized = false;
            super.start();
        }

        public void handle(long now) {
            Tuple2DProperty coordinateProperty = (Tuple2DProperty)Plotter2D.this.coordinateToTrack.getValue();
            if (coordinateProperty == null) {
                this.stop();
                return;
            }
            Point2D coordinateInWorld = coordinateProperty.toPoint2DInWorld();
            if (coordinateInWorld.containsNaN()) {
                return;
            }
            if (!this.initialized) {
                Plotter2D.this.rootTranslation.setX(0.5 * Plotter2D.this.contentWidth());
                Plotter2D.this.rootTranslation.setY(0.5 * Plotter2D.this.contentHeight());
                Plotter2D.this.trackingTranslation.setX(-coordinateInWorld.getX());
                Plotter2D.this.trackingTranslation.setY(-coordinateInWorld.getY());
                Plotter2D.this.center.set(coordinateInWorld);
                this.initialized = true;
            } else {
                Plotter2D.this.trackingTranslation.setX(-coordinateInWorld.getX());
                Plotter2D.this.trackingTranslation.setY(-coordinateInWorld.getY());
                Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
            }
        }
    };

    public Plotter2D() {
        this.getChildren().add((Object)this.grid2D.getRoot());
        this.getChildren().add((Object)this.root);
        this.root.getTransforms().addAll((Object[])new Transform[]{this.rootTranslation, this.rootScale, this.trackingTranslation});
        this.addEventHandler(MouseEvent.ANY, this.createTranslationEventHandler());
        this.addEventHandler(ScrollEvent.ANY, this.createScaleEventHandler());
        this.requestParentLayout();
        this.setManaged(false);
        this.coordinateToTrack.addListener((o, oldValue, newValue) -> {
            this.trackingAnimation.stop();
            if (oldValue != null) {
                this.trackingTranslation.setX(0.0);
                this.trackingTranslation.setY(0.0);
            }
            if (newValue != null) {
                this.trackingAnimation.start();
            }
        });
    }

    public Property<Tuple2DProperty> coordinateToTrackProperty() {
        return this.coordinateToTrack;
    }

    public void setScale(double scale) {
        this.rootScale.setX(scale);
        this.rootScale.setY(-scale);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY) {
        this.setFieldOfView(centerX, centerY, rangeX, rangeY, true);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY, boolean axisEquals) {
        double contentWidth = this.contentWidth();
        double contentHeight = this.contentHeight();
        double scaleX = contentWidth / rangeX;
        double scaleY = contentHeight / rangeY;
        if (axisEquals) {
            double scale;
            scaleX = scale = Math.min(scaleX, scaleY);
            scaleY = scale;
        }
        this.rootScale.setX(scaleX);
        this.rootScale.setY(-scaleY);
        this.rootTranslation.setX(0.5 * contentWidth - centerX * this.rootScale.getX());
        this.rootTranslation.setY(0.5 * contentHeight - centerY * this.rootScale.getY());
    }

    public EventHandler<MouseEvent> createTranslationEventHandler() {
        return new EventHandler<MouseEvent>(){
            Point2D oldMouseLocation;

            public void handle(MouseEvent event) {
                if (event.getButton() != Plotter2D.this.mouseButtonForTranslation.get() || event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation = new Point2D(event.getX(), event.getY());
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D newMouseLocation = new Point2D(event.getX(), event.getY());
                if (this.oldMouseLocation != null) {
                    Vector2D drag = new Vector2D();
                    drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                    JavaFXMissingTools.addEquals(Plotter2D.this.rootTranslation, (Tuple2DReadOnly)drag);
                    Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                    Plotter2D.this.updateGrid();
                }
                this.oldMouseLocation = newMouseLocation;
            }
        };
    }

    public EventHandler<ScrollEvent> createScaleEventHandler() {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double verticalDrag = event.getDeltaY();
                double oldScale = Plotter2D.this.rootScale.getX();
                double newScale = oldScale * (1.0 - Plotter2D.this.scaleModifier.get() * verticalDrag);
                newScale = Math.max(Plotter2D.this.minScale.get(), newScale);
                double trackedLocationX = event.getX();
                double trackedLocationY = event.getY();
                javafx.geometry.Point2D preScaleLocation = Plotter2D.this.root.sceneToLocal(trackedLocationX, trackedLocationY);
                Plotter2D.this.rootScale.setX(newScale);
                Plotter2D.this.rootScale.setY(-newScale);
                javafx.geometry.Point2D postScaleLocation = Plotter2D.this.root.sceneToLocal(trackedLocationX, trackedLocationY);
                Plotter2D.this.rootTranslation.setX(Plotter2D.this.rootTranslation.getX() + Plotter2D.this.rootScale.getX() * (postScaleLocation.getX() - preScaleLocation.getX()));
                Plotter2D.this.rootTranslation.setY(Plotter2D.this.rootTranslation.getY() + Plotter2D.this.rootScale.getY() * (postScaleLocation.getY() - preScaleLocation.getY()));
                Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                Plotter2D.this.updateGrid();
            }
        };
    }

    private Point2D computeCenterLocal() {
        return JavaFXToEuclidConversions.convertPoint2D(this.root.sceneToLocal(0.5 * this.contentWidth(), 0.5 * this.contentHeight()));
    }

    public void updateGrid() {
        this.grid2D.update(this.snappedTopInset(), this.snappedLeftInset(), this.contentWidth(), this.contentHeight());
    }

    private double contentWidth() {
        return this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
    }

    private double contentHeight() {
        return this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
    }

    protected void layoutChildren() {
        this.recenter();
        this.updateGrid();
    }

    private void recenter() {
        Vector2D translation = new Vector2D();
        translation.sub((Tuple2DReadOnly)this.computeCenterLocal(), (Tuple2DReadOnly)this.center);
        translation.scale(this.rootScale.getX(), this.rootScale.getY());
        JavaFXMissingTools.addEquals(this.rootTranslation, (Tuple2DReadOnly)translation);
    }

    public ObjectProperty<MouseButton> mouseButtonForTranslationProperty() {
        return this.mouseButtonForTranslation;
    }

    public Group getRoot() {
        return this.root;
    }

    public PlotterGrid2D getGrid2D() {
        return this.grid2D;
    }
}

