/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoCoordinateSystemFX3D
extends YoGraphicFX3D {
    private static final Color[] axisColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
    private static final Rotate[] axisBodyRotates = new Rotate[]{new Rotate(-90.0, Rotate.Z_AXIS), null, new Rotate(90.0, Rotate.X_AXIS)};
    private static final AxisAngle[] axisHeadOrientations = new AxisAngle[]{new AxisAngle((Vector3DReadOnly)Axis3D.Y, 1.5707963267948966), new AxisAngle((Vector3DReadOnly)Axis3D.X, -1.5707963267948966), new AxisAngle()};
    private final Group coordinateSystemNode = new Group();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private DoubleProperty bodyLength = new SimpleDoubleProperty(0.3);
    private DoubleProperty bodyRadius = new SimpleDoubleProperty(0.01);
    private DoubleProperty headLength = new SimpleDoubleProperty(0.05);
    private DoubleProperty headRadius = new SimpleDoubleProperty(0.02);
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();
    private CoordinateSystemData newData = null;
    private CoordinateSystemData oldData = null;
    private Node[] newNodes = null;

    public YoCoordinateSystemFX3D() {
        this.coordinateSystemNode.getTransforms().add((Object)this.affine);
    }

    public YoCoordinateSystemFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        this.newData = YoCoordinateSystemFX3D.newCoordinateSystemData(this.bodyLength, this.bodyRadius, this.headLength, this.headRadius);
        this.affine.setToTransform((Transform)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = () -> null;
        }
        this.material.setDiffuseColor((Color)this.color.get());
        if (this.newNodes != null) {
            this.coordinateSystemNode.getChildren().clear();
            this.coordinateSystemNode.getChildren().addAll((Object[])this.newNodes);
            this.newNodes = null;
        }
    }

    static CoordinateSystemData newCoordinateSystemData(DoubleProperty bodyLength, DoubleProperty bodyRadius, DoubleProperty headLength, DoubleProperty headRadius) {
        CoordinateSystemData data = new CoordinateSystemData();
        if (YoGraphicTools.isAnyNull(bodyLength, bodyRadius, headLength, headRadius)) {
            return data;
        }
        data.bodyLength = bodyLength.get();
        data.bodyRadius = bodyRadius.get();
        data.headLength = headLength.get();
        data.headRadius = headRadius.get();
        return data;
    }

    @Override
    public void computeBackground() {
        CoordinateSystemData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.containsNaN()) {
            this.newNodes = new Node[0];
            return;
        }
        if (newDataLocal.equals(this.oldData) && !this.coordinateSystemNode.getChildren().isEmpty()) {
            return;
        }
        this.oldData = newDataLocal;
        this.newNodes = YoCoordinateSystemFX3D.createCoordinateSystem(newDataLocal, (Material)this.material, (ReadOnlyStringProperty)this.nameProperty());
    }

    static Node[] createCoordinateSystem(CoordinateSystemData data, Material material, ReadOnlyStringProperty nameProperty) {
        Node[] nodes = new Node[6];
        Translate axisBodyTranslate = new Translate(0.0, 0.5 * data.bodyLength, 0.0);
        for (int axis = 0; axis < 3; ++axis) {
            Cylinder body = new Cylinder(data.bodyRadius, data.bodyLength);
            body.setMaterial(material);
            body.idProperty().bind((ObservableValue)nameProperty.concat((Object)" (").concat((Object)Axis3D.values[axis].name()).concat((Object)"-body)"));
            if (axisBodyRotates[axis] != null) {
                body.getTransforms().add((Object)axisBodyRotates[axis]);
            }
            body.getTransforms().add((Object)axisBodyTranslate);
            JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
            Point3D headPosition = new Point3D();
            headPosition.setElement(axis, data.bodyLength);
            meshBuilder.addCone(data.headLength, data.headRadius, (Tuple3DReadOnly)headPosition, (Orientation3DReadOnly)axisHeadOrientations[axis]);
            MeshView head = new MeshView(meshBuilder.generateMesh());
            head.setMaterial((Material)new PhongMaterial(axisColors[axis]));
            head.idProperty().bind((ObservableValue)nameProperty.concat((Object)" (").concat((Object)Axis3D.values[axis].name()).concat((Object)"-head)"));
            nodes[2 * axis] = body;
            nodes[2 * axis + 1] = head;
        }
        return nodes;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setBodyLength(DoubleProperty bodyLength) {
        this.bodyLength = bodyLength;
    }

    public void setBodyLength(double bodyLength) {
        this.setBodyLength((DoubleProperty)new SimpleDoubleProperty(bodyLength));
    }

    public void setBodyRadius(DoubleProperty bodyRadius) {
        this.bodyRadius = bodyRadius;
    }

    public void setBodyRadius(double bodyRadius) {
        this.setBodyRadius((DoubleProperty)new SimpleDoubleProperty(bodyRadius));
    }

    public void setHeadLength(DoubleProperty headLength) {
        this.headLength = headLength;
    }

    public void setHeadLength(double headLength) {
        this.setHeadLength((DoubleProperty)new SimpleDoubleProperty(headLength));
    }

    public void setHeadRadius(DoubleProperty headRadius) {
        this.headRadius = headRadius;
    }

    public void setHeadRadius(double headRadius) {
        this.setHeadRadius((DoubleProperty)new SimpleDoubleProperty(headRadius));
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.bodyLength = null;
        this.bodyRadius = null;
        this.headLength = null;
        this.headRadius = null;
        this.color = null;
    }

    @Override
    public YoCoordinateSystemFX3D clone() {
        YoCoordinateSystemFX3D clone = new YoCoordinateSystemFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setBodyLength(this.bodyLength);
        clone.setBodyRadius(this.bodyRadius);
        clone.setHeadLength(this.headLength);
        clone.setHeadRadius(this.headRadius);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public DoubleProperty getBodyLength() {
        return this.bodyLength;
    }

    public DoubleProperty getHeadLength() {
        return this.headLength;
    }

    public DoubleProperty getBodyRadius() {
        return this.bodyRadius;
    }

    public DoubleProperty getHeadRadius() {
        return this.headRadius;
    }

    @Override
    public Node getNode() {
        return this.coordinateSystemNode;
    }

    static class CoordinateSystemData {
        private double bodyLength = Double.NaN;
        private double bodyRadius = Double.NaN;
        private double headLength = Double.NaN;
        private double headRadius = Double.NaN;

        CoordinateSystemData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CoordinateSystemData) {
                CoordinateSystemData other = (CoordinateSystemData)object;
                if (this.bodyLength != other.bodyLength) {
                    return false;
                }
                if (this.bodyRadius != other.bodyRadius) {
                    return false;
                }
                if (this.headLength != other.headLength) {
                    return false;
                }
                return this.headRadius == other.headRadius;
            }
            return false;
        }

        public boolean containsNaN() {
            return Double.isNaN(this.bodyLength) || Double.isNaN(this.bodyRadius) || Double.isNaN(this.headLength) || Double.isNaN(this.headRadius);
        }
    }
}

