/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartBaselinesOptionPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartVariableOptionController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoNumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class YoChartOptionController
implements VisualizerController {
    public static final String UNDEFINED = "N/A";
    @FXML
    private VBox mainPane;
    @FXML
    private TitledPane masterSettingsPane;
    @FXML
    private JFXComboBox<ChartScalingMode> scalingComboBox;
    @FXML
    private JFXTextField manualRangeMinTextField;
    @FXML
    private JFXTextField manualRangeMaxTextField;
    @FXML
    private Label actualRangeMinLabel;
    @FXML
    private Label actualRangeMaxLabel;
    @FXML
    private YoChartBaselinesOptionPaneController yoChartBaselinesOptionPaneController;
    private SessionVisualizerWindowToolkit toolkit;
    private Stage window;
    private ObservableList<YoChartVariableOptionController> subControllers = FXCollections.observableArrayList();
    private ObservableList<YoNumberSeries> yoNumberSeriesList = null;
    private ObjectProperty<DynamicLineChart.ChartStyle> chartStyleProperty;
    private final ObjectProperty<ChartDoubleBounds> actualYBoundsProperty = new SimpleObjectProperty((Object)this, "actualYBounds", null);
    private final ObjectProperty<ChartDoubleBounds> manualYBoundsProperty = new SimpleObjectProperty((Object)this, "manualYBounds", null);
    private final TextFormatter<Double> minFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)0.0);
    private final TextFormatter<Double> maxFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)0.0);
    private final ChangeListener<Double> manualMinListener = (o, oldValue, newValue) -> {
        if (this.manualRangeMinTextField.isDisabled()) {
            return;
        }
        if (newValue > (Double)this.maxFormatter.getValue()) {
            this.minFormatter.setValue(oldValue);
            return;
        }
        if (this.manualYBoundsProperty.get() == null) {
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((double)newValue, (double)newValue));
        } else {
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((double)newValue, ((ChartDoubleBounds)this.manualYBoundsProperty.get()).getUpper()));
        }
    };
    private final ChangeListener<Double> manualMaxListener = (o, oldValue, newValue) -> {
        if (this.manualRangeMaxTextField.isDisabled()) {
            return;
        }
        if (newValue < (Double)this.minFormatter.getValue()) {
            this.maxFormatter.setValue(oldValue);
            return;
        }
        if (this.manualYBoundsProperty.get() == null) {
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((double)newValue, (double)newValue));
        } else {
            this.manualYBoundsProperty.set((Object)new ChartDoubleBounds(((ChartDoubleBounds)this.manualYBoundsProperty.get()).getLower(), (double)newValue));
        }
    };
    private final ChangeListener<ChartDoubleBounds> customBoundsUpdater = (o, oldValue, newValue) -> this.yoNumberSeriesList.forEach(series -> series.setCustomYBounds((ChartDoubleBounds)newValue));
    private final ChangeListener<ChartScalingMode> scalingModeListener = (o, oldValue, newValue) -> {
        this.manualRangeMinTextField.setDisable(newValue != ChartScalingMode.MANUAL);
        this.manualRangeMaxTextField.setDisable(newValue != ChartScalingMode.MANUAL);
        if (newValue == ChartScalingMode.MANUAL) {
            if (this.manualYBoundsProperty.get() == null) {
                this.manualYBoundsProperty.set((Object)new ChartDoubleBounds((ChartDoubleBounds)this.actualYBoundsProperty.get()));
            }
            this.minFormatter.setValue((Object)((ChartDoubleBounds)this.manualYBoundsProperty.get()).getLower());
            this.maxFormatter.setValue((Object)((ChartDoubleBounds)this.manualYBoundsProperty.get()).getUpper());
            this.manualYBoundsProperty.addListener(this.customBoundsUpdater);
            this.customBoundsUpdater.changed(null, null, this.manualYBoundsProperty.get());
        } else {
            this.manualYBoundsProperty.removeListener(this.customBoundsUpdater);
        }
        if (newValue == ChartScalingMode.AUTO && this.yoNumberSeriesList != null) {
            this.yoNumberSeriesList.forEach(series -> {
                series.customYBoundsProperty().unbind();
                series.setCustomYBounds(null);
            });
        }
        if (this.chartStyleProperty != null) {
            if (newValue == ChartScalingMode.INDIVIDUAL) {
                this.chartStyleProperty.set((Object)DynamicLineChart.ChartStyle.NORMALIZED);
            } else {
                this.chartStyleProperty.set((Object)DynamicLineChart.ChartStyle.RAW);
            }
        }
    };
    private final InvalidationListener actualBoundsUpdater = o -> this.updateActualBounds();
    private final ChangeListener<Object> resizeWindowListener = (o, oldValue, newValue) -> this.resizeWindow();

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.manualRangeMinTextField.setTextFormatter(this.minFormatter);
        this.manualRangeMaxTextField.setTextFormatter(this.maxFormatter);
        this.actualRangeMinLabel.setText(UNDEFINED);
        this.actualRangeMaxLabel.setText(UNDEFINED);
        this.scalingComboBox.setItems(FXCollections.observableArrayList((Object[])ChartScalingMode.values()));
        this.minFormatter.valueProperty().addListener(this.manualMinListener);
        this.maxFormatter.valueProperty().addListener(this.manualMaxListener);
        this.scalingComboBox.valueProperty().addListener(this.scalingModeListener);
        this.scalingComboBox.setValue((Object)ChartScalingMode.AUTO);
        this.subControllers.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (int i = change.getAddedSize() - 1; i >= 0; --i) {
                        YoChartVariableOptionController subController2 = (YoChartVariableOptionController)change.getAddedSubList().get(i);
                        this.mainPane.getChildren().add(change.getFrom() + 1, (Object)subController2.getMainPane());
                        subController2.getMainPane().expandedProperty().addListener(this.resizeWindowListener);
                    }
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(subController -> {
                    subController.getMainPane().expandedProperty().removeListener(this.resizeWindowListener);
                    this.mainPane.getChildren().remove((Object)subController.getMainPane());
                    subController.detachListeners();
                });
            }
            this.resizeWindow();
        });
        this.yoChartBaselinesOptionPaneController.initialize(toolkit);
        this.yoChartBaselinesOptionPaneController.getMainPane().heightProperty().addListener(this.resizeWindowListener);
        this.window = new Stage(StageStyle.UTILITY);
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.setTitle("YoChart properties");
        Scene scene = new Scene((Parent)this.mainPane);
        this.masterSettingsPane.expandedProperty().addListener((o, oldValue, newValue) -> this.resizeWindow());
        this.window.setResizable(false);
        this.window.setScene(scene);
        this.window.initOwner((Window)toolkit.getWindow());
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void close() {
        this.window.close();
    }

    public void setInput(ObservableList<YoNumberSeries> yoNumberSeriesList, ObjectProperty<DynamicLineChart.ChartStyle> chartStyleProperty, ObservableList<ChartMarker> userMarkers) {
        this.yoNumberSeriesList = yoNumberSeriesList;
        this.chartStyleProperty = chartStyleProperty;
        yoNumberSeriesList.forEach(series -> series.yBoundsProperty().addListener(this.actualBoundsUpdater));
        yoNumberSeriesList.addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    change.getRemoved().forEach(series -> series.yBoundsProperty().removeListener(this.actualBoundsUpdater));
                }
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(series -> series.yBoundsProperty().addListener(this.actualBoundsUpdater));
            }
            if (!change.getList().isEmpty()) {
                this.updateActualBounds();
            }
        });
        if (chartStyleProperty.get() == DynamicLineChart.ChartStyle.RAW) {
            Optional<ChartDoubleBounds> customBounds = yoNumberSeriesList.stream().map(NumberSeries::getCustomYBounds).filter(Objects::nonNull).findFirst();
            this.manualYBoundsProperty.set(customBounds.isPresent() ? customBounds.get() : null);
            this.scalingComboBox.setValue((Object)(customBounds.isPresent() ? ChartScalingMode.MANUAL : ChartScalingMode.AUTO));
        } else {
            this.scalingComboBox.setValue((Object)ChartScalingMode.INDIVIDUAL);
        }
        this.subControllers.clear();
        yoNumberSeriesList.forEach(this::loadAndInitializeSubController);
        yoNumberSeriesList.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(series -> this.loadAndInitializeSubController((YoNumberSeries)series, change.getFrom()));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(series -> this.unloadController((YoNumberSeries)series));
            }
        });
        this.actualYBoundsProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (this.manualYBoundsProperty.get() == null) {
                this.minFormatter.setValue((Object)newValue.getLower());
                this.maxFormatter.setValue((Object)newValue.getUpper());
            }
            this.actualRangeMinLabel.setText(Double.toString(newValue.getLower()));
            this.actualRangeMaxLabel.setText(Double.toString(newValue.getUpper()));
        });
        this.scalingModeListener.changed(null, null, this.scalingComboBox.getValue());
        this.updateActualBounds();
        this.yoChartBaselinesOptionPaneController.setInput(userMarkers);
        this.resizeWindow();
    }

    private void resizeWindow() {
        JavaFXMissingTools.runLater(this.getClass(), () -> this.window.sizeToScene());
    }

    private void updateActualBounds() {
        ChartDoubleBounds newBounds = null;
        for (YoNumberSeries series : this.yoNumberSeriesList) {
            ChartDoubleBounds dataYBounds = (ChartDoubleBounds)series.yBoundsProperty().getValue();
            if (dataYBounds == null) continue;
            if (newBounds == null) {
                newBounds = new ChartDoubleBounds(dataYBounds);
                continue;
            }
            newBounds = newBounds.union(dataYBounds);
        }
        this.actualYBoundsProperty.set(newBounds);
    }

    private void unloadController(YoNumberSeries series) {
        Iterator iterator = this.subControllers.iterator();
        while (iterator.hasNext()) {
            YoChartVariableOptionController subController = (YoChartVariableOptionController)iterator.next();
            if (subController.getSeries() != series) continue;
            iterator.remove();
            return;
        }
    }

    private void loadAndInitializeSubController(YoNumberSeries series) {
        this.loadAndInitializeSubController(series, this.subControllers.size());
    }

    private void loadAndInitializeSubController(YoNumberSeries series, int insertionIndex) {
        YoChartVariableOptionController subController = this.loadSubController();
        subController.initialize(this.toolkit);
        subController.setInput(series, (Property<ChartScalingMode>)this.scalingComboBox.valueProperty());
        this.subControllers.add(insertionIndex, (Object)subController);
    }

    private YoChartVariableOptionController loadSubController() {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_VARIABLE_OPTION_PANE_URL);
            loader.load();
            return (YoChartVariableOptionController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum ChartScalingMode {
        AUTO,
        INDIVIDUAL,
        MANUAL;

    }
}

