/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import java.util.Collection;
import javafx.stage.Window;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;

public interface SessionVisualizerControls {
    public Window getPrimaryWindow();

    public void setCameraOrientation(double var1, double var3, double var5);

    public void setCameraPosition(double var1, double var3, double var5);

    public void setCameraFocusPosition(double var1, double var3, double var5);

    public void setCameraZoom(double var1);

    public void requestCameraRigidBodyTracking(String var1, String var2);

    default public void addStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.addStaticVisual(visualDefinition);
        }
    }

    public void addStaticVisual(VisualDefinition var1);

    default public void removeStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.removeStaticVisual(visualDefinition);
        }
    }

    public void removeStaticVisual(VisualDefinition var1);

    public void addYoGraphic(String var1, YoGraphicDefinition var2);

    public void addYoGraphic(YoGraphicDefinition var1);

    default public void exportVideo(File file) {
        SceneVideoRecordingRequest request = new SceneVideoRecordingRequest();
        request.setFile(file);
        this.exportVideo(request);
    }

    public void exportVideo(SceneVideoRecordingRequest var1);

    public void disableUserControls();

    public void enableUserControls();

    public void shutdown();

    public void shutdownNow();

    public void addVisualizerShutdownListener(Runnable var1);

    public void waitUntilFullyUp();

    public void waitUntilDown();
}

