/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceMaterial;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCylinder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicEllipsoid;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicLineSegment;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicShape;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicText;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicText3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicTriangle;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVRML;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLine2d;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactOval;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoQuaternionDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoYawPitchRollDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicArrow3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCoordinateSystem3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCylinder3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicLine2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPoint2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPoint3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygon2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygonExtruded3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolynomial3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class SCS1GraphicConversionTools {
    public static List<YoGraphicDefinition> toYoGraphicDefinitions(YoGraphicsListRegistry registry) {
        YoGraphicGroupDefinition oldDefinition;
        YoGraphicGroupDefinition newDefinition;
        ArrayList yoGraphicsLists = new ArrayList();
        registry.getRegisteredYoGraphicsLists(yoGraphicsLists);
        ArrayList artifactLists = new ArrayList();
        registry.getRegisteredArtifactLists(artifactLists);
        LinkedHashMap<String, YoGraphicGroupDefinition> definitionMap = new LinkedHashMap<String, YoGraphicGroupDefinition>();
        for (YoGraphicsList yoGraphicsList : yoGraphicsLists) {
            newDefinition = SCS1GraphicConversionTools.toYoGraphicGroupDefinition(yoGraphicsList);
            oldDefinition = (YoGraphicGroupDefinition)definitionMap.get(newDefinition.getName());
            if (oldDefinition != null) {
                oldDefinition.getChildren().addAll(newDefinition.getChildren());
                continue;
            }
            definitionMap.put(newDefinition.getName(), newDefinition);
        }
        for (ArtifactList artifactList : artifactLists) {
            newDefinition = SCS1GraphicConversionTools.toYoGraphicGroupDefinition(artifactList);
            oldDefinition = (YoGraphicGroupDefinition)definitionMap.get(newDefinition.getName());
            if (oldDefinition != null) {
                oldDefinition.getChildren().addAll(newDefinition.getChildren());
                continue;
            }
            definitionMap.put(newDefinition.getName(), newDefinition);
        }
        return new ArrayList<YoGraphicDefinition>(definitionMap.values());
    }

    public static YoGraphicGroupDefinition toYoGraphicGroupDefinition(YoGraphicsList yoGraphicsList) {
        YoGraphicGroupDefinition groupDefinition = new YoGraphicGroupDefinition();
        groupDefinition.setName(yoGraphicsList.getLabel());
        groupDefinition.setChildren(yoGraphicsList.getYoGraphics().stream().map(SCS1GraphicConversionTools::toYoGraphicDefinition).collect(Collectors.toList()));
        return groupDefinition;
    }

    public static YoGraphicGroupDefinition toYoGraphicGroupDefinition(ArtifactList artifactList) {
        YoGraphicGroupDefinition groupDefinition = new YoGraphicGroupDefinition();
        groupDefinition.setName(artifactList.getLabel());
        groupDefinition.setChildren(artifactList.getArtifacts().stream().map(SCS1GraphicConversionTools::toYoGraphicDefinition).collect(Collectors.toList()));
        return groupDefinition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphic yoGraphic) {
        if (yoGraphic == null) {
            return null;
        }
        YoGraphicDefinition definition = null;
        if (yoGraphic instanceof YoGraphicPolygon) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicPolygon)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicShape) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicShape)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicText) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicText)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicText3D) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicText3D)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicCoordinateSystem) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicCoordinateSystem)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicCylinder) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicCylinder)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicPolygon3D) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicPolygon3D)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicPolynomial3D) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicPolynomial3D)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicPosition) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicPosition)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicTriangle) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicTriangle)yoGraphic);
        } else if (yoGraphic instanceof YoGraphicVector) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicVector)yoGraphic);
        } else {
            LogTools.error((String)("Unsupported YoGraphic type: " + yoGraphic));
            return null;
        }
        definition.setName(yoGraphic.getName());
        definition.setVisible(yoGraphic.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicPolygon yoGraphicPolygon) {
        YoGraphicPolygonExtruded3DDefinition definition = new YoGraphicPolygonExtruded3DDefinition();
        definition.setName(yoGraphicPolygon.getName());
        YoVariable[] yoVariables = yoGraphicPolygon.getVariables();
        int yoVariableIndex = 0;
        double[] constants = yoGraphicPolygon.getConstants();
        int constantIndex = 1;
        int vertexBufferSize = (int)constants[constantIndex++];
        definition.setThickness(constants.length == 3 ? constants[constantIndex++] : 0.01);
        definition.setNumberOfVertices(yoVariables[yoVariableIndex++].getFullNameString());
        ArrayList<YoTuple2DDefinition> vertices = new ArrayList<YoTuple2DDefinition>();
        for (int i = 0; i < vertexBufferSize; ++i) {
            YoTuple2DDefinition vertex = SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, yoVariableIndex);
            vertex.setReferenceFrame(null);
            vertices.add(vertex);
            yoVariableIndex += 2;
        }
        definition.setVertices(vertices);
        definition.setPosition(SCS1GraphicConversionTools.toYoTuple3DDefinition(yoVariables, yoVariableIndex));
        yoVariableIndex += 3;
        if (yoGraphicPolygon.isUsingYawPitchRoll()) {
            definition.setOrientation((YoOrientation3DDefinition)SCS1GraphicConversionTools.toYoYawPitchRollDefinition(yoVariables, yoVariableIndex));
            yoVariableIndex += 3;
        } else {
            definition.setOrientation((YoOrientation3DDefinition)SCS1GraphicConversionTools.toYoQuaternionDefinition(yoVariables, yoVariableIndex));
            yoVariableIndex += 4;
        }
        definition.setColor(SCS1GraphicConversionTools.toColorDefinition(yoGraphicPolygon.getAppearance()));
        definition.setVisible(yoGraphicPolygon.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicShape yoGraphicShape) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicText yoGraphicText) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicText3D yoGraphicText3D) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicCoordinateSystem yoGraphicCoordinateSystem) {
        if (yoGraphicCoordinateSystem instanceof YoGraphicEllipsoid) {
            return SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicEllipsoid)yoGraphicCoordinateSystem);
        }
        if (yoGraphicCoordinateSystem instanceof YoGraphicVRML) {
            return SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicVRML)yoGraphicCoordinateSystem);
        }
        YoGraphicCoordinateSystem3DDefinition definition = new YoGraphicCoordinateSystem3DDefinition();
        definition.setName(yoGraphicCoordinateSystem.getName());
        YoDouble[] yoVariables = yoGraphicCoordinateSystem.getVariables();
        int yoVariableIndex = 0;
        double[] constants = yoGraphicCoordinateSystem.getConstants();
        definition.setPosition(SCS1GraphicConversionTools.toYoTuple3DDefinition((YoVariable[])yoVariables, yoVariableIndex));
        yoVariableIndex += 3;
        if (yoVariables.length == 6) {
            definition.setOrientation((YoOrientation3DDefinition)SCS1GraphicConversionTools.toYoYawPitchRollDefinition((YoVariable[])yoVariables, yoVariableIndex));
            yoVariableIndex += 3;
        } else {
            definition.setOrientation((YoOrientation3DDefinition)SCS1GraphicConversionTools.toYoQuaternionDefinition((YoVariable[])yoVariables, yoVariableIndex));
            yoVariableIndex += 4;
        }
        double scale = constants[0];
        definition.setBodyLength(0.9 * scale);
        definition.setHeadLength(0.1 * scale);
        definition.setBodyRadius(0.02 * scale);
        definition.setHeadRadius(0.04 * scale);
        if (constants.length == 3) {
            definition.setColor(ColorDefinition.rgb((int)((int)constants[1])));
            definition.getColor().setAlpha(1.0 - constants[2]);
        }
        definition.setVisible(yoGraphicCoordinateSystem.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicEllipsoid yoGraphicEllipsoid) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicReferenceFrame yoGraphicReferenceFrame) {
        return SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicCoordinateSystem)yoGraphicReferenceFrame);
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicVRML yoGraphicVRML) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicCylinder yoGraphicCylinder) {
        YoGraphicCylinder3DDefinition definition = new YoGraphicCylinder3DDefinition();
        definition.setName(yoGraphicCylinder.getName());
        YoVariable[] yoVariables = yoGraphicCylinder.getVariables();
        int yoVariableIndex = 0;
        double[] constants = yoGraphicCylinder.getConstants();
        definition.setCenter(SCS1GraphicConversionTools.toYoTuple3DDefinition(yoVariables, yoVariableIndex));
        definition.setAxis(SCS1GraphicConversionTools.toYoTuple3DDefinition(yoVariables, yoVariableIndex += 3));
        yoVariableIndex += 3;
        definition.setRadius(constants[0]);
        definition.setColor(SCS1GraphicConversionTools.toColorDefinition(yoGraphicCylinder.getAppearance()));
        definition.setVisible(yoGraphicCylinder.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicPolygon3D yoGraphicPolygon3D) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicPolynomial3D yoGraphicPolynomial3D) {
        boolean hasPoseDefined;
        YoVariable[] yoVariables = yoGraphicPolynomial3D.getVariables();
        int yoVariableIndex = 0;
        double[] constants = yoGraphicPolynomial3D.getConstants();
        boolean bl = hasPoseDefined = (int)constants[3] == 1;
        if (hasPoseDefined) {
            LogTools.error((String)("Unsupported feature [hasPoseDefined] for " + yoGraphicPolynomial3D));
            return null;
        }
        int numberOfPolynomials = (int)constants[4];
        double[] polynomialSizes = Arrays.copyOfRange(constants, 5, 5 + 3 * numberOfPolynomials);
        if (numberOfPolynomials == 1) {
            YoGraphicPolynomial3DDefinition definition = new YoGraphicPolynomial3DDefinition();
            definition.setName(yoGraphicPolynomial3D.getName());
            definition.setSize(constants[0]);
            int xSize = (int)polynomialSizes[0];
            String xNumberOfCoeffs = yoVariables[yoVariableIndex].getFullNameString();
            List xCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + xSize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            int ySize = (int)polynomialSizes[1];
            String yNumberOfCoeffs = yoVariables[yoVariableIndex += xSize].getFullNameString();
            List yCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + ySize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            int zSize = (int)polynomialSizes[2];
            String zNumberOfCoeffs = yoVariables[yoVariableIndex += ySize].getFullNameString();
            List zCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + zSize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            yoVariableIndex += ySize;
            definition.setCoefficientsX(xCoeffs);
            definition.setCoefficientsY(yCoeffs);
            definition.setCoefficientsZ(zCoeffs);
            definition.setNumberOfCoefficientsX(xNumberOfCoeffs);
            definition.setNumberOfCoefficientsY(yNumberOfCoeffs);
            definition.setNumberOfCoefficientsZ(zNumberOfCoeffs);
            definition.setStartTime(0.0);
            definition.setEndTime(yoVariables[yoVariableIndex].getFullNameString());
            definition.setVisible(yoGraphicPolynomial3D.isGraphicObjectShowing());
            return definition;
        }
        YoGraphicGroupDefinition groupDefinition = new YoGraphicGroupDefinition();
        groupDefinition.setName(yoGraphicPolynomial3D.getName());
        groupDefinition.setChildren(new ArrayList());
        YoVariable[] waypointTimes = Arrays.copyOfRange(yoVariables, yoVariables.length - 3 - numberOfPolynomials, yoVariables.length - 3 + 1);
        for (int i = 0; i < numberOfPolynomials; ++i) {
            YoGraphicPolynomial3DDefinition definition = new YoGraphicPolynomial3DDefinition();
            definition.setName(yoGraphicPolynomial3D.getName() + Integer.toString(i));
            definition.setSize(constants[0]);
            int xSize = (int)polynomialSizes[0];
            String xNumberOfCoeffs = yoVariables[yoVariableIndex].getFullNameString();
            List xCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + xSize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            int ySize = (int)polynomialSizes[1];
            String yNumberOfCoeffs = yoVariables[yoVariableIndex += xSize].getFullNameString();
            List yCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + ySize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            int zSize = (int)polynomialSizes[2];
            String zNumberOfCoeffs = yoVariables[yoVariableIndex += ySize].getFullNameString();
            List zCoeffs = Stream.of(Arrays.copyOfRange(yoVariables, yoVariableIndex + 1, yoVariableIndex + 1 + zSize - 1)).map(YoVariable::getFullNameString).collect(Collectors.toList());
            yoVariableIndex += ySize;
            definition.setCoefficientsX(xCoeffs);
            definition.setCoefficientsY(yCoeffs);
            definition.setCoefficientsZ(zCoeffs);
            definition.setNumberOfCoefficientsX(xNumberOfCoeffs);
            definition.setNumberOfCoefficientsY(yNumberOfCoeffs);
            definition.setNumberOfCoefficientsZ(zNumberOfCoeffs);
            definition.setStartTime(i == 0 ? Double.toString(0.0) : waypointTimes[i - 1].getFullNameString());
            definition.setEndTime(waypointTimes[i].getFullNameString());
            definition.setVisible(yoGraphicPolynomial3D.isGraphicObjectShowing());
            groupDefinition.getChildren().add(definition);
        }
        return groupDefinition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicPosition yoGraphicPosition) {
        YoGraphicPoint3DDefinition definition = new YoGraphicPoint3DDefinition();
        definition.setName(yoGraphicPosition.getName());
        YoVariable[] yoVariables = yoGraphicPosition.getVariables();
        double[] constants = yoGraphicPosition.getConstants();
        YoTuple3DDefinition position = new YoTuple3DDefinition();
        position.setX(yoVariables[0].getFullNameString());
        position.setY(yoVariables[1].getFullNameString());
        position.setZ(yoVariables.length == 3 ? yoVariables[2].getFullNameString() : Double.toString(0.0));
        position.setReferenceFrame("worldFrame");
        definition.setPosition(position);
        definition.setSize(constants[0]);
        definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_3D_SPHERE_URL));
        definition.setColor(SCS1GraphicConversionTools.toColorDefinition(yoGraphicPosition.getAppearance()));
        definition.setVisible(yoGraphicPosition.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicTriangle yoGraphicTriangle) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicVector yoGraphicVector) {
        if (yoGraphicVector instanceof YoGraphicLineSegment) {
            return SCS1GraphicConversionTools.toYoGraphicDefinition((YoGraphicLineSegment)yoGraphicVector);
        }
        YoGraphicArrow3DDefinition definition = new YoGraphicArrow3DDefinition();
        definition.setName(yoGraphicVector.getName());
        YoDouble[] yoVariables = yoGraphicVector.getVariables();
        double[] constants = yoGraphicVector.getConstants();
        definition.setOrigin(SCS1GraphicConversionTools.toYoTuple3DDefinition((YoVariable[])yoVariables, 0));
        definition.setDirection(SCS1GraphicConversionTools.toYoTuple3DDefinition((YoVariable[])yoVariables, 3));
        double scale = constants[0];
        definition.setBodyLength(0.9 * scale);
        definition.setHeadLength(0.1 * scale);
        definition.setBodyRadius(0.015 * scale);
        definition.setHeadRadius(0.0375 * scale);
        definition.setScaleLength(true);
        definition.setScaleRadius(true);
        definition.setColor(SCS1GraphicConversionTools.toColorDefinition(yoGraphicVector.getAppearance()));
        definition.setVisible(yoGraphicVector.isGraphicObjectShowing());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoGraphicLineSegment yoGraphicLineSegment) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        YoGraphicDefinition definition = null;
        if (artifact instanceof YoArtifactLine2d) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoArtifactLine2d)artifact);
        } else if (artifact instanceof YoArtifactLineSegment2d) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoArtifactLineSegment2d)artifact);
        } else if (artifact instanceof YoArtifactOval) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoArtifactOval)artifact);
        } else if (artifact instanceof YoArtifactPolygon) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoArtifactPolygon)artifact);
        } else if (artifact instanceof YoArtifactPosition) {
            definition = SCS1GraphicConversionTools.toYoGraphicDefinition((YoArtifactPosition)artifact);
        } else {
            LogTools.error((String)("Unsupported YoArtifact type: " + artifact));
            return null;
        }
        definition.setName(artifact.getID());
        definition.setVisible(artifact.isVisible());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoArtifactLine2d yoArtifactLine2d) {
        YoGraphicLine2DDefinition definition = new YoGraphicLine2DDefinition();
        definition.setName(yoArtifactLine2d.getName());
        YoVariable[] yoVariables = yoArtifactLine2d.getVariables();
        definition.setOrigin(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, 0));
        definition.setDirection(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, 2));
        definition.setStrokeColor(SCS1GraphicConversionTools.toColorDefinition(yoArtifactLine2d.getAppearance()));
        definition.setStrokeWidth(1.5);
        definition.setVisible(yoArtifactLine2d.isVisible());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoArtifactLineSegment2d yoArtifactLineSegment2d) {
        YoGraphicLine2DDefinition definition = new YoGraphicLine2DDefinition();
        definition.setName(yoArtifactLineSegment2d.getName());
        YoVariable[] yoVariables = yoArtifactLineSegment2d.getVariables();
        definition.setOrigin(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, 0));
        definition.setDestination(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, 2));
        definition.setStrokeColor(SCS1GraphicConversionTools.toColorDefinition(yoArtifactLineSegment2d.getAppearance()));
        definition.setStrokeWidth(1.5);
        definition.setVisible(yoArtifactLineSegment2d.isVisible());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoArtifactOval yoArtifactOval) {
        return null;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoArtifactPolygon yoArtifactPolygon) {
        YoGraphicPolygon2DDefinition definition = new YoGraphicPolygon2DDefinition();
        definition.setName(yoArtifactPolygon.getName());
        YoVariable[] yoVariables = yoArtifactPolygon.getVariables();
        int yoVariableIndex = 0;
        definition.setNumberOfVertices(yoVariables[yoVariableIndex++].getFullNameString());
        definition.setVertices(new ArrayList());
        for (int i = 1; i < yoVariables.length; i += 2) {
            definition.getVertices().add(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoVariables, i));
        }
        if (yoArtifactPolygon.getConstants()[0] == 1.0) {
            definition.setFillColor(SCS1GraphicConversionTools.toColorDefinition(yoArtifactPolygon.getAppearance()));
        }
        definition.setStrokeColor(SCS1GraphicConversionTools.toColorDefinition(yoArtifactPolygon.getAppearance()));
        definition.setStrokeWidth(1.5);
        definition.setVisible(yoArtifactPolygon.isVisible());
        return definition;
    }

    public static YoGraphicDefinition toYoGraphicDefinition(YoArtifactPosition yoArtifactPosition) {
        YoGraphicPoint2DDefinition definition = new YoGraphicPoint2DDefinition();
        definition.setName(yoArtifactPosition.getName());
        definition.setPosition(SCS1GraphicConversionTools.toYoTuple2DDefinition(yoArtifactPosition.getVariables(), 0));
        definition.setSize(2.0 * yoArtifactPosition.getConstants()[0]);
        int graphicTypeIndex = (int)yoArtifactPosition.getConstants()[1];
        if (graphicTypeIndex >= 0 && graphicTypeIndex < YoGraphicPosition.GraphicType.values().length) {
            switch (YoGraphicPosition.GraphicType.values()[graphicTypeIndex]) {
                case BALL: 
                case SOLID_BALL: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_URL));
                    break;
                }
                case CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_PLUS_URL));
                    break;
                }
                case BALL_WITH_CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_PLUS_URL));
                    break;
                }
                case ROTATED_CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_CROSS_URL));
                    break;
                }
                case BALL_WITH_ROTATED_CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_CIRCLE_CROSS_URL));
                    break;
                }
                case DIAMOND: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_DIAMOND_URL));
                    break;
                }
                case DIAMOND_WITH_CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_DIAMOND_PLUS_URL));
                    break;
                }
                case SQUARE: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_SQUARE_URL));
                    break;
                }
                case SQUARE_WITH_CROSS: {
                    definition.setGraphicName(YoGraphicFXResourceManager.graphicName(SessionVisualizerIOTools.GRAPHIC_2D_SQUARE_CROSS_URL));
                    break;
                }
                case ELLIPSOID: {
                    definition.setGraphicName(null);
                }
            }
        }
        definition.setStrokeColor(SCS1GraphicConversionTools.toColorDefinition(yoArtifactPosition.getAppearance()));
        definition.setStrokeWidth(1.5);
        definition.setVisible(yoArtifactPosition.isVisible());
        return definition;
    }

    public static ColorDefinition toColorDefinition(AppearanceDefinition appearanceDefinition) {
        ColorDefinition definition = new ColorDefinition();
        definition.setAlpha(1.0 - appearanceDefinition.getTransparency());
        if (appearanceDefinition instanceof YoAppearanceMaterial) {
            YoAppearanceMaterial yoAppearanceMaterial = (YoAppearanceMaterial)appearanceDefinition;
            definition.setRed((double)yoAppearanceMaterial.getDiffuseColor().getX());
            definition.setGreen((double)yoAppearanceMaterial.getDiffuseColor().getY());
            definition.setBlue((double)yoAppearanceMaterial.getDiffuseColor().getZ());
        } else if (appearanceDefinition instanceof YoAppearanceRGBColor) {
            YoAppearanceRGBColor yoAppearanceRGBColor = (YoAppearanceRGBColor)appearanceDefinition;
            definition.setRed((double)yoAppearanceRGBColor.getRed());
            definition.setGreen((double)yoAppearanceRGBColor.getGreen());
            definition.setBlue((double)yoAppearanceRGBColor.getBlue());
        } else {
            LogTools.error((String)("Unsupported appearance: " + appearanceDefinition));
        }
        return definition;
    }

    public static YoTuple3DDefinition toYoTuple3DDefinition(YoVariable[] variables, int startIndex) {
        return SCS1GraphicConversionTools.toYoTuple3DDefinition(variables[startIndex++], variables[startIndex++], variables[startIndex]);
    }

    public static YoTuple3DDefinition toYoTuple3DDefinition(YoVariable x, YoVariable y, YoVariable z) {
        YoTuple3DDefinition position = new YoTuple3DDefinition();
        position.setX(x.getFullNameString());
        position.setY(y.getFullNameString());
        position.setZ(z.getFullNameString());
        position.setReferenceFrame("worldFrame");
        return position;
    }

    public static YoTuple2DDefinition toYoTuple2DDefinition(YoVariable[] variables, int startIndex) {
        return SCS1GraphicConversionTools.toYoTuple2DDefinition(variables[startIndex++], variables[startIndex]);
    }

    public static YoTuple2DDefinition toYoTuple2DDefinition(YoVariable x, YoVariable y) {
        YoTuple2DDefinition position = new YoTuple2DDefinition();
        position.setX(x.getFullNameString());
        position.setY(y.getFullNameString());
        position.setReferenceFrame("worldFrame");
        return position;
    }

    public static YoYawPitchRollDefinition toYoYawPitchRollDefinition(YoVariable[] variables, int startIndex) {
        return SCS1GraphicConversionTools.toYoYawPitchRollDefinition(variables[startIndex++], variables[startIndex++], variables[startIndex]);
    }

    public static YoYawPitchRollDefinition toYoYawPitchRollDefinition(YoVariable yaw, YoVariable pitch, YoVariable roll) {
        YoYawPitchRollDefinition orientation = new YoYawPitchRollDefinition();
        orientation.setYaw(yaw.getFullNameString());
        orientation.setPitch(pitch.getFullNameString());
        orientation.setRoll(roll.getFullNameString());
        orientation.setReferenceFrame("worldFrame");
        return orientation;
    }

    public static YoQuaternionDefinition toYoQuaternionDefinition(YoVariable[] variables, int startIndex) {
        return SCS1GraphicConversionTools.toYoQuaternionDefinition(variables[startIndex++], variables[startIndex++], variables[startIndex++], variables[startIndex]);
    }

    public static YoQuaternionDefinition toYoQuaternionDefinition(YoVariable qx, YoVariable qy, YoVariable qz, YoVariable qs) {
        YoQuaternionDefinition orientation = new YoQuaternionDefinition();
        orientation.setX(qx.getFullNameString());
        orientation.setY(qy.getFullNameString());
        orientation.setZ(qz.getFullNameString());
        orientation.setS(qs.getFullNameString());
        orientation.setReferenceFrame("worldFrame");
        return orientation;
    }
}

