/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem;

import java.util.List;
import java.util.concurrent.Executor;
import javafx.scene.Node;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.yoVariables.tools.YoMultiBodySystemFactories;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXRigidBody;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JavaFXMultiBodySystemFactories {
    public static JavaFXRigidBody toJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition) {
        return JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem(originalRootBody, cloneStationaryFrame, robotDefinition, MultiBodySystemFactories.DEFAULT_JOINT_BUILDER);
    }

    public static JavaFXRigidBody toJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition, Executor graphicLoader) {
        return JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem(originalRootBody, cloneStationaryFrame, robotDefinition, MultiBodySystemFactories.DEFAULT_JOINT_BUILDER, graphicLoader);
    }

    public static JavaFXRigidBody toYoJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition, YoRegistry registry) {
        return JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem(originalRootBody, cloneStationaryFrame, robotDefinition, YoMultiBodySystemFactories.newYoJointBuilder((YoRegistry)registry), null);
    }

    public static JavaFXRigidBody toYoJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition, YoRegistry registry, Executor graphicLoader) {
        return JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem(originalRootBody, cloneStationaryFrame, robotDefinition, YoMultiBodySystemFactories.newYoJointBuilder((YoRegistry)registry), graphicLoader);
    }

    public static JavaFXRigidBody toJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition, MultiBodySystemFactories.JointBuilder jointBuilder) {
        return JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem(originalRootBody, cloneStationaryFrame, robotDefinition, jointBuilder, null);
    }

    public static JavaFXRigidBody toJavaFXMultiBodySystem(RigidBodyReadOnly originalRootBody, ReferenceFrame cloneStationaryFrame, RobotDefinition robotDefinition, MultiBodySystemFactories.JointBuilder jointBuilder, Executor graphicLoader) {
        return (JavaFXRigidBody)MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)originalRootBody, (ReferenceFrame)cloneStationaryFrame, (String)"", (MultiBodySystemFactories.RigidBodyBuilder)JavaFXMultiBodySystemFactories.newJavaFXRigidBodyBuilder(robotDefinition, graphicLoader), (MultiBodySystemFactories.JointBuilder)jointBuilder);
    }

    public static MultiBodySystemFactories.RigidBodyBuilder newJavaFXRigidBodyBuilder(RobotDefinition robotDefinition) {
        return JavaFXMultiBodySystemFactories.newJavaFXRigidBodyBuilder(robotDefinition, null);
    }

    public static MultiBodySystemFactories.RigidBodyBuilder newJavaFXRigidBodyBuilder(RobotDefinition robotDefinition, Executor graphicLoader) {
        return JavaFXMultiBodySystemFactories.newJavaFXRigidBodyBuilder(MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, robotDefinition, graphicLoader, robotDefinition.getResourceClassLoader());
    }

    public static MultiBodySystemFactories.RigidBodyBuilder newJavaFXRigidBodyBuilder(MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, RobotDefinition robotDefinition) {
        return JavaFXMultiBodySystemFactories.newJavaFXRigidBodyBuilder(rigidBodyBuilder, robotDefinition, null, robotDefinition.getResourceClassLoader());
    }

    public static MultiBodySystemFactories.RigidBodyBuilder newJavaFXRigidBodyBuilder(final MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, final RobotDefinition robotDefinition, final Executor graphicLoader, final ClassLoader resourceClassLoader) {
        return new MultiBodySystemFactories.RigidBodyBuilder(){

            public JavaFXRigidBody buildRoot(String bodyName, RigidBodyTransform transformToParent, ReferenceFrame parentStationaryFrame) {
                RigidBodyBasics rootBody = rigidBodyBuilder.buildRoot(bodyName, transformToParent, parentStationaryFrame);
                return JavaFXMultiBodySystemFactories.toJavaFXRigidBody(rootBody, robotDefinition.getRigidBodyDefinition(rootBody.getName()), graphicLoader, resourceClassLoader);
            }

            public JavaFXRigidBody build(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransform inertiaPose) {
                RigidBodyBasics rigidBody = rigidBodyBuilder.build(bodyName, parentJoint, momentOfInertia, mass, inertiaPose);
                return JavaFXMultiBodySystemFactories.toJavaFXRigidBody(rigidBody, robotDefinition.getRigidBodyDefinition(rigidBody.getName()), graphicLoader, resourceClassLoader);
            }
        };
    }

    public static JavaFXRigidBody toJavaFXRigidBody(RigidBodyBasics rigidBody, RigidBodyDefinition rigidBodyDefinition, ClassLoader resourceClassLoader) {
        return JavaFXMultiBodySystemFactories.toJavaFXRigidBody(rigidBody, rigidBodyDefinition, null, resourceClassLoader);
    }

    public static JavaFXRigidBody toJavaFXRigidBody(RigidBodyBasics rigidBody, RigidBodyDefinition rigidBodyDefinition, Executor graphicLoader, ClassLoader resourceClassLoader) {
        JavaFXRigidBody javaFXRigidBody = new JavaFXRigidBody(rigidBody);
        List visualDefinitions = rigidBodyDefinition.getVisualDefinitions();
        if (graphicLoader != null) {
            graphicLoader.execute(() -> JavaFXMultiBodySystemFactories.loadRigidBodyGraphic(visualDefinitions, javaFXRigidBody, resourceClassLoader));
        } else {
            JavaFXMultiBodySystemFactories.loadRigidBodyGraphic(visualDefinitions, javaFXRigidBody, resourceClassLoader);
        }
        return javaFXRigidBody;
    }

    private static void loadRigidBodyGraphic(List<VisualDefinition> visualDefinitions, JavaFXRigidBody javaFXRigidBody, ClassLoader resourceClassLoader) {
        MovingReferenceFrame graphicFrame;
        Node graphicNode = JavaFXVisualTools.collectNodes(visualDefinitions, resourceClassLoader);
        MovingReferenceFrame movingReferenceFrame = graphicFrame = javaFXRigidBody.isRootBody() ? javaFXRigidBody.getBodyFixedFrame() : javaFXRigidBody.getParentJoint().getFrameAfterJoint();
        if (graphicNode != null) {
            javaFXRigidBody.setGraphics(new FrameNode((ReferenceFrame)graphicFrame, graphicNode));
        }
    }
}

