/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.remote;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.RemoteSession;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.SimpleYoVariablesUpdatedListener;

public class RemoteSessionFactory
implements SimpleYoVariablesUpdatedListener {
    private final ObjectProperty<RemoteSession> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);

    public void start(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
        this.activeSessionProperty.set((Object)new RemoteSession(yoVariableClientInterface, handshake, handshakeParser, debugRegistry));
    }

    public void receivedTimestampAndData(long timestamp) {
        RemoteSession activeSession = (RemoteSession)((Object)this.activeSessionProperty.get());
        if (activeSession != null) {
            activeSession.receivedTimestampAndData(timestamp);
        }
    }

    public void receivedTimestampOnly(long timestamp) {
        RemoteSession activeSession = (RemoteSession)((Object)this.activeSessionProperty.get());
        if (activeSession != null) {
            activeSession.receivedTimestampOnly(timestamp);
        }
    }

    public void receivedCommand(DataServerCommand command, int argument) {
        RemoteSession activeSession = (RemoteSession)((Object)this.activeSessionProperty.get());
        if (activeSession != null) {
            activeSession.receivedCommand(command, argument);
        }
    }

    public void unloadSession() {
        RemoteSession activeSession = (RemoteSession)((Object)this.activeSessionProperty.get());
        if (activeSession != null) {
            activeSession.shutdownSession();
            this.activeSessionProperty.set(null);
        }
    }

    public ReadOnlyObjectProperty<RemoteSession> activeSessionProperty() {
        return this.activeSessionProperty;
    }
}

