/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class TimestampScrubberTest {
    private VideoDataReader.TimestampScrubber scrubber;
    private long[] robotTimestamps;
    private long[] videoTimestamps;

    @BeforeEach
    public void loadFileTimestamps() throws URISyntaxException, IOException {
        File timestampFile = new File(Objects.requireNonNull(this.getClass().getClassLoader().getResource("sessionLogs/Capture.dat")).toURI());
        this.scrubber = new VideoDataReader.TimestampScrubber(timestampFile, true, false);
        this.robotTimestamps = this.scrubber.getRobotTimestampsArray();
        this.videoTimestamps = this.scrubber.getVideoTimestampsArray();
    }

    @Test
    public void testChronologicallyIncreasingRobotTimestamps() {
        for (int i = 1; i < this.robotTimestamps.length; ++i) {
            long currentTimestamp = this.robotTimestamps[i];
            long previousTimestamp = this.robotTimestamps[i - 1];
            if (currentTimestamp == previousTimestamp) continue;
            Assertions.assertTrue((currentTimestamp > previousTimestamp ? 1 : 0) != 0, (String)("Cureent: " + currentTimestamp + "\n Previous: " + previousTimestamp));
        }
    }

    @Test
    public void testStandardDeviationBetweenRobotTimestamps() {
        StandardDeviation standardDeviation = new StandardDeviation();
        double[] copyRobotTimestamps = new double[this.robotTimestamps.length];
        for (int i = 1; i < this.robotTimestamps.length; ++i) {
            long currentDelta = this.robotTimestamps[i] - this.robotTimestamps[i - 1];
            copyRobotTimestamps[i - 1] = currentDelta;
        }
        System.out.println("robotTimestamps Length: " + this.robotTimestamps.length);
        System.out.println("copyOfRobotTimestamps Length: " + copyRobotTimestamps.length);
        System.out.println("Standard Deviation: " + (long)standardDeviation.evaluate(copyRobotTimestamps));
    }

    @Disabled
    @Test
    public void testDeltaStatisticsBetweenRobotTimestamps() {
        long delta = 0L;
        long smallestDelta = 1000000000L;
        long largestDelta = 0L;
        int duplicates = 0;
        for (int i = 1; i < this.robotTimestamps.length; ++i) {
            long currentTimestamp = this.robotTimestamps[i];
            long previousTimestamp = this.robotTimestamps[i - 1];
            Assertions.assertTrue((currentTimestamp > previousTimestamp ? 1 : 0) != 0, (String)("Cureent: " + currentTimestamp + "\n Previous: " + previousTimestamp));
            long currentDelta = currentTimestamp - previousTimestamp;
            delta += currentDelta;
            if (currentDelta < smallestDelta) {
                smallestDelta = currentDelta;
            }
            if (currentDelta <= largestDelta) continue;
            largestDelta = currentDelta;
        }
        System.out.println("Smallest Delta: " + smallestDelta);
        System.out.println("Largest Delta: " + largestDelta);
        System.out.println("Duplicate robotTimestamps: " + duplicates);
        System.out.println("Average delta for robotTimestamps: " + (delta /= (long)(this.robotTimestamps.length - duplicates)));
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsInOrder() {
        for (int i = 0; i < this.robotTimestamps.length; ++i) {
            this.scrubber.getVideoTimestamp(this.robotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[i]);
        }
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsEveryOther() {
        for (int i = 0; i < this.robotTimestamps.length; i += 2) {
            this.scrubber.getVideoTimestamp(this.robotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[i], (String)("For look index: " + i));
        }
    }

    @Disabled
    @Test
    public void testGettingRandomTimestamp() {
        this.scrubber.getVideoTimestamp(this.robotTimestamps[26]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[26]);
        this.scrubber.getVideoTimestamp(this.robotTimestamps[40]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[40]);
        this.scrubber.getVideoTimestamp(this.robotTimestamps[34]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[34]);
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsBackwards() {
        for (int i = this.robotTimestamps.length - 1; i > 0; --i) {
            this.scrubber.getVideoTimestamp(this.robotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.videoTimestamps[i]);
        }
    }

    public boolean robotTimestampIsNotUnique(int index) {
        boolean checkPrevious = false;
        boolean checkNext = false;
        if (index - 1 > 0) {
            boolean bl = checkPrevious = this.robotTimestamps[index] == this.robotTimestamps[index - 1];
        }
        if (index + 1 < this.robotTimestamps.length) {
            checkNext = this.robotTimestamps[index] == this.robotTimestamps[index + 1];
        }
        return checkPrevious || checkNext;
    }

    @Test
    public void testSearchRobotTimestampsForIndex() {
        this.scrubber.getVideoTimestamp(Long.MAX_VALUE);
        int endOfArray = this.scrubber.getCurrentIndex();
        Assertions.assertEquals((int)(this.robotTimestamps.length - 1), (int)endOfArray);
    }

    @Test
    public void testFileNotFoundException() {
        File badName = new File("This_is_a_bad_file_name_lol");
        Throwable thrown = Assertions.assertThrows(RuntimeException.class, () -> new VideoDataReader.TimestampScrubber(badName, true, false));
        String messageException = thrown.getMessage().substring(0, 58);
        Assertions.assertEquals((Object)("java.io.FileNotFoundException: " + badName), (Object)messageException);
    }

    @Test
    public void testInsertionPointWhenSearching() {
        this.scrubber.getVideoTimestamp(this.robotTimestamps[0] + 1L);
        int insertionPointIndex = this.scrubber.getCurrentIndex();
        Assertions.assertEquals((int)1, (int)insertionPointIndex);
    }
}

