/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class TimestampScrubberTest {
    private VideoDataReader.TimestampScrubber scrubber;
    private long[] actualRobotTimestamps;
    private long[] actualVideoTimestamps;

    @BeforeEach
    public void loadFileTimestamps() throws URISyntaxException, IOException {
        File timestampFile = new File(Objects.requireNonNull(this.getClass().getClassLoader().getResource("sessionLogs/NadiaPoleNorth_Timestamps.dat")).toURI());
        this.scrubber = new VideoDataReader.TimestampScrubber(timestampFile, true, false);
        this.actualRobotTimestamps = this.scrubber.getRobotTimestampsFromFile();
        this.actualVideoTimestamps = this.scrubber.getVideoTimestampsFromFile();
    }

    @Test
    public void testChronologicallyIncreasingRobotTimestamps() {
        for (int i = 1; i < this.actualRobotTimestamps.length; ++i) {
            long currentTimestamp = this.actualRobotTimestamps[i];
            long previousTimestamp = this.actualRobotTimestamps[i - 1];
            if (currentTimestamp == previousTimestamp) continue;
            Assertions.assertTrue((currentTimestamp > previousTimestamp ? 1 : 0) != 0, (String)("Cureent: " + currentTimestamp + "\n Previous: " + previousTimestamp));
        }
    }

    @Test
    public void testStandardDeviationBetweenRobotTimestamps() {
        StandardDeviation standardDeviation = new StandardDeviation();
        double[] copyRobotTimestamps = new double[this.actualRobotTimestamps.length];
        for (int i = 1; i < this.actualRobotTimestamps.length; ++i) {
            long currentDelta = this.actualRobotTimestamps[i] - this.actualRobotTimestamps[i - 1];
            copyRobotTimestamps[i - 1] = currentDelta;
        }
        System.out.println("robotTimestamps Length: " + this.actualRobotTimestamps.length);
        System.out.println("copyOfRobotTimestamps Length: " + copyRobotTimestamps.length);
        System.out.println("Standard Deviation: " + (long)standardDeviation.evaluate(copyRobotTimestamps));
    }

    @Disabled
    @Test
    public void testDeltaStatisticsBetweenRobotTimestamps() {
        long delta = 0L;
        long smallestDelta = 1000000000L;
        long largestDelta = 0L;
        int duplicates = 0;
        for (int i = 1; i < this.actualRobotTimestamps.length; ++i) {
            long currentTimestamp = this.actualRobotTimestamps[i];
            long previousTimestamp = this.actualRobotTimestamps[i - 1];
            Assertions.assertTrue((currentTimestamp > previousTimestamp ? 1 : 0) != 0, (String)("Cureent: " + currentTimestamp + "\n Previous: " + previousTimestamp));
            long currentDelta = currentTimestamp - previousTimestamp;
            delta += currentDelta;
            if (currentDelta < smallestDelta) {
                smallestDelta = currentDelta;
            }
            if (currentDelta <= largestDelta) continue;
            largestDelta = currentDelta;
        }
        System.out.println("Smallest Delta: " + smallestDelta);
        System.out.println("Largest Delta: " + largestDelta);
        System.out.println("Duplicate robotTimestamps: " + duplicates);
        System.out.println("Average delta for robotTimestamps: " + (delta /= (long)(this.actualRobotTimestamps.length - duplicates)));
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsInOrder() {
        for (int i = 0; i < this.actualRobotTimestamps.length; ++i) {
            this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[i]);
        }
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsEveryOther() {
        for (int i = 0; i < this.actualRobotTimestamps.length; i += 2) {
            this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[i], (String)("For look index: " + i));
        }
    }

    @Disabled
    @Test
    public void testGettingRandomTimestamp() {
        this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[26]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[26]);
        this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[40]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[40]);
        this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[34]);
        Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[34]);
    }

    @Disabled
    @Test
    public void testGoingThroughRobotTimestampsBackwards() {
        for (int i = this.actualRobotTimestamps.length - 1; i > 0; --i) {
            this.scrubber.getVideoTimestamp(this.actualRobotTimestamps[i]);
            Assertions.assertEquals((long)this.scrubber.getCurrentVideoTimestamp(), (long)this.actualVideoTimestamps[i]);
        }
    }

    public boolean robotTimestampIsNotUnique(int index) {
        boolean checkPrevious = false;
        boolean checkNext = false;
        if (index - 1 > 0) {
            boolean bl = checkPrevious = this.actualRobotTimestamps[index] == this.actualRobotTimestamps[index - 1];
        }
        if (index + 1 < this.actualRobotTimestamps.length) {
            checkNext = this.actualRobotTimestamps[index] == this.actualRobotTimestamps[index + 1];
        }
        return checkPrevious || checkNext;
    }
}

