/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.StringPair;

public class Metadata
implements MCAPElement {
    private final String name;
    private final List<StringPair> metadata;
    private final int metadataLength;

    Metadata(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        dataInput.position(elementPosition);
        this.name = dataInput.getString();
        long start = dataInput.position();
        this.metadata = MCAP.parseList(dataInput, StringPair::new);
        this.metadataLength = (int)(dataInput.position() - start);
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public long getElementLength() {
        return 4 + this.name.length() + this.metadataLength;
    }

    public String name() {
        return this.name;
    }

    public List<StringPair> metadata() {
        return this.metadata;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putString(this.name);
        dataOutput.putCollection(this.metadata);
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addString(this.name);
        crc32.addCollection(this.metadata);
        return crc32;
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-name = " + this.name();
        out = out + "\n\t-metadata = " + EuclidCoreIOTools.getCollectionString((String)", ", this.metadata(), e -> e.key());
        return out;
    }

    public boolean equals(Object object) {
        Metadata other;
        return object instanceof Metadata && this.equals(other = (Metadata)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Metadata) {
            Metadata other = (Metadata)mcapElement;
            if (!this.name().equals(other.name())) {
                return false;
            }
            return Objects.equals(this.metadata(), other.metadata());
        }
        return false;
    }
}

