/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexEntry;

public interface MessageIndex
extends MCAPElement {
    public int channelId();

    public List<MessageIndexEntry> messageIndexEntries();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedShort(this.channelId());
        dataOutput.putCollection(this.messageIndexEntries());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedShort(this.channelId());
        crc32.addCollection(this.messageIndexEntries());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-channelId = " + this.channelId();
        List<MessageIndexEntry> messageIndexEntries = this.messageIndexEntries();
        out = out + "\n\t-messageIndexEntries = " + (String)(messageIndexEntries == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", messageIndexEntries, e -> e.toString(indent + 1)));
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof MessageIndex) {
            MessageIndex other = (MessageIndex)mcapElement;
            if (this.channelId() != other.channelId()) {
                return false;
            }
            return Objects.equals(this.messageIndexEntries(), other.messageIndexEntries());
        }
        return false;
    }
}

