/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Message;

class MessageDataInputBacked
implements Message {
    private final MCAPDataInput dataInput;
    private final int channelId;
    private final long sequence;
    private final long logTime;
    private final long publishTime;
    private final long dataOffset;
    private final int dataLength;
    private WeakReference<ByteBuffer> messageBufferRef;
    private WeakReference<byte[]> messageDataRef;

    MessageDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        dataInput.position(elementPosition);
        this.channelId = dataInput.getUnsignedShort();
        this.sequence = dataInput.getUnsignedInt();
        this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
        this.publishTime = MCAP.checkPositiveLong(dataInput.getLong(), "publishTime");
        this.dataOffset = dataInput.position();
        this.dataLength = (int)(elementLength - 22L);
        MCAP.checkLength(elementLength, this.getElementLength());
    }

    @Override
    public int channelId() {
        return this.channelId;
    }

    @Override
    public long sequence() {
        return this.sequence;
    }

    @Override
    public long logTime() {
        return this.logTime;
    }

    @Override
    public long publishTime() {
        return this.publishTime;
    }

    @Override
    public long dataOffset() {
        return this.dataOffset;
    }

    @Override
    public int dataLength() {
        return this.dataLength;
    }

    @Override
    public ByteBuffer messageBuffer() {
        ByteBuffer messageBuffer;
        ByteBuffer byteBuffer = messageBuffer = this.messageBufferRef == null ? null : (ByteBuffer)this.messageBufferRef.get();
        if (messageBuffer == null) {
            messageBuffer = this.dataInput.getByteBuffer(this.dataOffset, this.dataLength, false);
            this.messageBufferRef = new WeakReference<ByteBuffer>(messageBuffer);
        }
        return messageBuffer;
    }

    @Override
    public byte[] messageData() {
        byte[] messageData;
        byte[] byArray = messageData = this.messageDataRef == null ? null : (byte[])this.messageDataRef.get();
        if (messageData == null) {
            messageData = this.dataInput.getBytes(this.dataOffset, this.dataLength);
            this.messageDataRef = new WeakReference<byte[]>(messageData);
        }
        return messageData;
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-channelId = " + this.channelId;
        out = out + "\n\t-sequence = " + this.sequence;
        out = out + "\n\t-logTime = " + this.logTime;
        out = out + "\n\t-publishTime = " + this.publishTime;
        return out;
    }

    public boolean equals(Object object) {
        Message other;
        return object instanceof Message && Message.super.equals(other = (Message)object);
    }
}

