/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.Footer;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MutableRecord;
import us.ihmc.scs2.session.mcap.specs.records.MutableStatistics;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.session.mcap.specs.records.SummaryOffset;

public class MCAPSummaryBuilder {
    private final Map<Integer, Record> schemas = new LinkedHashMap<Integer, Record>();
    private final Map<Integer, Record> channels = new LinkedHashMap<Integer, Record>();
    private final List<Record> chunkIndices = new ArrayList<Record>();
    private final List<Record> attachmentIndices = new ArrayList<Record>();
    private final List<Record> metadataIndices = new ArrayList<Record>();
    private final Map<Opcode, List<Record>> indexMap = Map.of(Opcode.CHUNK_INDEX, this.chunkIndices, Opcode.ATTACHMENT_INDEX, this.attachmentIndices, Opcode.METADATA_INDEX, this.metadataIndices);
    private final MutableStatistics statistics = new MutableStatistics();

    public void update(Record record) {
        boolean isNewRecord;
        switch (record.op()) {
            case SCHEMA: {
                boolean bl;
                Schema schema = (Schema)record.body();
                if (this.schemas.put(schema.id(), record) == null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case CHANNEL: {
                boolean bl;
                Channel channel = (Channel)record.body();
                if (this.channels.put(channel.id(), record) == null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case CHUNK_INDEX: 
            case ATTACHMENT_INDEX: 
            case METADATA_INDEX: {
                this.indexMap.get((Object)record.op()).add(record);
                boolean bl = false;
                break;
            }
            case ATTACHMENT: 
            case METADATA: {
                boolean bl = true;
                break;
            }
            case CHUNK: {
                Chunk chunk = (Chunk)record.body();
                this.statistics.updateMessageTimes(chunk.messageStartTime(), chunk.messageEndTime());
                for (Record chunkRecords : chunk.records()) {
                    this.update(chunkRecords);
                }
                boolean bl = true;
                break;
            }
            case MESSAGE: {
                Message message = (Message)record.body();
                this.statistics.incrementChannelMessageCount(message.channelId());
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = isNewRecord = false;
            }
        }
        if (isNewRecord) {
            this.statistics.incrementCount(record.op());
        }
    }

    public void writeSummary(MCAPDataOutput dataOutput) {
        MCAPSummaryBuilder.finalizeMCAP(dataOutput, this.schemas.values(), this.channels.values(), this.chunkIndices, this.attachmentIndices, this.metadataIndices, new MutableRecord(this.statistics));
    }

    public static void finalizeMCAP(MCAPDataOutput dataOutput, Collection<? extends Record> allSchemas, Collection<? extends Record> allChannels, Collection<? extends Record> allChunkIndices, Collection<? extends Record> allAttachmentIndices, Collection<? extends Record> allMetadataIndices, Record statistics) {
        List<Record> schemaList = MCAPSummaryBuilder.toList(allSchemas);
        List<Record> channelList = MCAPSummaryBuilder.toList(allChannels);
        List<Record> chunkIndexList = MCAPSummaryBuilder.toList(allChunkIndices);
        List<Record> attachmentIndexList = MCAPSummaryBuilder.toList(allAttachmentIndices);
        List<Record> metadataIndexList = MCAPSummaryBuilder.toList(allMetadataIndices);
        long summarySectionOffset = dataOutput.position();
        long schemaOffset = dataOutput.position();
        schemaList.forEach(r -> r.write(dataOutput));
        long channelOffset = dataOutput.position();
        channelList.forEach(r -> r.write(dataOutput));
        long chunkIndexOffset = dataOutput.position();
        chunkIndexList.forEach(r -> r.write(dataOutput));
        long attachmentIndexOffset = dataOutput.position();
        attachmentIndexList.forEach(r -> r.write(dataOutput));
        long metadataIndexOffset = dataOutput.position();
        metadataIndexList.forEach(r -> r.write(dataOutput));
        long statisticsOffset = dataOutput.position();
        statistics.write(dataOutput);
        ArrayList<Record> summaryOffsetSectionRecords = new ArrayList<Record>();
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, schemaOffset, schemaList, summaryOffsetSectionRecords);
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, channelOffset, channelList, summaryOffsetSectionRecords);
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, chunkIndexOffset, chunkIndexList, summaryOffsetSectionRecords);
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, attachmentIndexOffset, attachmentIndexList, summaryOffsetSectionRecords);
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, metadataIndexOffset, metadataIndexList, summaryOffsetSectionRecords);
        MCAPSummaryBuilder.writeSummaryOffset(dataOutput, statisticsOffset, Collections.singletonList(statistics), summaryOffsetSectionRecords);
        List summarySectionRecords = MCAPSummaryBuilder.combine(schemaList, channelList, chunkIndexList, attachmentIndexList, metadataIndexList, List.of(statistics));
        MutableRecord footer = new MutableRecord(new Footer(summarySectionOffset, summarySectionRecords, summaryOffsetSectionRecords));
        footer.write(dataOutput);
    }

    private static <T> List<T> combine(List<T> ... lists) {
        if (lists == null || lists.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> combinedList = new ArrayList<T>(Stream.of(lists).mapToInt(List::size).sum());
        for (List<T> list : lists) {
            combinedList.addAll(list);
        }
        return combinedList;
    }

    private static <T> List<T> toList(Collection<? extends T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return collection == null ? Collections.emptyList() : new ArrayList<T>(collection);
    }

    private static void writeSummaryOffset(MCAPDataOutput dataOutput, long groupOffset, List<Record> groupList, List<Record> summaryOffsetSectionRecordsToPack) {
        if (!groupList.isEmpty()) {
            MutableRecord summaryOffset = new MutableRecord(new SummaryOffset(groupOffset, groupList));
            summaryOffsetSectionRecordsToPack.add(summaryOffset);
            summaryOffset.write(dataOutput);
        }
    }
}

