/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.input;

import com.github.luben.zstd.ZstdDecompressCtx;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import us.ihmc.scs2.session.mcap.encoding.LZ4FrameDecoder;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.records.Compression;

public class MCAPByteBufferDataInput
implements MCAPDataInput {
    private final ByteBuffer buffer;

    MCAPByteBufferDataInput(ByteBuffer buffer) {
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void position(long position) {
        this.buffer.position((int)position);
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public long size() {
        return this.buffer.limit();
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public byte getByte() {
        return this.buffer.get();
    }

    @Override
    public void getBytes(byte[] bytes) {
        this.buffer.get(bytes);
    }

    @Override
    public byte[] getBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        this.buffer.get((int)offset, bytes);
        return bytes;
    }

    @Override
    public ByteBuffer getByteBuffer(long offset, int length, boolean direct) {
        ByteBuffer out = direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        out.put(0, this.buffer, (int)offset, length);
        out.position(0);
        out.limit(length);
        out.order(ByteOrder.LITTLE_ENDIAN);
        return out;
    }

    @Override
    public ByteBuffer getDecompressedByteBuffer(long offset, int compressedLength, int uncompressedLength, Compression compression, boolean direct) {
        ByteBuffer decompressedBuffer;
        if (compression == Compression.LZ4) {
            LZ4FrameDecoder lz4FrameDecoder = new LZ4FrameDecoder();
            decompressedBuffer = direct ? ByteBuffer.allocateDirect(uncompressedLength) : ByteBuffer.allocate(uncompressedLength);
            lz4FrameDecoder.decode(this.buffer, (int)offset, compressedLength, decompressedBuffer, 0);
        } else if (compression == Compression.ZSTD) {
            try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
                int previousPosition = this.buffer.position();
                int previousLimit = this.buffer.limit();
                this.buffer.limit((int)(offset + (long)compressedLength));
                this.buffer.position((int)offset);
                decompressedBuffer = zstdDecompressCtx.decompress(this.buffer, uncompressedLength);
                this.buffer.position(previousPosition);
                this.buffer.limit(previousLimit);
            }
        } else {
            throw new IllegalArgumentException("Unsupported compression: " + String.valueOf((Object)compression));
        }
        decompressedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return decompressedBuffer;
    }

    public String toString() {
        return "MCAPByteBufferDataInput{buffer=" + String.valueOf(this.buffer) + "}";
    }
}

