/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.bytedeco.javacv.Frame;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.logger.MagewellDemuxer;
import us.ihmc.robotDataLogger.logger.MagewellMuxer;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.log.TimestampScrubber;
import us.ihmc.tools.CaptureTimeTools;

public class MagewellScrubber {
    private final TimestampScrubber timestampScrubber;
    private final String name;
    private final MagewellDemuxer magewellDemuxer;
    private final Camera camera;
    private long currentVideoTimestamp;
    private long currentRobotTimestamp;

    public MagewellScrubber(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        File videoFile;
        this.camera = camera;
        this.name = camera.getNameAsString();
        boolean interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        if (!(videoFile = new File(dataDirectory, camera.getVideoFileAsString())).exists()) {
            throw new IOException("Cannot find video: " + String.valueOf(videoFile));
        }
        this.magewellDemuxer = new MagewellDemuxer(videoFile);
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.timestampScrubber = new TimestampScrubber(timestampFile, hasTimeBase, interlaced);
    }

    public int getImageHeight() {
        return this.magewellDemuxer.getImageHeight();
    }

    public int getImageWidth() {
        return this.magewellDemuxer.getImageWidth();
    }

    public Frame readVideoFrame(long queryRobotTimestamp) {
        this.currentVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(queryRobotTimestamp);
        this.currentRobotTimestamp = this.timestampScrubber.getCurrentRobotTimestamp();
        this.magewellDemuxer.seekToPTS(this.currentVideoTimestamp);
        return this.magewellDemuxer.getNextFrame();
    }

    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer progressConsumer) throws IOException {
        Frame frame;
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(endTimestamp);
        long[] robotTimestampsForCroppedLog = this.timestampScrubber.getCroppedRobotTimestamps(startTimestamp, endTimestamp);
        long[] videoTimestampsForCroppedLog = new long[robotTimestampsForCroppedLog.length];
        int i = 0;
        long startFrame = MagewellScrubber.getFrameAtTimestamp(startVideoTimestamp, this.magewellDemuxer);
        long endFrame = MagewellScrubber.getFrameAtTimestamp(endVideoTimestamp, this.magewellDemuxer);
        long numberOfFrames = endFrame - startFrame;
        int frameRate = (int)this.magewellDemuxer.getFrameRate();
        this.magewellDemuxer.seekToPTS(startVideoTimestamp);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println("1\n" + frameRate);
        long startTime = System.currentTimeMillis();
        MagewellMuxer magewellMuxer = new MagewellMuxer(outputFile, this.magewellDemuxer.getImageWidth(), this.magewellDemuxer.getImageHeight());
        magewellMuxer.start();
        while ((frame = this.magewellDemuxer.getNextFrame()) != null && (long)this.magewellDemuxer.getFrameNumber() <= endFrame) {
            long videoTimestamp = CaptureTimeTools.timeSinceStartedCaptureInMicroseconds((long)System.currentTimeMillis(), (long)startTime);
            magewellMuxer.recordFrame(frame, videoTimestamp);
            videoTimestampsForCroppedLog[i] = magewellMuxer.getTimeStamp();
            ++i;
            if (progressConsumer == null) continue;
            progressConsumer.info("frame %d/%d".formatted((long)this.magewellDemuxer.getFrameNumber() - startFrame, numberOfFrames));
            progressConsumer.progress((double)((long)this.magewellDemuxer.getFrameNumber() - startFrame) / (double)numberOfFrames);
        }
        for (i = 0; i < videoTimestampsForCroppedLog.length; ++i) {
            timestampWriter.print(robotTimestampsForCroppedLog[i]);
            timestampWriter.print(" ");
            timestampWriter.println(videoTimestampsForCroppedLog[i]);
        }
        magewellMuxer.close();
        timestampWriter.close();
    }

    private static long getFrameAtTimestamp(long endCameraTimestamp, MagewellDemuxer magewellDemuxer) {
        magewellDemuxer.seekToPTS(endCameraTimestamp);
        return magewellDemuxer.getFrameNumber();
    }

    public long getCurrentRobotTimestamp() {
        return this.currentRobotTimestamp;
    }

    public long getCurrentVideoTimestamp() {
        return this.currentVideoTimestamp;
    }

    public TimestampScrubber getTimestampScrubber() {
        return this.timestampScrubber;
    }

    public MagewellDemuxer getMagewellDemuxer() {
        return this.magewellDemuxer;
    }

    public String getName() {
        return this.name;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public int getCurrentIndex() {
        return this.timestampScrubber.getCurrentIndex();
    }

    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.timestampScrubber.getReplacedRobotTimestampIndex(index);
    }
}

